/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.text.DualTextEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(modid="lightmanscurrency", bus=EventBusSubscriber.Bus.MOD)
public class LCResourcePacks {
    private static final List<CustomResourcePack> packList = new ArrayList<CustomResourcePack>();

    private LCResourcePacks() {
    }

    public static void registerPack(@Nonnull String modid, @Nonnull String path, @Nonnull DualTextEntry text) {
        LCResourcePacks.registerPack(new CustomResourcePack(modid, path, (Component)text.first.get(new Object[0])));
    }

    public static void registerPack(@Nonnull String modid, @Nonnull String path, @Nonnull Component name) {
        LCResourcePacks.registerPack(new CustomResourcePack(modid, path, name));
    }

    public static void registerPack(@Nonnull CustomResourcePack pack) {
        if (packList.contains(pack)) {
            return;
        }
        packList.add(pack);
    }

    @SubscribeEvent
    public static void registerPackSource(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        for (CustomResourcePack pack : packList) {
            pack.addToRepository(p -> event.addRepositorySource(consumer -> consumer.accept(p)));
        }
    }

    static {
        LCResourcePacks.registerPack("lightmanscurrency", "RupeePack", LCText.RESOURCE_PACK_RUPEES);
        LCResourcePacks.registerPack("lightmanscurrency", "CloserItemsPack", LCText.RESOURCE_PACK_CLOSER_ITEMS);
        LCResourcePacks.registerPack("lightmanscurrency", "LegacyCoins", LCText.RESOURCE_PACK_LEGACY_COINS);
        LCResourcePacks.registerPack("lightmanscurrency", "FancyIcons", LCText.RESOURCE_PACK_FANCY_ICONS);
    }

    public static class CustomResourcePack {
        private final String modid;
        private final String path;
        private final Component name;

        public CustomResourcePack(@Nonnull String modid, @Nonnull String path, @Nonnull Component name) {
            this.modid = modid;
            this.path = path;
            this.name = name;
        }

        public void addToRepository(@Nonnull Consumer<Pack> consumer) {
            Path resourcePath = ModList.get().getModFileById(this.modid).getFile().findResource(new String[]{this.path});
            PackLocationInfo info = new PackLocationInfo("builtin/" + this.path, this.name, PackSource.BUILT_IN, Optional.empty());
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(resourcePath), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
            if (pack == null) {
                LightmansCurrency.LogWarning("Custom Resource Pack of '" + this.modid + "/" + this.path + " failed to load properly!");
            } else {
                consumer.accept(pack);
            }
        }
    }
}

