/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperty;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModelVariant {
    private boolean completelyInvalid = false;
    private boolean invalid = false;
    private final boolean dummy;
    @Nullable
    private final ResourceLocation parent;
    @Nullable
    private ModelVariant parentVariant = null;
    private final List<String> targetSelectors;
    private final List<ResourceLocation> targets;
    @Nullable
    private final Component name;
    @Nullable
    private final ResourceLocation item;
    private final List<ResourceLocation> models;
    private final Map<String, ResourceLocation> textureOverrides;
    private final Map<VariantProperty<?>, Object> properties;

    public boolean shouldRemove() {
        return this.completelyInvalid || this.parentVariant != null && this.parentVariant.shouldRemove();
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isInvalid() {
        return this.shouldRemove() || this.invalid || this.dummy;
    }

    public List<ResourceLocation> getTargets() {
        if (this.targets.isEmpty() && this.parentVariant != null) {
            return this.parentVariant.getTargets();
        }
        return this.targets;
    }

    public boolean isValidTarget(IVariantBlock block) {
        return this.getTargets().contains(block.getBlockID());
    }

    public boolean isValidTarget(Block block) {
        return this.getTargets().contains(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    public MutableComponent getName() {
        if (this.name == null && this.parentVariant != null) {
            return this.parentVariant.getName();
        }
        return this.name == null ? LCText.BLOCK_VARIANT_UNNAMED.get(new Object[0]) : this.name.copy();
    }

    @Nullable
    public ResourceLocation getItemModel() {
        if (this.item == null && this.parent != null) {
            return this.parentVariant == null ? null : this.parentVariant.getItemModel();
        }
        return this.item;
    }

    @Nullable
    public ItemStack getItemIcon() {
        return null;
    }

    public boolean hasModels() {
        return !this.getModels().isEmpty();
    }

    public List<ResourceLocation> getModels() {
        if (this.models.isEmpty() && this.parent != null) {
            return this.parentVariant == null ? ImmutableList.of() : this.parentVariant.getModels();
        }
        return this.models;
    }

    public boolean hasTextureOverrides() {
        return !this.getTextureOverrides().isEmpty();
    }

    public Map<String, ResourceLocation> getTextureOverrides() {
        if (this.parentVariant != null) {
            HashMap<String, ResourceLocation> combinedMap = new HashMap<String, ResourceLocation>(this.parentVariant.getTextureOverrides());
            combinedMap.putAll(this.textureOverrides);
            return ImmutableMap.copyOf(combinedMap);
        }
        return this.textureOverrides;
    }

    protected ModelVariant() {
        this(null, new ArrayList<ResourceLocation>(), new ArrayList<String>(), null, null, new ArrayList<ResourceLocation>(), new HashMap<String, ResourceLocation>(), new HashMap(), true);
    }

    private ModelVariant(@Nullable ResourceLocation parent, List<ResourceLocation> targets, @Nullable Component name, @Nullable ResourceLocation item, List<ResourceLocation> models, Map<String, ResourceLocation> textureOverrides, Map<VariantProperty<?>, Object> properties, boolean dummy) {
        this(parent, targets, (List<String>)ImmutableList.of(), name, item, models, textureOverrides, properties, dummy);
    }

    private ModelVariant(@Nullable ResourceLocation parent, List<ResourceLocation> targets, List<String> selectorTargets, @Nullable Component name, @Nullable ResourceLocation item, List<ResourceLocation> models, Map<String, ResourceLocation> textureOverrides, Map<VariantProperty<?>, Object> properties, boolean dummy) {
        this.parent = parent;
        this.targets = ImmutableList.copyOf(targets);
        this.targetSelectors = ImmutableList.copyOf(selectorTargets);
        this.name = name;
        this.item = item;
        this.models = ImmutableList.copyOf(models);
        this.textureOverrides = ImmutableMap.copyOf(textureOverrides);
        this.properties = ImmutableMap.copyOf(properties);
        this.dummy = dummy;
    }

    public boolean has(VariantProperty<?> property) {
        if (this.parentVariant != null && this.parentVariant.has(property)) {
            return true;
        }
        return this.properties.containsKey(property);
    }

    @Nullable
    public <T> T get(VariantProperty<T> property) {
        try {
            if (!this.properties.containsKey(property) && this.parentVariant != null) {
                return this.parentVariant.get(property);
            }
            return (T)this.properties.get(property);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public JsonObject write() {
        JsonArray array;
        JsonObject json = new JsonObject();
        if (this.parent != null) {
            json.addProperty("parent", this.parent.toString());
        }
        if (this.targets.size() == 1) {
            json.addProperty("target", this.targets.getFirst().toString());
        } else if (!this.targets.isEmpty()) {
            array = new JsonArray();
            for (ResourceLocation resourceLocation : this.targets) {
                array.add(resourceLocation.toString());
            }
            json.add("target", (JsonElement)array);
        }
        if (this.targetSelectors.size() == 1) {
            json.addProperty("targetSelector", this.targetSelectors.getFirst());
        } else if (!this.targetSelectors.isEmpty()) {
            array = new JsonArray();
            for (String string : this.targetSelectors) {
                array.add(string);
            }
            json.add("targetSelector", (JsonElement)array);
        }
        if (this.name != null) {
            json.add("name", (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.name).getOrThrow());
        }
        if (this.item != null) {
            json.addProperty("item", this.item.toString());
        }
        if (!this.models.isEmpty()) {
            JsonArray models = new JsonArray();
            for (ResourceLocation resourceLocation : this.models) {
                models.add(resourceLocation.toString());
            }
            json.add("models", (JsonElement)models);
        }
        if (!this.textureOverrides.isEmpty()) {
            JsonObject textures = new JsonObject();
            this.textureOverrides.forEach((key, texture) -> textures.addProperty(key, texture.toString()));
            json.add("textures", (JsonElement)textures);
        }
        this.properties.forEach((property, value) -> {
            try {
                JsonElement element = property.write(value);
                ResourceLocation id = property.getID();
                String field = id.getNamespace().equals("lightmanscurrency") ? id.getPath() : id.toString();
                json.add(field, element);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error writing Variant Property", e);
            }
        });
        if (this.dummy) {
            json.addProperty("dummy", Boolean.valueOf(true));
        }
        return json;
    }

    public static ModelVariant parse(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        ResourceLocation parent = null;
        if (json.has("parent")) {
            parent = VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"parent"));
        }
        ArrayList<ResourceLocation> targets = new ArrayList<ResourceLocation>();
        if (json.has("target")) {
            JsonElement targetElement = json.get("target");
            if (targetElement.isJsonPrimitive()) {
                targets.add(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"target")));
            } else {
                JsonArray array = GsonHelper.getAsJsonArray((JsonObject)json, (String)"target");
                for (int i = 0; i < array.size(); ++i) {
                    targets.add(VersionUtil.parseResource(GsonHelper.convertToString((JsonElement)array.get(i), (String)("target[" + i + "]"))));
                }
            }
        }
        if (json.has("targetSelector")) {
            ArrayList<TargetSelector> targetSelectors = new ArrayList<TargetSelector>();
            JsonElement targetElement = json.get("targetSelector");
            if (targetElement.isJsonPrimitive()) {
                targetSelectors.add(TargetSelector.parse(GsonHelper.getAsString((JsonObject)json, (String)"targetSelector")));
            } else {
                JsonArray array = GsonHelper.getAsJsonArray((JsonObject)json, (String)"targetSelector");
                for (int i = 0; i < array.size(); ++i) {
                    targetSelectors.add(TargetSelector.parse(GsonHelper.convertToString((JsonElement)array.get(i), (String)("targetSelector[" + i + "]"))));
                }
            }
            List<ResourceLocation> addedTargets = ModelVariant.testSelectors(targetSelectors);
            for (ResourceLocation added : ModelVariant.testSelectors(targetSelectors)) {
                if (targets.contains(added)) continue;
                targets.add(added);
            }
        }
        Component name = null;
        if (json.has("name")) {
            name = (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("name")).getOrThrow(JsonSyntaxException::new)).getFirst();
        }
        ResourceLocation item = null;
        if (json.has("item")) {
            item = VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"item"));
        } else if (json.has("icon")) {
            item = VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"icon"));
        }
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
        if (json.has("models")) {
            JsonArray modelList = GsonHelper.getAsJsonArray((JsonObject)json, (String)"models");
            for (int i = 0; i < modelList.size(); ++i) {
                models.add(VersionUtil.parseResource(GsonHelper.convertToString((JsonElement)modelList.get(i), (String)("models[" + i + "]"))));
            }
        }
        HashMap<String, ResourceLocation> textureOverrides = new HashMap<String, ResourceLocation>();
        if (json.has("textures")) {
            JsonObject textures = GsonHelper.getAsJsonObject((JsonObject)json, (String)"textures");
            for (Map.Entry entry : textures.entrySet()) {
                ResourceLocation t = VersionUtil.parseResource(GsonHelper.convertToString((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey())));
                textureOverrides.put((String)entry.getKey(), t);
            }
        }
        HashMap properties = new HashMap();
        VariantProperty.forEach((id, property) -> {
            if (json.has(id.toString())) {
                properties.put((VariantProperty<?>)property, property.parse(json.get(id.toString())));
            } else if (id.getNamespace().equals("lightmanscurrency") && json.has(id.getPath())) {
                properties.put((VariantProperty<?>)property, property.parse(json.get(id.getPath())));
            }
        });
        if (targets.isEmpty() && name == null && item == null && models.isEmpty() && textureOverrides.isEmpty() && properties.isEmpty()) {
            if (parent == null) {
                throw new JsonSyntaxException("Model Variant must have something defined!");
            }
            throw new JsonSyntaxException("Model Variant must have something other than the parent defined!");
        }
        boolean dummy = GsonHelper.getAsBoolean((JsonObject)json, (String)"dummy", (boolean)false);
        return new ModelVariant(parent, targets, name, item, models, textureOverrides, properties, dummy);
    }

    public void validate(@Nullable Map<ResourceLocation, ModelVariant> otherVariants, ResourceLocation id) {
        if (this.parent != null) {
            if (otherVariants == null) {
                return;
            }
            LoopData loop = new LoopData(id, this);
            if (otherVariants.containsKey(this.parent)) {
                this.parentVariant = otherVariants.get(this.parent);
                if (this.parentVariant.checkForLoop(otherVariants, this.parent, loop)) {
                    LightmansCurrency.LogWarning("Detected infinite loop in " + String.valueOf(id));
                    this.completelyInvalid = true;
                    return;
                }
                this.invalid = ModelVariant.invalidWhenCombined(loop, id);
            } else {
                this.completelyInvalid = true;
            }
        } else if (otherVariants != null) {
            this.invalid = ModelVariant.invalidWhenCombined(new LoopData(id, this), id);
        }
    }

    private static boolean invalidWhenCombined(LoopData loop) {
        return ModelVariant.invalidWhenCombined(loop, null);
    }

    private static boolean invalidWhenCombined(LoopData loop, @Nullable ResourceLocation id) {
        boolean bl;
        boolean bl2;
        boolean hasTarget = false;
        List<Object> targets = new ArrayList();
        for (ModelVariant modelVariant : loop.variants) {
            if (modelVariant.targets.isEmpty()) continue;
            hasTarget = true;
            targets = modelVariant.targets;
            break;
        }
        if (!hasTarget) {
            if (id != null) {
                LightmansCurrency.LogDebug(String.valueOf(id) + " has no valid targets!");
            }
            return true;
        }
        boolean hasTextures = false;
        for (ModelVariant modelVariant : loop.variants) {
            if (modelVariant.textureOverrides.isEmpty()) continue;
            hasTextures = true;
            break;
        }
        boolean bl3 = false;
        for (ModelVariant v : loop.variants) {
            if (v.item == null) continue;
            bl2 = true;
            break;
        }
        boolean bl4 = false;
        for (ModelVariant v : loop.variants) {
            if (v.models.isEmpty()) continue;
            bl = true;
            for (ResourceLocation resourceLocation : targets) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
                if (block instanceof IVariantBlock) {
                    IVariantBlock vb = (IVariantBlock)block;
                    if (vb.requiredModels() == v.models.size()) continue;
                    if (id != null) {
                        LightmansCurrency.LogDebug(String.valueOf(id) + " does not have the same model count as " + String.valueOf(resourceLocation));
                    }
                    return true;
                }
                if (id != null) {
                    LightmansCurrency.LogDebug(String.valueOf(id) + " targets an invalid variant block (" + String.valueOf(resourceLocation) + ")");
                }
                return true;
            }
        }
        if (bl != bl2) {
            if (id != null) {
                if (bl) {
                    LightmansCurrency.LogDebug(String.valueOf(id) + " has custom block models defined, but no custom item model");
                } else {
                    LightmansCurrency.LogDebug(String.valueOf(id) + " has a custom item model defined, but no custom block models");
                }
            }
            return true;
        }
        if (!hasTextures && !bl) {
            if (id != null) {
                LightmansCurrency.LogDebug(String.valueOf(id) + " does not have any custom models or custom textures defined");
            }
            return true;
        }
        return false;
    }

    private boolean checkForLoop(Map<ResourceLocation, ModelVariant> existingVariants, ResourceLocation myID, LoopData loop) {
        if (this.completelyInvalid) {
            return true;
        }
        if (loop.checkAndAdd(myID, this)) {
            return true;
        }
        if (this.parent != null && !existingVariants.containsKey(this.parent)) {
            this.completelyInvalid = true;
            return true;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static List<ResourceLocation> testSelectors(List<TargetSelector> targetSelectors) {
        ArrayList<ResourceLocation> results = new ArrayList<ResourceLocation>();
        for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
            if (!(entry.getValue() instanceof IVariantBlock) || !ModelVariant.matchesSelectors(((ResourceKey)entry.getKey()).location(), targetSelectors)) continue;
            results.add(((ResourceKey)entry.getKey()).location());
        }
        return results;
    }

    private static boolean matchesSelectors(ResourceLocation id, List<TargetSelector> targetSelectors) {
        String idString = id.toString();
        return targetSelectors.stream().anyMatch(s -> s.matches(idString));
    }

    private record TargetSelector(String testString, TestType test) {
        boolean matches(String idString) {
            return switch (this.test.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> idString.startsWith(this.testString);
                case 1 -> idString.contains(this.testString);
                case 2 -> idString.endsWith(this.testString);
            };
        }

        public static TargetSelector parse(String selector) throws JsonSyntaxException {
            boolean start;
            boolean end = selector.startsWith("*");
            if (end) {
                selector = selector.substring(1);
            }
            if (start = selector.endsWith("*")) {
                selector = selector.substring(0, selector.length() - 1);
            }
            if (start && !end) {
                return new TargetSelector(selector, TestType.START);
            }
            if (end && !start) {
                return new TargetSelector(selector, TestType.END);
            }
            return new TargetSelector(selector, TestType.CONTAINS);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.test.end) {
                builder.append("*");
            }
            builder.append(this.testString);
            if (this.test.start) {
                builder.append("*");
            }
            return builder.toString();
        }

        static enum TestType {
            START(true, false),
            CONTAINS(true, true),
            END(false, true);

            final boolean start;
            final boolean end;

            private TestType(boolean start, boolean end) {
                this.start = start;
                this.end = end;
            }
        }
    }

    private record LoopData(List<ResourceLocation> ids, List<ModelVariant> variants) {
        LoopData(ResourceLocation firstID, ModelVariant firstVariant) {
            this(Lists.newArrayList((Object[])new ResourceLocation[]{firstID}), Lists.newArrayList((Object[])new ModelVariant[]{firstVariant}));
        }

        <T extends Throwable> boolean checkAndAdd(ResourceLocation id, ModelVariant variant) {
            if (this.ids.contains(id)) {
                return true;
            }
            this.ids.add(id);
            this.variants.add(variant);
            return false;
        }
    }

    public static class Builder {
        @Nullable
        private ResourceLocation parent;
        private final List<ResourceLocation> targets = new ArrayList<ResourceLocation>();
        private final List<String> selectorTargets = new ArrayList<String>();
        @Nullable
        private Component name;
        private ResourceLocation item = null;
        private final List<ResourceLocation> models = new ArrayList<ResourceLocation>();
        private final Map<String, ResourceLocation> textureOverrides = new HashMap<String, ResourceLocation>();
        private final Map<VariantProperty<?>, Object> properties = new HashMap();
        private boolean dummy = false;

        private Builder() {
            VariantProperty.confirmRegistration();
        }

        public Builder withParent(ResourceLocation parent) {
            this.parent = parent;
            return this;
        }

        public Builder withTarget(Supplier<? extends Block> block) {
            return this.withTarget(block.get());
        }

        public Builder withTarget(Block block) {
            return this.withTarget(BuiltInRegistries.BLOCK.getKey((Object)block));
        }

        public Builder withTarget(ResourceLocation target) {
            if (!this.targets.contains(target)) {
                this.targets.add(target);
            }
            return this;
        }

        public Builder withSelectorTarget(String selectorTarget) {
            if (!this.selectorTargets.contains(selectorTarget)) {
                this.selectorTargets.add(selectorTarget);
            }
            return this;
        }

        public Builder withName(Component name) {
            this.name = name;
            return this;
        }

        public Builder withItem(ResourceLocation item) {
            this.item = item;
            return this;
        }

        public Builder withModel(ResourceLocation ... model) {
            this.models.addAll(Lists.newArrayList((Object[])model));
            return this;
        }

        public Builder withTexture(String textureKey, ResourceLocation texture) {
            this.textureOverrides.put(textureKey, texture);
            return this;
        }

        public <T> Builder withProperty(VariantProperty<T> property, T value) {
            this.properties.put(property, value);
            return this;
        }

        public Builder asDummy() {
            this.dummy = true;
            return this;
        }

        public ModelVariant build() {
            return new ModelVariant(this.parent, this.targets, this.selectorTargets, this.name, this.item, this.models, this.textureOverrides, this.properties, this.dummy);
        }
    }
}

