/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.events.client.RegisterVariantPropertiesEvent;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class VariantProperty<T> {
    private static Map<ResourceLocation, VariantProperty<?>> registry = null;
    private ResourceLocation id;

    @Deprecated(since="2.2.5.3")
    public static void register(ResourceLocation type, VariantProperty<?> property) {
        property.id = type;
    }

    public ResourceLocation getID() {
        return Objects.requireNonNull(this.id, "VariantProperty has not been properly registered!");
    }

    public void setID(ResourceLocation id) {
        if (this.id != null) {
            throw new IllegalStateException("Cannot define the ID of a Variant Property that's already been registered!");
        }
        this.id = id;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariantProperty) {
            VariantProperty other = (VariantProperty)obj;
            return other.getClass() == this.getClass() && other.getID().equals((Object)this.getID());
        }
        return false;
    }

    public static void forEach(BiConsumer<ResourceLocation, VariantProperty<?>> consumer) {
        VariantProperty.confirmRegistration();
        registry.forEach(consumer);
    }

    public static void confirmRegistration() {
        if (registry != null) {
            return;
        }
        RegisterVariantPropertiesEvent event = new RegisterVariantPropertiesEvent();
        ModLoader.postEvent((Event)event);
        registry = event.getRegistry();
    }

    public abstract T parse(JsonElement var1) throws JsonSyntaxException, ResourceLocationException;

    public abstract JsonElement write(Object var1);
}

