/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperty;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TooltipInfo {
    public static final VariantProperty<TooltipInfo> PROPERTY = new TooltipInfoProperty();
    private final List<Component> tooltip;
    public final boolean drawOnSelection;
    public final boolean drawOnItem;
    public final boolean drawOnJade;

    public List<Component> getTooltip() {
        return new ArrayList<Component>(this.tooltip);
    }

    public TooltipInfo(List<Component> tooltip) {
        this(tooltip, true, true, true);
    }

    public TooltipInfo(List<Component> tooltip, boolean drawOnSelection, boolean drawOnItem, boolean drawOnJade) {
        this.tooltip = ImmutableList.copyOf(tooltip);
        this.drawOnSelection = drawOnSelection;
        this.drawOnItem = drawOnItem;
        this.drawOnJade = drawOnJade;
    }

    private static class TooltipInfoProperty
    extends VariantProperty<TooltipInfo> {
        private TooltipInfoProperty() {
        }

        @Override
        public TooltipInfo parse(JsonElement element) throws JsonSyntaxException, ResourceLocationException {
            ArrayList<Component> tooltip;
            String elementName = this.getID().toString();
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)elementName);
            JsonElement tooltipElement = json.get("tooltip");
            if (tooltipElement == null) {
                GsonHelper.getAsJsonArray((JsonObject)json, (String)"tooltip");
            }
            if (tooltipElement.isJsonObject() || tooltipElement.isJsonPrimitive()) {
                Component line = (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)tooltipElement).getOrThrow(JsonSyntaxException::new)).getFirst();
                tooltip = new ArrayList();
                tooltip.add(line);
            } else {
                tooltip = new ArrayList<Component>();
                JsonArray tooltipArray = GsonHelper.convertToJsonArray((JsonElement)tooltipElement, (String)"tooltip");
                for (int i = 0; i < tooltipArray.size(); ++i) {
                    Component line = (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)tooltipArray.get(i)).getOrThrow(JsonSyntaxException::new)).getFirst();
                    tooltip.add(line);
                }
            }
            boolean drawOnSelection = GsonHelper.getAsBoolean((JsonObject)json, (String)"selection", (boolean)true);
            boolean drawOnItem = GsonHelper.getAsBoolean((JsonObject)json, (String)"item", (boolean)true);
            boolean drawOnJade = GsonHelper.getAsBoolean((JsonObject)json, (String)"jade", (boolean)true);
            return new TooltipInfo(tooltip, drawOnSelection, drawOnItem, drawOnJade);
        }

        @Override
        public JsonElement write(Object value) {
            if (value instanceof TooltipInfo) {
                TooltipInfo data = (TooltipInfo)value;
                JsonObject json = new JsonObject();
                if (data.tooltip.size() == 1) {
                    json.add("tooltip", (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data.tooltip.getFirst()).getOrThrow(RuntimeException::new));
                } else {
                    JsonArray tooltipArray = new JsonArray();
                    for (Component line : data.tooltip) {
                        tooltipArray.add((JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)line).getOrThrow(RuntimeException::new));
                    }
                    json.add("tooltip", (JsonElement)tooltipArray);
                }
                json.addProperty("selection", Boolean.valueOf(data.drawOnSelection));
                json.addProperty("item", Boolean.valueOf(data.drawOnSelection));
                json.addProperty("jade", Boolean.valueOf(data.drawOnSelection));
                return json;
            }
            throw new IllegalArgumentException("Value must be a TooltipInfo element!");
        }
    }
}

