/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.attachments.wallet;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModAttachmentTypes;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.containers.SuppliedItemContainer;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketCreativeWalletEdit;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WalletHelpers {
    @Nonnull
    public static Container getWalletContainer(@Nonnull LivingEntity entity) {
        return new SuppliedItemContainer(() -> {
            WalletHandler handler = WalletHandler.get(entity);
            if (handler != null) {
                return new WalletInteractable(handler);
            }
            return null;
        });
    }

    @Nonnull
    public static MoneyView getWalletMoney(@Nonnull LivingEntity entity) {
        WalletHandler walletHandler = (WalletHandler)entity.getData(ModAttachmentTypes.WALLET_HANDLER);
        ItemStack wallet = walletHandler.getWallet();
        return WalletItem.getDataWrapper(wallet).getStoredMoney();
    }

    private static class WalletInteractable
    implements SuppliedItemContainer.IItemInteractable {
        private final WalletHandler walletHandler;

        WalletInteractable(@Nonnull WalletHandler handler) {
            this.walletHandler = handler;
        }

        @Override
        @Nonnull
        public ItemStack getItem() {
            return this.walletHandler.getWallet();
        }

        @Override
        public void setItem(@Nonnull ItemStack item) {
            Player player;
            LivingEntity livingEntity;
            this.walletHandler.setWallet(item);
            if (this.walletHandler.entity().level().isClientSide && (livingEntity = this.walletHandler.entity()) instanceof Player && (player = (Player)livingEntity).isCreative()) {
                new CPacketCreativeWalletEdit(this.getItem().copy()).send();
            }
        }
    }
}

