/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.CoinJarItem;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class CoinJarBlockEntity
extends EasyBlockEntity {
    public static final int COIN_LIMIT = 64;
    private int color = -1;
    List<ItemStack> storage = new ArrayList<ItemStack>();
    private final ItemViewer viewer = new ItemViewer(this);

    public int getColor() {
        return this.color >= 0 ? this.color : 0xFFFFFF;
    }

    public List<ItemStack> getStorage() {
        return this.storage;
    }

    public void clearStorage() {
        this.storage.clear();
    }

    public IItemHandler getViewer() {
        return this.viewer;
    }

    public CoinJarBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.COIN_JAR.get(), pos, state);
    }

    public boolean addCoin(ItemStack coin) {
        if (this.getCurrentCount() >= 64) {
            return false;
        }
        if (!CoinAPI.API.IsAllowedInCoinContainer(coin, false)) {
            return false;
        }
        boolean foundStack = false;
        for (int i = 0; i < this.storage.size() && !foundStack; ++i) {
            if (!InventoryUtil.ItemMatches(coin, this.storage.get(i)) || this.storage.get(i).getCount() >= this.storage.get(i).getMaxStackSize()) continue;
            this.storage.get(i).grow(1);
            foundStack = true;
        }
        if (!foundStack) {
            ItemStack newCoin = coin.copy();
            newCoin.setCount(1);
            this.storage.add(newCoin);
        }
        if (!this.level.isClientSide) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeStorage(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
        }
        return true;
    }

    protected int getCurrentCount() {
        int count = 0;
        for (ItemStack stack : this.storage) {
            count += stack.getCount();
        }
        return count;
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.writeStorage(compound, lookup);
        if (this.color >= 0) {
            compound.putInt("Color", this.color);
        }
        super.saveAdditional(compound, lookup);
    }

    protected CompoundTag writeStorage(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        ListTag storageList = new ListTag();
        for (ItemStack stack : this.storage) {
            storageList.add((Object)InventoryUtil.saveItemNoLimits(stack, lookup));
        }
        compound.put("Coins", (Tag)storageList);
        return compound;
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        if (compound.contains("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListTag storageList = compound.getList("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                ItemStack result = InventoryUtil.loadItemNoLimits(storageList.getCompound(i), lookup);
                if (result.isEmpty()) continue;
                this.storage.add(result);
            }
        }
        if (compound.contains("Color")) {
            this.color = compound.getInt("Color");
        }
        super.loadAdditional(compound, lookup);
    }

    public void addFullData(ItemStack item) {
        if (!this.storage.isEmpty()) {
            CoinJarItem.setJarContents(item, this.storage);
        }
        this.addSimpleData(item);
    }

    public void addSimpleData(ItemStack item) {
        if (this.color >= 0) {
            CoinJarItem.setJarColor(item, this.color);
        }
    }

    public void readItemData(ItemStack item) {
        CoinJarItem jar;
        this.storage = InventoryUtil.copyList(CoinJarItem.getJarContents(item));
        Item item2 = item.getItem();
        if (item2 instanceof CoinJarItem && (jar = (CoinJarItem)item2).canDye(item)) {
            this.color = CoinJarItem.getJarColor(item);
        }
    }

    private record ItemViewer(CoinJarBlockEntity be) implements IItemHandler
    {
        public int getSlots() {
            return this.be.storage.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.be.storage.size()) {
                return this.be.storage.get(slot).copy();
            }
            return ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack.copy();
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }
}

