/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettings;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsHolder;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PaygateBlockEntity
extends TraderBlockEntity<PaygateTraderData>
implements IDirectionalSettingsHolder {
    private int timer = 0;
    private int powerLevel = 0;
    private final DirectionalSettings outputSides = new DirectionalSettings(this);

    public int getTimer() {
        return this.timer;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public boolean allowOutputSide(Direction side) {
        return this.outputSides.getState(side).allowsOutputs();
    }

    public PaygateBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntities.PAYGATE.get(), pos, state);
    }

    protected PaygateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    protected PaygateTraderData castOrNullify(@Nonnull TraderData trader) {
        if (trader instanceof PaygateTraderData) {
            PaygateTraderData pg = (PaygateTraderData)trader;
            return pg;
        }
        return null;
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        this.saveTimer(compound);
        this.saveRedstoneData(compound);
    }

    public final CompoundTag saveTimer(CompoundTag compound) {
        compound.putInt("Timer", Math.max(this.timer, 0));
        return compound;
    }

    public final void saveRedstoneData(CompoundTag compound) {
        compound.putInt("Power", this.powerLevel);
        this.outputSides.save(compound, "OutputSides");
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        if (compound.contains("Timer", 3)) {
            this.timer = Math.max(compound.getInt("Timer"), 0);
        }
        this.outputSides.load(compound, "OutputSides");
        this.powerLevel = MathUtil.clamp(compound.getInt("Power"), 0, 15);
        super.loadAdditional(compound, lookup);
    }

    public boolean isActive() {
        return this.timer > 0;
    }

    public void activate(int duration, int level, DirectionalSettings outputSides) {
        this.timer = duration;
        this.powerLevel = MathUtil.clamp(level, 0, 15);
        this.outputSides.copy(outputSides);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.markTimerDirty();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.timer > 0) {
            --this.timer;
            this.markTimerDirty();
            if (this.timer <= 0) {
                this.outputSides.clear();
                this.powerLevel = 0;
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void markTimerDirty() {
        this.setChanged();
        if (!this.level.isClientSide) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveTimer(new CompoundTag()));
        }
    }

    public int getValidTicketTrade(Player player, ItemStack heldItem) {
        long ticketID;
        PaygateTraderData trader = (PaygateTraderData)this.getTraderData();
        if (TicketItem.isTicketOrPass(heldItem) && (ticketID = TicketItem.GetTicketID(heldItem)) >= -1L) {
            TradeContext context = TradeContext.create((TraderData)trader, player).build();
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                PaygateTradeData trade = trader.getTrade(i);
                if (!trade.isTicketTrade() || trade.getTicketID() != ticketID || trader.runPreTradeEvent(trade, context).isCanceled()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    @Nonnull
    protected PaygateTraderData buildNewTrader() {
        return new PaygateTraderData(this.level, this.worldPosition);
    }
}

