/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.attachments.EventUnlocks;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.ColorArgument;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.MoneyValueArgument;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.TraderArgument;
import io.github.lightman314.lightmanscurrency.common.core.ModAttachmentTypes;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.data.types.EventRewardDataCache;
import io.github.lightman314.lightmanscurrency.common.data.types.TaxDataCache;
import io.github.lightman314.lightmanscurrency.common.items.GachaBallItem;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.items.data.TraderItemData;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerListing;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketDebugTrader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class CommandLCAdmin {
    private static final SimpleCommandExceptionType ERROR_BLOCK_NOT_FOUND = new SimpleCommandExceptionType((Message)LCText.COMMAND_ADMIN_PREPARE_FOR_STRUCTURE_ERROR.get(new Object[0]));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lcadmin").requires(stack -> stack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"toggleadmin").requires(CommandSourceStack::isPlayer)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"traderdata").then(Commands.literal((String)"list").executes(CommandLCAdmin::listTraderData))).then(Commands.literal((String)"search").then(Commands.argument((String)"searchText", (ArgumentType)StringArgumentType.greedyString()).executes(CommandLCAdmin::searchTraderData)))).then(Commands.literal((String)"delete").then(Commands.argument((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::deleteTraderData)))).then(Commands.literal((String)"debug").then(Commands.argument((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::debugTraderData)))).then(((LiteralArgumentBuilder)Commands.literal((String)"recover").requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"traderID", (ArgumentType)TraderArgument.recoverableTrader()).executes(CommandLCAdmin::recoverTraderItem)))).then(Commands.literal((String)"addToWhitelist").then(Commands.argument((String)"traderID", (ArgumentType)TraderArgument.traderWithPersistent()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(CommandLCAdmin::addToTraderWhitelist)))))).then(Commands.literal((String)"prepareForStructure").then(Commands.argument((String)"traderPos", (ArgumentType)BlockPosArgument.blockPos()).executes(CommandLCAdmin::setCustomTrader)))).then(Commands.literal((String)"viewWallet").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(CommandLCAdmin::viewWalletSlot)))).then(Commands.literal((String)"replaceWallet").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument((String)"wallet", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(CommandLCAdmin::replaceWalletSlotWithDefault)).then(Commands.argument((String)"keepWalletContents", (ArgumentType)BoolArgumentType.bool()).executes(CommandLCAdmin::replaceWalletSlot)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"taxes").then(Commands.literal((String)"list").executes(CommandLCAdmin::listTaxCollectors))).then(Commands.literal((String)"delete").then(Commands.argument((String)"taxCollectorID", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(CommandLCAdmin::deleteTaxCollector)))).then(((LiteralArgumentBuilder)Commands.literal((String)"openServerTax").requires(CommandSourceStack::isPlayer)).executes(CommandLCAdmin::openServerTax))).then(Commands.literal((String)"forceDisableTaxCollectors").executes(CommandLCAdmin::forceDisableTaxCollectors)))).then(((LiteralArgumentBuilder)Commands.literal((String)"events").then(Commands.literal((String)"clearRewardCache").then(Commands.argument((String)"eventID", (ArgumentType)StringArgumentType.greedyString()).executes(CommandLCAdmin::clearRewardCache)))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"list").executes(CommandLCAdmin::listUnlockedEvents))).then(Commands.literal((String)"unlock").then(Commands.argument((String)"event", (ArgumentType)StringArgumentType.word()).executes(CommandLCAdmin::unlockEvent)))).then(Commands.literal((String)"lock").then(Commands.argument((String)"event", (ArgumentType)StringArgumentType.word()).executes(CommandLCAdmin::lockEvent)))))).then(Commands.literal((String)"makePrepaidCard").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandLCAdmin.createPrepaidCard((CommandContext<CommandSourceStack>)c, 0xFFFFFF))).then(Commands.argument((String)"color", (ArgumentType)ColorArgument.argument()).executes(c -> CommandLCAdmin.createPrepaidCard((CommandContext<CommandSourceStack>)c, ColorArgument.getColor((CommandContext<CommandSourceStack>)c, "color")))))))).then(Commands.literal((String)"debug").then(Commands.literal((String)"makeGachaBall").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"contents", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(c -> CommandLCAdmin.createGachaBall((CommandContext<CommandSourceStack>)c, -1))).then(Commands.argument((String)"color", (ArgumentType)ColorArgument.argument()).executes(c -> CommandLCAdmin.createGachaBall((CommandContext<CommandSourceStack>)c, ColorArgument.getColor((CommandContext<CommandSourceStack>)c, "color"))))))));
        dispatcher.register(lcAdminCommand);
    }

    static int toggleAdmin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer sourcePlayer = source.getPlayerOrException();
        LCAdminMode.ToggleAdminPlayer(sourcePlayer);
        MutableComponent enabledDisabled = LCAdminMode.isAdminPlayer((Player)sourcePlayer) ? LCText.COMMAND_ADMIN_TOGGLE_ADMIN_ENABLED.getWithStyle(ChatFormatting.GREEN) : LCText.COMMAND_ADMIN_TOGGLE_ADMIN_DISABLED.getWithStyle(ChatFormatting.RED);
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TOGGLE_ADMIN.get(enabledDisabled), true);
        return 1;
    }

    static int setCustomTrader(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(commandContext, (String)"traderPos");
        ServerLevel level = source.getLevel();
        BlockState state = level.getBlockState(pos);
        BlockEntity be = state.getBlock() instanceof ITraderBlock ? ((ITraderBlock)state.getBlock()).getBlockEntity(state, (LevelAccessor)level, pos) : level.getBlockEntity(pos);
        if (be instanceof TraderBlockEntity) {
            TraderBlockEntity t = (TraderBlockEntity)be;
            t.saveCurrentTraderAsCustomTrader();
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_PREPARE_FOR_STRUCTURE_SUCCESS.get(new Object[0]), true);
            return 1;
        }
        throw ERROR_BLOCK_NOT_FOUND.create();
    }

    static int listTraderData(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<TraderData> allTraders = TraderAPI.API.GetAllTraders(false);
        allTraders.sort(Comparator.comparingLong(TraderData::getID));
        if (!allTraders.isEmpty()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TITLE.get(new Object[0]), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                TraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_NONE.get(new Object[0]), true);
        }
        return 1;
    }

    static int searchTraderData(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String search = StringArgumentType.getString(commandContext, (String)"searchText");
        ArrayList<TraderData> results = new ArrayList<TraderData>(TraderAPI.API.GetAllTraders(false).stream().filter(trader -> TraderAPI.API.FilterTrader((TraderData)trader, search)).toList());
        if (!results.isEmpty()) {
            results.sort(Comparator.comparingLong(TraderData::getID));
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TITLE.get(new Object[0]), true);
            for (int i = 0; i < results.size(); ++i) {
                TraderData thisTrader = (TraderData)results.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_SEARCH_NONE.get(new Object[0]), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(TraderData thisTrader, CommandSourceStack source) {
        String traderID = String.valueOf(thisTrader.getID());
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TRADER_ID.get(EasyText.literal(traderID).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, traderID)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TRADER_ID_TOOLTIP.get(new Object[0]))))), false);
        if (thisTrader.isPersistent()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_PERSISTENT_ID.get(thisTrader.getPersistentID()), false);
        }
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_TYPE.get(thisTrader.type), false);
        if (thisTrader instanceof AuctionHouseTrader) {
            return;
        }
        EasyText.sendCommandSucess(source, (Component)thisTrader.getOwner().getValidOwner().getCommandLabel(), false);
        TraderState state = thisTrader.getState();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_STATE.get(new Object[]{state}), false);
        if (thisTrader.hasWorldPosition()) {
            String dimension = thisTrader.getLevel().location().toString();
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_DIMENSION.get(dimension), false);
            BlockPos pos = thisTrader.getPos();
            String position = pos.getX() + " " + pos.getY() + " " + pos.getZ();
            String teleportPosition = pos.getX() + " " + (pos.getY() + 1) + " " + pos.getZ();
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_POSITION.get(EasyText.literal(position).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)LCText.COMMAND_ADMIN_TRADERDATA_LIST_POSITION_TOOLTIP.get(new Object[0]))))), true);
        }
        if (thisTrader.hasCustomName()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_LIST_NAME.get(thisTrader.getName()), true);
        }
    }

    static int deleteTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TraderAPI.API.DeleteTrader(trader);
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_DELETE_SUCCESS.get(trader.getName()), true);
        return 1;
    }

    static int debugTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        EasyText.sendCommandSucess(source, (Component)EasyText.literal(trader.save((HolderLookup.Provider)source.registryAccess()).getAsString()), false);
        if (((CommandSourceStack)commandContext.getSource()).isPlayer()) {
            new SPacketDebugTrader(trader.getID()).sendTo(((CommandSourceStack)commandContext.getSource()).getPlayerOrException());
        }
        return 1;
    }

    static int recoverTraderItem(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        ServerPlayer player = sourceStack.getPlayerOrException();
        if (trader.isRecoverable()) {
            Item item = trader.getTraderBlock();
            if (item == null) {
                EasyText.sendCommandFail(sourceStack, (Component)LCText.COMMAND_ADMIN_TRADERDATA_RECOVER_FAIL_NO_ITEM.get(new Object[0]));
                return 0;
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            stack.set(ModDataComponents.TRADER_ITEM_DATA, (Object)new TraderItemData(trader.getID()));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            EasyText.sendCommandSucess(sourceStack, (Component)LCText.COMMAND_ADMIN_TRADERDATA_RECOVER_SUCCESS.get(new Object[0]), true);
            return 1;
        }
        throw TraderArgument.ERROR_NOT_RECOVERABLE.create();
    }

    static int addToTraderWhitelist(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TradeRule rule = TradeRule.getRule(PlayerListing.TYPE.type, trader.getRules());
        if (rule instanceof PlayerListing) {
            PlayerListing whitelist = (PlayerListing)rule;
            Collection players = EntityArgument.getPlayers(commandContext, (String)"player");
            int count = 0;
            for (ServerPlayer player : players) {
                if (!whitelist.addToWhitelist(player)) continue;
                ++count;
            }
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_ADD_TO_WHITELIST_SUCCESS.get(count, trader.getName()), true);
            if (count > 0) {
                trader.markTradeRulesDirty();
            }
            return count;
        }
        EasyText.sendCommandFail(source, (Component)LCText.COMMAND_ADMIN_TRADERDATA_ADD_TO_WHITELIST_MISSING.get(new Object[0]));
        return 0;
    }

    static int viewWalletSlot(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        LivingEntity entity;
        Entity e = EntityArgument.getEntity(commandContext, (String)"entity");
        if (e instanceof LivingEntity && ((entity = (LivingEntity)e).hasData(ModAttachmentTypes.WALLET_HANDLER) || e instanceof Player)) {
            WalletHandler walletHandler = WalletHandler.get(entity);
            ItemStack wallet = walletHandler.getWallet();
            if (wallet.isEmpty()) {
                EasyText.sendCommandSucess(commandContext, (Component)LCText.COMMAND_ADMIN_VIEW_WALLET_EMPTY.get(entity.getDisplayName()), false);
            } else {
                EasyText.sendCommandSucess(commandContext, (Component)LCText.COMMAND_ADMIN_VIEW_WALLET_SUCCESS.get(entity.getDisplayName(), wallet.getDisplayName()), false);
            }
            return 1;
        }
        EasyText.sendCommandFail(commandContext, (Component)LCText.COMMAND_ADMIN_VIEW_WALLET_INVALID_TARGET.get(e.getDisplayName()));
        return 0;
    }

    static int replaceWalletSlotWithDefault(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, true);
    }

    static int replaceWalletSlot(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, BoolArgumentType.getBool(commandContext, (String)"keepWalletContents"));
    }

    static int replaceWalletSlotInternal(CommandContext<CommandSourceStack> commandContext, boolean keepWalletContents) throws CommandSyntaxException {
        int count = 0;
        ItemInput input = ItemArgument.getItem(commandContext, (String)"wallet");
        if (!(input.getItem() instanceof WalletItem) && input.getItem() != Items.AIR) {
            throw new CommandSyntaxException(new CommandExceptionType(){}, (Message)LCText.COMMAND_ADMIN_REPLACE_WALLET_NOT_A_WALLET.get(new Object[0]));
        }
        for (Entity e : EntityArgument.getEntities(commandContext, (String)"entity")) {
            ItemStack oldWallet;
            LivingEntity entity;
            if (!(e instanceof LivingEntity) || !(entity = (LivingEntity)e).hasData(ModAttachmentTypes.WALLET_HANDLER) && !(e instanceof Player)) continue;
            WalletHandler walletHandler = WalletHandler.get(entity);
            ItemStack newWallet = input.createItemStack(1, true);
            if (newWallet.isEmpty() && walletHandler.getWallet().isEmpty()) continue;
            if (keepWalletContents && WalletItem.isWallet(oldWallet = walletHandler.getWallet())) {
                newWallet = oldWallet.transmuteCopy((ItemLike)newWallet.getItem(), 1);
            }
            walletHandler.setWallet(newWallet);
        }
        return count;
    }

    static int openServerTax(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        TaxEntry entry = TaxDataCache.TYPE.get(false).getServerEntry();
        entry.openMenu((Player)((CommandSourceStack)commandContext.getSource()).getPlayerOrException(), SimpleValidator.NULL);
        return 1;
    }

    static int listTaxCollectors(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_TITLE.get(new Object[0]), false);
        for (TaxEntry entry : TaxDataCache.TYPE.get(false).getAllEntries()) {
            CommandLCAdmin.sendTaxDataFeedback(entry, source);
        }
        return 1;
    }

    private static void sendTaxDataFeedback(TaxEntry taxEntry, CommandSourceStack source) {
        if (taxEntry.isServerEntry()) {
            return;
        }
        String id = String.valueOf(taxEntry.getID());
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_ID.get(EasyText.literal(id).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, id)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)LCText.COMMAND_ADMIN_TAXES_LIST_ID_TOOLTIP.get(new Object[0]))))), false);
        if (!taxEntry.isServerEntry()) {
            EasyText.sendCommandSucess(source, (Component)taxEntry.getOwner().getValidOwner().getCommandLabel(), false);
        }
        String dimension = taxEntry.getArea().getCenter().getDimension().location().toString();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_DIMENSION.get(dimension), false);
        BlockPos pos = taxEntry.getArea().getCenter().getPos();
        String position = pos.getX() + " " + pos.getY() + " " + pos.getZ();
        String teleportPosition = pos.getX() + " " + (pos.getY() + 1) + " " + pos.getZ();
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_POSITION.get(EasyText.literal(position).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)LCText.COMMAND_ADMIN_TAXES_LIST_POSITION_TOOLTIP.get(new Object[0]))))), true);
        if (taxEntry.isInfiniteRange()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_INFINITE_RANGE.get(new Object[0]), false);
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_RADIUS.get(taxEntry.getRadius()), false);
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_HEIGHT.get(taxEntry.getHeight()), false);
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_OFFSET.get(taxEntry.getVertOffset()), false);
        }
        if (taxEntry.forcesAcceptance()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_FORCE_ACCEPTANCE.get(new Object[0]), false);
        }
        if (taxEntry.hasCustomName()) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_ADMIN_TAXES_LIST_NAME.get(taxEntry.getName()), true);
        }
    }

    static int deleteTaxCollector(CommandContext<CommandSourceStack> commandContext) {
        long taxCollectorID = LongArgumentType.getLong(commandContext, (String)"taxCollectorID");
        TaxDataCache data = TaxDataCache.TYPE.get(false);
        TaxEntry entry = data.getEntry(taxCollectorID);
        if (entry == null || entry.isServerEntry()) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_DELETE_FAIL.get(new Object[0]));
            return 0;
        }
        data.removeEntry(taxCollectorID);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_DELETE_SUCCESS.get(entry.getName()), true);
        return 1;
    }

    static int forceDisableTaxCollectors(CommandContext<CommandSourceStack> commandContext) {
        int count = 0;
        for (TaxEntry entry : TaxDataCache.TYPE.get(false).getAllEntries()) {
            if (!entry.isActive()) continue;
            entry.setActive(false, null);
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_FORCE_DISABLE_SUCCESS.get(count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_TAXES_FORCE_DISABLE_FAIL.get(new Object[0]));
        }
        return count;
    }

    static int clearRewardCache(CommandContext<CommandSourceStack> commandContext) {
        String eventID = StringArgumentType.getString(commandContext, (String)"eventID");
        EventRewardDataCache data = EventRewardDataCache.TYPE.get(false);
        if (data != null && data.clearEventCache(eventID)) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_CLEAR_SUCCESS.get(eventID), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_CLEAR_FAIL.get(eventID));
        return 0;
    }

    static int listUnlockedEvents(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(commandContext, (String)"player");
        EventUnlocks eventUnlocks = (EventUnlocks)player.getData(ModAttachmentTypes.EVENT_UNLOCKS);
        List<String> unlocks = eventUnlocks.getUnlockedList();
        if (!unlocks.isEmpty()) {
            StringBuilder list = new StringBuilder();
            for (String v : eventUnlocks.getUnlockedList()) {
                if (!list.isEmpty()) {
                    list.append(", ");
                }
                list.append(v);
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.literal(list.toString()), false);
        } else {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_LIST_NONE.get(new Object[0]), false);
        }
        return 1;
    }

    static int unlockEvent(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String event;
        ServerPlayer player = EntityArgument.getPlayer(commandContext, (String)"player");
        if (EventUnlocks.isUnlocked((Player)player, event = StringArgumentType.getString(commandContext, (String)"event"))) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_UNLOCK_FAIL.get(event));
            return 0;
        }
        EventUnlocks.unlock((Player)player, event);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_UNLOCK_SUCCESS.get(event), true);
        return 1;
    }

    static int lockEvent(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String event;
        ServerPlayer player = EntityArgument.getPlayer(commandContext, (String)"player");
        if (!EventUnlocks.isUnlocked((Player)player, event = StringArgumentType.getString(commandContext, (String)"event"))) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_LOCK_FAIL.get(event));
            return 0;
        }
        EventUnlocks.lock((Player)player, event);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_EVENT_LOCK_SUCCESS.get(event), true);
        return 1;
    }

    static int createPrepaidCard(CommandContext<CommandSourceStack> commandContext, int color) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        int count = 0;
        ItemStack item = new ItemStack((ItemLike)ModItems.PREPAID_CARD.get());
        item.set(ModDataComponents.MONEY_VALUE, (Object)amount);
        item.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
        for (ServerPlayer player : EntityArgument.getPlayers(commandContext, (String)"player")) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item.copy());
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_PREPAID_CARD_SUCCESS.get(amount.getText(), count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_PREPAID_CARD_FAIL.get(new Object[0]));
        }
        return count;
    }

    static int createGachaBall(CommandContext<CommandSourceStack> commandContext, int color) throws CommandSyntaxException {
        ItemStack item = ItemArgument.getItem(commandContext, (String)"contents").createItemStack(1, false);
        int count = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(commandContext, (String)"player")) {
            ItemStack gachaBall = color < 0 ? GachaBallItem.createWithItem(item) : GachaBallItem.createWithItemAndColor(item, color);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)gachaBall.copy());
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_GACHA_BALL_SUCCESS.get(item.getHoverName(), count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_ADMIN_GACHA_BALL_FAIL.get(new Object[0]));
        }
        return count;
    }
}

