/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.input.ListRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class TicketRecipe
implements TicketStationRecipe {
    public static final MapCodec<TicketRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("masterTicket").forGetter(r -> r.masterIngredient), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)ResourceLocation.CODEC.fieldOf("result").forGetter(TicketRecipe::resultID)).apply((Applicative)builder, TicketRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TicketRecipe> STREAM_CODEC = StreamCodec.of(TicketRecipe::toNetwork, TicketRecipe::fromNetwork);
    private final Ingredient masterIngredient;
    private final Ingredient ingredient;
    private final Item ticketResult;

    public Ingredient getMasterIngredient() {
        return this.masterIngredient;
    }

    private ResourceLocation resultID() {
        return BuiltInRegistries.ITEM.getKey((Object)this.ticketResult);
    }

    private TicketRecipe(@Nonnull Ingredient masterIngredient, @Nonnull Ingredient ingredient, @Nonnull ResourceLocation resultID) {
        this(masterIngredient, ingredient, (Item)BuiltInRegistries.ITEM.get(resultID));
    }

    public TicketRecipe(@Nonnull Ingredient masterIngredient, @Nonnull Ingredient ingredient, @Nonnull Item result) {
        this.masterIngredient = masterIngredient;
        this.ingredient = ingredient;
        this.ticketResult = result;
    }

    @Override
    @Nonnull
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleTicketList(this.masterIngredient);
    }

    @Override
    @Nonnull
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @Nonnull
    public ItemStack exampleResult() {
        return new ItemStack((ItemLike)this.ticketResult);
    }

    @Override
    public boolean consumeModifier() {
        return false;
    }

    @Override
    public boolean validModifier(@Nonnull ItemStack stack) {
        return this.masterIngredient.test(stack);
    }

    @Override
    public boolean validIngredient(@Nonnull ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Nonnull
    public ItemStack assemble(@Nonnull ListRecipeInput container, @Nonnull HolderLookup.Provider lookup) {
        return TicketItem.CraftTicket(container.getItem(0), this.ticketResult);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registryAccess) {
        if (this.masterIngredient.getItems().length == 0) {
            return ItemStack.EMPTY;
        }
        return TicketItem.CraftTicket(TicketItem.CreateTicket(this.masterIngredient.getItems()[0].getItem(), -1L), this.ticketResult);
    }

    @Override
    @Nonnull
    public ItemStack peekAtResult(@Nonnull Container container) {
        return TicketItem.CraftTicket(container.getItem(0), this.ticketResult);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.TICKET.get();
    }

    @Nonnull
    private static TicketRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
        return new TicketRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer));
    }

    private static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull TicketRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.masterIngredient);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.resultID());
    }

    public static class Serializer
    implements RecipeSerializer<TicketRecipe> {
        @Nonnull
        public MapCodec<TicketRecipe> codec() {
            return CODEC;
        }

        @Nonnull
        public StreamCodec<RegistryFriendlyByteBuf, TicketRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

