/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.enchantments.EnchantmentUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public final class EnchantmentEvents {
    private static int ticker = 0;

    private EnchantmentEvents() {
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        if (++ticker >= (Integer)LCConfig.SERVER.enchantmentTickDelay.get()) {
            ProfilerFiller filler = event.getServer().getProfiler();
            filler.push("Lightman's Currency Enchantment Ticks");
            ticker = 0;
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                if (player.isSpectator()) continue;
                EnchantmentUtil.tickAllEnchantments((LivingEntity)player, null);
            }
            filler.pop();
        }
    }
}

