/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.enchantments.WalletEnchantment;
import io.github.lightman314.lightmanscurrency.common.items.data.SoundEntry;
import io.github.lightman314.lightmanscurrency.common.items.data.WalletData;
import io.github.lightman314.lightmanscurrency.common.items.data.WalletDataWrapper;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ListUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WalletItem
extends Item {
    private static final SoundEvent emptyOpenSound = (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value();
    public static final int LARGEST_LEVEL = 6;
    public static final int CONFIG_LIMIT = 7;
    public static final int MAX_WALLET_SLOTS = 78;
    public static final int SLOTS_PER_UPGRADE = 6;
    public static final int DEFAULT_UPGRADE_LIMIT = 24;
    public static final ResourceLocation DEFAULT_COIN_COLLECT_SOUND = VersionUtil.lcResource("coins_clinking");

    @Nonnull
    public static ResourceLocation lazyModel(@Nonnull String itemID) {
        return WalletItem.lazyModel(VersionUtil.lcResource(itemID));
    }

    @Nonnull
    public static ResourceLocation lazyModel(@Nonnull ResourceLocation itemID) {
        return itemID.withPrefix("item/wallet_hip/");
    }

    public WalletItem(int level, int storageSize, @Nonnull ResourceLocation model, @Nonnull Item.Properties properties) {
        this(level, storageSize, model, false, 0, 24, SoundEntry.WALLET_DEFAULT, properties);
    }

    public WalletItem(int level, int storageSize, @Nonnull ResourceLocation model, boolean indestructible, int bonusMagnet, int upgradeLimit, @Nonnull Item.Properties properties) {
        this(level, storageSize, model, indestructible, bonusMagnet, upgradeLimit, SoundEntry.WALLET_DEFAULT, properties);
    }

    public WalletItem(int level, int storageSize, @Nonnull ResourceLocation model, boolean indestructible, int bonusMagnet, int upgradeLimit, @Nonnull List<SoundEntry> coinCollectSound, @Nonnull Item.Properties properties) {
        super(properties.stacksTo(1).component(ModDataComponents.WALLET_LEVEL, (Object)level).component(ModDataComponents.WALLET_CAPACITY, (Object)storageSize).component(ModDataComponents.WALLET_INVULNERABLE, (Object)indestructible).component(ModDataComponents.WALLET_BONUS_MAGNET, (Object)bonusMagnet).component(ModDataComponents.WALLET_UPGRADE_LIMIT, (Object)upgradeLimit).component(ModDataComponents.WALLET_MODEL, (Object)model).component(ModDataComponents.WALLET_COIN_SOUND, coinCollectSound));
    }

    public int getEnchantmentValue(@Nonnull ItemStack stack) {
        return 10;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return true;
    }

    public int getEnchantmentLevel(@Nonnull ItemStack stack, @Nonnull Holder<Enchantment> enchantment) {
        int bonusMagnet = (Integer)stack.getOrDefault(ModDataComponents.WALLET_BONUS_MAGNET, (Object)0);
        if (bonusMagnet > 0 && enchantment.is(ModEnchantments.COIN_MAGNET)) {
            return super.getEnchantmentLevel(stack, enchantment) + bonusMagnet;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    @Nonnull
    public ItemEnchantments getAllEnchantments(@Nonnull ItemStack stack, @Nonnull HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments enchantments = super.getAllEnchantments(stack, lookup);
        int bonusMagnet = (Integer)stack.getOrDefault(ModDataComponents.WALLET_BONUS_MAGNET, (Object)0);
        if (bonusMagnet > 0) {
            ItemEnchantments.Mutable e = new ItemEnchantments.Mutable(enchantments);
            lookup.get(ModEnchantments.COIN_MAGNET).ifPresent(cm -> e.set((Holder)cm, e.getLevel((Holder)cm) + bonusMagnet));
            enchantments = e.toImmutable();
        }
        return enchantments;
    }

    public boolean canBeHurtBy(@Nonnull ItemStack stack, @Nonnull DamageSource source) {
        boolean indestructible = (Boolean)stack.getOrDefault(ModDataComponents.WALLET_INVULNERABLE, (Object)false);
        if (indestructible) {
            return false;
        }
        return super.canBeHurtBy(stack, source);
    }

    public boolean onEntityItemUpdate(@Nonnull ItemStack stack, @Nonnull ItemEntity entity) {
        boolean indestructible = (Boolean)stack.getOrDefault(ModDataComponents.WALLET_INVULNERABLE, (Object)false);
        if (indestructible) {
            if (entity.getAge() >= 0 && !entity.level().isClientSide) {
                entity.setUnlimitedLifetime();
            }
            if (entity.position().y <= (double)entity.level().getMinBuildHeight()) {
                Vec3 velocity = entity.getDeltaMovement();
                entity.setDeltaMovement(velocity.x, 0.5, velocity.z);
            }
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(@Nonnull ItemStack wallet, @Nonnull ItemStack item, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player, @Nonnull SlotAccess slotAccess) {
        if (action == ClickAction.SECONDARY && ((Boolean)LCConfig.SERVER.walletCapacityUpgradeable.get()).booleanValue() && InventoryUtil.ItemHasTag(item, LCTags.Items.WALLET_UPGRADE_MATERIAL)) {
            WalletData data = (WalletData)wallet.getOrDefault(ModDataComponents.WALLET_DATA, (Object)WalletData.createFor(wallet));
            int upgradeLimit = (Integer)wallet.getOrDefault(ModDataComponents.WALLET_UPGRADE_LIMIT, (Object)0);
            int bonusSlots = data.getBonusSlots((Integer)wallet.getOrDefault(ModDataComponents.WALLET_UPGRADE_LIMIT, (Object)0));
            if (bonusSlots >= (Integer)wallet.getOrDefault(ModDataComponents.WALLET_UPGRADE_LIMIT, (Object)0)) {
                return true;
            }
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof WalletMenuBase) {
                WalletMenuBase walletMenu = (WalletMenuBase)abstractContainerMenu;
                return true;
            }
            item.shrink(1);
            wallet.set(ModDataComponents.WALLET_DATA, (Object)data.withAddedBonusSlots(6));
            slot.set(wallet);
            return true;
        }
        return false;
    }

    public static boolean validWalletStack(ItemStack walletStack) {
        if (walletStack.isEmpty()) {
            return true;
        }
        return WalletItem.isWallet(walletStack.getItem());
    }

    public static boolean isWallet(ItemStack item) {
        return !item.isEmpty() && WalletItem.isWallet(item.getItem());
    }

    public static boolean isWallet(Item item) {
        return item instanceof WalletItem;
    }

    public static boolean CanExchange(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        int level = (Integer)wallet.components().getOrDefault(ModDataComponents.WALLET_LEVEL.get(), (Object)0);
        return level >= (Integer)LCConfig.SERVER.walletExchangeLevel.get();
    }

    public static boolean CanPickup(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        int level = (Integer)wallet.components().getOrDefault(ModDataComponents.WALLET_LEVEL.get(), (Object)0);
        return level >= (Integer)LCConfig.SERVER.walletPickupLevel.get();
    }

    public static boolean HasBankAccess(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        int level = (Integer)wallet.components().getOrDefault(ModDataComponents.WALLET_LEVEL.get(), (Object)0);
        return level >= (Integer)LCConfig.SERVER.walletBankLevel.get();
    }

    public static int BonusSlots(@Nonnull ItemStack walletStack) {
        Item item = walletStack.getItem();
        if (item instanceof WalletItem) {
            WalletItem wallet = (WalletItem)item;
            return ((WalletData)walletStack.getOrDefault(ModDataComponents.WALLET_DATA, (Object)WalletData.EMPTY)).getBonusSlots((Integer)walletStack.getOrDefault(ModDataComponents.WALLET_UPGRADE_LIMIT, (Object)0));
        }
        return 0;
    }

    public static int InventorySize(@Nonnull ItemStack walletStack) {
        Item item = walletStack.getItem();
        if (item instanceof WalletItem) {
            WalletItem wallet = (WalletItem)item;
            WalletData data = (WalletData)walletStack.getOrDefault(ModDataComponents.WALLET_DATA, (Object)WalletData.EMPTY);
            int storageSize = (Integer)walletStack.getOrDefault(ModDataComponents.WALLET_CAPACITY, (Object)6);
            return MathUtil.clamp(storageSize + data.bonusSlots(), 1, 78);
        }
        return 0;
    }

    @Nonnull
    public static WalletDataWrapper getDataWrapper(@Nonnull ItemStack stack) {
        if (!WalletItem.isWallet(stack)) {
            return WalletDataWrapper.EMPTY;
        }
        return new WalletDataWrapper(stack);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        ItemStack exampleItem;
        super.appendHoverText(stack, context, tooltip, flagIn);
        WalletDataWrapper data = WalletItem.getDataWrapper(stack);
        tooltip.add((Component)LCText.TOOLTIP_WALLET_CAPACITY.get(data.getContainerSize()).withStyle(ChatFormatting.YELLOW));
        if (data.getBonusSlots() < (Integer)stack.getOrDefault(ModDataComponents.WALLET_UPGRADE_LIMIT, (Object)0) && !(exampleItem = ListUtil.randomItemFromList(InventoryUtil.GetItemStacksWithTag(LCTags.Items.WALLET_UPGRADE_MATERIAL), ItemStack.EMPTY)).isEmpty()) {
            tooltip.addAll(TooltipHelper.splitTooltips((Component)LCText.TOOLTIP_WALLET_UPGRADEABLE_CAPACITY.get(TooltipHelper.lazyFormat(exampleItem.getHoverName(), ChatFormatting.AQUA), TooltipHelper.lazyFormat(String.valueOf(6), ChatFormatting.GOLD)), ChatFormatting.YELLOW));
        }
        if (WalletItem.CanPickup(this)) {
            tooltip.add((Component)LCText.TOOLTIP_WALLET_PICKUP.get(new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
        if (WalletItem.CanExchange(this)) {
            if (WalletItem.CanPickup(this)) {
                MutableComponent onOffText = data.getAutoExchange() ? LCText.TOOLTIP_WALLET_EXCHANGE_AUTO_ON.get(new Object[0]).withStyle(ChatFormatting.GREEN) : LCText.TOOLTIP_WALLET_EXCHANGE_AUTO_OFF.get(new Object[0]).withStyle(ChatFormatting.RED);
                tooltip.add((Component)LCText.TOOLTIP_WALLET_EXCHANGE_AUTO.get(onOffText).withStyle(ChatFormatting.YELLOW));
            } else {
                tooltip.add((Component)LCText.TOOLTIP_WALLET_EXCHANGE_MANUAL.get(new Object[0]).withStyle(ChatFormatting.YELLOW));
            }
        }
        if (WalletItem.HasBankAccess(this)) {
            tooltip.add((Component)LCText.TOOLTIP_WALLET_BANK_ACCOUNT.get(new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
        WalletEnchantment.addWalletEnchantmentTooltips(tooltip, stack, context);
        if (CoinAPI.API.NoDataAvailable()) {
            return;
        }
        IMoneyHandler contentHandler = MoneyAPI.API.GetContainersMoneyHandler(data.getContents(), s -> {}, IClientTracker.forClient());
        MoneyView contents = contentHandler.getStoredMoney();
        if (!contents.isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_WALLET_STORED_MONEY.get(new Object[0]));
            tooltip.addAll(contents.getAllText(ChatFormatting.DARK_GREEN));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack wallet = player.getItemInHand(hand);
        if (!level.isClientSide) {
            int walletSlot = WalletItem.GetWalletSlot(player.getInventory(), wallet);
            if (walletSlot >= 0) {
                WalletHandler walletHandler;
                if (player.isCrouching() && !LCCurios.isLoaded() && (walletHandler = WalletHandler.get((LivingEntity)player)) != null && walletHandler.getWallet().isEmpty()) {
                    walletHandler.setWallet(wallet);
                    player.setItemInHand(hand, ItemStack.EMPTY);
                    walletSlot = -1;
                }
                WalletMenuBase.SafeOpenWalletMenu(player, walletSlot);
            } else {
                LightmansCurrency.LogError("Could not find the wallet in the players inventory!");
            }
        } else {
            player.level().playSound(player, player.blockPosition(), emptyOpenSound, SoundSource.PLAYERS, 0.75f, 1.25f + player.level().random.nextFloat() * 0.5f);
            if (!WalletItem.isEmpty(wallet)) {
                player.level().playSound(player, player.blockPosition(), ModSounds.COINS_CLINKING.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
            }
        }
        return InteractionResultHolder.success((Object)wallet);
    }

    public static boolean isEmpty(@Nonnull ItemStack wallet) {
        if (!WalletItem.isWallet(wallet)) {
            return true;
        }
        return WalletItem.getDataWrapper(wallet).getContents().isEmpty();
    }

    private static int GetWalletSlot(Inventory inventory, ItemStack wallet) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (inventory.getItem(i) != wallet) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack PickupCoin(ItemStack wallet, ItemStack coins) {
        if (!WalletItem.isWallet(wallet)) {
            return coins;
        }
        WalletDataWrapper data = WalletItem.getDataWrapper(wallet);
        Container contents = data.getContents();
        ItemStack returnValue = InventoryUtil.TryPutItemStack(contents, coins);
        if (WalletItem.getAutoExchange(wallet)) {
            CoinAPI.API.CoinExchangeAllUp(contents);
        }
        CoinAPI.API.SortCoinsByValue(contents);
        data.setContents(contents, null);
        return returnValue;
    }

    public static boolean getAutoExchange(ItemStack wallet) {
        if (!(wallet.getItem() instanceof WalletItem)) {
            return false;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.getItem()) || !WalletItem.CanPickup((WalletItem)wallet.getItem())) {
            return false;
        }
        WalletDataWrapper data = WalletItem.getDataWrapper(wallet);
        return data.getAutoExchange();
    }

    public static void toggleAutoExchange(ItemStack wallet) {
        WalletDataWrapper data;
        if (!WalletItem.isWallet(wallet)) {
            return;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.getItem())) {
            return;
        }
        data.setAutoExchange(!(data = WalletItem.getDataWrapper(wallet)).getAutoExchange());
    }

    public static void QuickCollect(Player player, Container container, boolean allowSideChain) {
        ItemStack wallet = CoinAPI.API.getEquippedWallet(player);
        if (WalletItem.isWallet(wallet)) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack = container.getItem(i);
                if (!CoinAPI.API.IsAllowedInCoinContainer(stack, allowSideChain)) continue;
                stack = WalletItem.PickupCoin(wallet, stack);
                container.setItem(i, stack);
            }
        }
    }

    public static void playCollectSound(@Nonnull LivingEntity entity, @Nonnull ItemStack wallet) {
        Level level = entity.level();
        BuiltInRegistries.SOUND_EVENT.getOptional(WalletItem.getCoinCollectSound(level, wallet)).ifPresent(sound -> level.playSound(null, (Entity)entity, sound, SoundSource.PLAYERS, 0.4f, 1.0f));
    }

    @Nonnull
    public static ResourceLocation getCoinCollectSound(@Nonnull Level level, @Nonnull ItemStack wallet) {
        if (!WalletItem.isWallet(wallet)) {
            return DEFAULT_COIN_COLLECT_SOUND;
        }
        List soundEntries = (List)wallet.getOrDefault(ModDataComponents.WALLET_COIN_SOUND, SoundEntry.WALLET_DEFAULT);
        return SoundEntry.getRandomEntry(level.getRandom(), soundEntries, DEFAULT_COIN_COLLECT_SOUND);
    }
}

