/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.categories;

import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BankCategory
extends NotificationCategory {
    public static final NotificationCategoryType<BankCategory> TYPE = new NotificationCategoryType<BankCategory>(VersionUtil.lcResource("bank"), BankCategory::new);
    private final MutableComponent name;

    public BankCategory(MutableComponent name) {
        this.name = name;
    }

    public BankCategory(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.name = Component.Serializer.fromJson((String)compound.getString("Name"), (HolderLookup.Provider)lookup);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.ATM);
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        return this.name;
    }

    @Nonnull
    protected NotificationCategoryType<BankCategory> getType() {
        return TYPE;
    }

    @Override
    public boolean matches(NotificationCategory other) {
        if (other instanceof BankCategory) {
            BankCategory bc = (BankCategory)other;
            return bc.name.equals((Object)this.name);
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.putString("Name", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookup));
    }
}

