/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BankTransferNotification
extends SingleLineNotification {
    public static final NotificationType<BankTransferNotification> TYPE = new NotificationType<BankTransferNotification>(VersionUtil.lcResource("bank_transfer"), BankTransferNotification::new);
    PlayerReference player;
    MoneyValue amount = MoneyValue.empty();
    MutableComponent accountName;
    MutableComponent otherAccount;
    boolean wasReceived;

    private BankTransferNotification() {
    }

    public BankTransferNotification(PlayerReference player, MoneyValue amount, MutableComponent accountName, MutableComponent otherAccount, boolean wasReceived) {
        this.player = player;
        this.amount = amount;
        this.accountName = accountName;
        this.otherAccount = otherAccount;
        this.wasReceived = wasReceived;
    }

    @Nonnull
    protected NotificationType<BankTransferNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return LCText.NOTIFICATION_BANK_TRANSFER.get(this.player.getName(true), this.amount.getText(), this.wasReceived ? LCText.GUI_FROM.get(new Object[0]) : LCText.GUI_TO.get(new Object[0]), this.otherAccount);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.put("Player", (Tag)this.player.save());
        compound.put("Amount", (Tag)this.amount.save());
        compound.putString("Account", Component.Serializer.toJson((Component)this.accountName, (HolderLookup.Provider)lookup));
        compound.putString("Other", Component.Serializer.toJson((Component)this.otherAccount, (HolderLookup.Provider)lookup));
        compound.putBoolean("Received", this.wasReceived);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.player = PlayerReference.load(compound.getCompound("Player"));
        this.amount = MoneyValue.safeLoad(compound, "Amount");
        this.accountName = Component.Serializer.fromJson((String)compound.getString("Account"), (HolderLookup.Provider)lookup);
        this.otherAccount = Component.Serializer.fromJson((String)compound.getString("Other"), (HolderLookup.Provider)lookup);
        this.wasReceived = compound.getBoolean("Received");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof BankTransferNotification) {
            BankTransferNotification n = (BankTransferNotification)other;
            return n.player.is(this.player) && n.amount.equals(this.amount) && n.accountName.equals((Object)this.accountName) && n.otherAccount.equals((Object)this.otherAccount) && n.wasReceived == this.wasReceived;
        }
        return false;
    }
}

