/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.ejection;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class OwnableBlockEjectedNotification
extends SingleLineNotification {
    public static final NotificationType<OwnableBlockEjectedNotification> TYPE = new NotificationType<OwnableBlockEjectedNotification>(VersionUtil.lcResource("block_ejected"), OwnableBlockEjectedNotification::new);
    private Component name = EasyText.empty();
    private boolean ejected = false;
    private boolean anarchy = false;

    private OwnableBlockEjectedNotification() {
    }

    public OwnableBlockEjectedNotification(@Nonnull Component name) {
        this.name = name.copy();
        this.ejected = (Boolean)LCConfig.SERVER.safelyEjectMachineContents.get();
        this.anarchy = (Boolean)LCConfig.SERVER.anarchyMode.get();
    }

    @Nonnull
    public static Supplier<Notification> create(@Nonnull Component name) {
        return () -> new OwnableBlockEjectedNotification(name);
    }

    @Override
    @Nonnull
    protected NotificationType<?> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return this.getText().get(this.name);
    }

    private TextEntry getText() {
        if (this.anarchy) {
            return LCText.NOTIFICATION_EJECTION_ANARCHY;
        }
        if (this.ejected) {
            return LCText.NOTIFICATION_EJECTION_EJECTED;
        }
        return LCText.NOTIFICATION_EJECTION_DROPPED;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.putString("Name", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookup));
        if (this.ejected) {
            compound.putBoolean("Ejected", this.ejected);
        }
        if (this.anarchy) {
            compound.putBoolean("Anarchy", this.anarchy);
        }
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.name = Component.Serializer.fromJson((String)compound.getString("Name"), (HolderLookup.Provider)lookup);
        if (compound.contains("Ejected")) {
            this.ejected = compound.getBoolean("Ejected");
        }
        if (compound.contains("Anarchy")) {
            this.anarchy = compound.getBoolean("Anarchy");
        }
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        return false;
    }
}

