/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

public class ItemTradeNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<ItemTradeNotification> TYPE = new NotificationType<ItemTradeNotification>(VersionUtil.lcResource("item_trade"), ItemTradeNotification::new);
    TraderCategory traderData;
    TradeDirection tradeType;
    List<ItemData> items;
    MoneyValue cost = MoneyValue.empty();
    String customer;

    private ItemTradeNotification() {
    }

    public ItemTradeNotification(ItemTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.tradeType = trade.getTradeDirection();
        this.items = new ArrayList<ItemData>();
        this.items.add(new ItemData(trade.getSellItem(0), trade.isPurchase() ? "" : trade.getCustomName(0)));
        this.items.add(new ItemData(trade.getSellItem(1), trade.isPurchase() ? "" : trade.getCustomName(1)));
        if (trade.isBarter()) {
            this.items.add(new ItemData(trade.getBarterItem(0), ""));
            this.items.add(new ItemData(trade.getBarterItem(1), ""));
        } else {
            this.cost = cost;
        }
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> create(ItemTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory trader, MoneyValue taxesPaid) {
        return () -> new ItemTradeNotification(trade, cost, customer, trader, taxesPaid);
    }

    @Nonnull
    protected NotificationType<ItemTradeNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    @Nonnull
    public MutableComponent getNormalMessage() {
        MutableComponent cost;
        MutableComponent action = this.tradeType.getActionPhrase();
        MutableComponent itemText = ItemData.format(this.items.get(0), this.items.get(1));
        if (this.tradeType == TradeDirection.BARTER) {
            cost = itemText;
            itemText = ItemData.format(this.items.get(2), this.items.get(3));
        } else {
            cost = this.cost.getText("NULL");
        }
        return LCText.NOTIFICATION_TRADE_ITEM.get(this.customer, action, itemText, cost);
    }

    @Override
    protected void saveNormal(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.put("TraderInfo", (Tag)this.traderData.save(lookup));
        compound.putInt("TradeType", this.tradeType.index);
        ListTag itemList = new ListTag();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save(lookup));
        }
        compound.put("Items", (Tag)itemList);
        if (this.tradeType != TradeDirection.BARTER) {
            compound.put("Price", (Tag)this.cost.save());
        }
        compound.putString("Customer", this.customer);
    }

    @Override
    protected void loadNormal(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.traderData = new TraderCategory(compound.getCompound("TraderInfo"), lookup);
        this.tradeType = TradeDirection.fromIndex(compound.getInt("TradeType"));
        ListTag itemList = compound.getList("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(ItemData.load(itemList.getCompound(i), lookup));
        }
        if (this.tradeType != TradeDirection.BARTER) {
            this.cost = MoneyValue.safeLoad(compound, "Price");
        }
        this.customer = compound.getString("Customer");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof ItemTradeNotification) {
            ItemTradeNotification itn = (ItemTradeNotification)other;
            if (!itn.traderData.matches(this.traderData)) {
                return false;
            }
            if (itn.tradeType != this.tradeType) {
                return false;
            }
            if (itn.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i).matches(itn.items.get(i))) continue;
                return false;
            }
            if (itn.cost.equals(this.cost)) {
                return false;
            }
            if (!itn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(itn);
        }
        return false;
    }
}

