/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.ProductComparisonResult;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.client.ItemTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemTradeData
extends TradeData {
    ItemTradeRestriction restriction = ItemTradeRestriction.NONE;
    SimpleContainer items = new SimpleContainer(4);
    final List<Boolean> enforceNBT = Lists.newArrayList((Object[])new Boolean[]{true, true, true, true});
    TradeDirection tradeType = TradeDirection.SALE;
    String customName1 = "";
    String customName2 = "";

    @Nonnull
    public static TradeDirection getNextInCycle(@Nonnull TradeDirection direction) {
        int index = direction.index + 1;
        if (index > TradeDirection.BARTER.index) {
            index = 0;
        }
        return TradeDirection.fromIndex(index);
    }

    public ItemTradeData(boolean validateRules) {
        super(validateRules);
        this.resetNBTList();
    }

    private void resetNBTList() {
        for (int i = 0; i < 4; ++i) {
            this.enforceNBT.set(i, true);
        }
    }

    public ItemStack getSellItem(int index) {
        if (index >= 0 && index < 2) {
            return this.restriction.modifySellItem(this.items.getItem(index).copy(), this.getCustomName(index), this);
        }
        return ItemStack.EMPTY;
    }

    public List<ItemStack> getRandomSellItems(ItemTraderData trader) {
        return this.restriction.getRandomSellItems(trader, this);
    }

    public ItemStack getBarterItem(int index) {
        if (index >= 0 && index < 2) {
            return this.items.getItem(index + 2).copy();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getItem(int index) {
        if (index >= 0 && index < 2) {
            return this.getSellItem(index);
        }
        if (index >= 2 && index < 4) {
            return this.getBarterItem(index - 2);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(ItemStack itemStack, int index) {
        if (index >= 0 && index < 4) {
            if (index < 2) {
                if (this.restriction.allowSellItem(itemStack) || itemStack.isEmpty()) {
                    this.items.setItem(index, this.restriction.filterSellItem(itemStack).copy());
                }
            } else {
                this.items.setItem(index, itemStack.copy());
            }
        } else {
            LightmansCurrency.LogError("Cannot define the item trades item at index " + index + ". Must be between 0-3!");
        }
    }

    public boolean alwaysEnforcesNBT(int slot) {
        return this.restriction.alwaysEnforceNBT(slot);
    }

    public boolean getEnforceNBT(int slot) {
        if (slot >= 0 && slot < 4) {
            return this.enforceNBT.get(slot) != false || this.alwaysEnforcesNBT(slot);
        }
        return true;
    }

    public void setEnforceNBT(int slot, boolean newValue) {
        if (slot >= 0 && slot < 4) {
            this.enforceNBT.set(slot, newValue || this.alwaysEnforcesNBT(slot));
        }
    }

    public ItemRequirement getItemRequirement(int slot) {
        if (slot >= 0 && slot < 4) {
            if (this.getEnforceNBT(slot)) {
                return ItemRequirement.of(this.getItem(slot));
            }
            return ItemRequirement.ofItemNoNBT(this.getItem(slot));
        }
        return ItemRequirement.getNull();
    }

    public boolean allowItemInStorage(ItemStack item) {
        for (int i = 0; i < (this.isBarter() ? 4 : 2); ++i) {
            if (!this.getItemRequirement(i).test(item)) continue;
            return true;
        }
        return this.restriction.allowExtraItemInStorage(item);
    }

    public boolean shouldStorageItemBeSaved(ItemStack item) {
        if ((this.isSale() || this.isBarter()) && this.isValid()) {
            for (int i = 0; i < 2; ++i) {
                if (this.getEnforceNBT(i) || !this.getItemRequirement(i).test(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCustomName(int index) {
        return !this.getCustomName(index).isEmpty();
    }

    public String getCustomName(int index) {
        return switch (index) {
            case 0 -> this.customName1;
            case 1 -> this.customName2;
            default -> "";
        };
    }

    public void setCustomName(int index, String customName) {
        switch (index) {
            case 0: {
                this.customName1 = customName;
                break;
            }
            case 1: {
                this.customName2 = customName;
            }
        }
    }

    @Override
    public TradeDirection getTradeDirection() {
        return this.tradeType;
    }

    public boolean isSale() {
        return this.tradeType == TradeDirection.SALE;
    }

    public boolean isPurchase() {
        return this.tradeType == TradeDirection.PURCHASE;
    }

    public boolean isBarter() {
        return this.tradeType == TradeDirection.BARTER;
    }

    public void setTradeType(TradeDirection tradeDirection) {
        this.tradeType = tradeDirection;
        this.validateRuleStates();
    }

    @Nonnull
    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(ItemTradeRestriction restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isValid() {
        if (this.tradeType == TradeDirection.BARTER) {
            return this.sellItemsDefined() && this.barterItemsDefined();
        }
        return super.isValid() && this.sellItemsDefined();
    }

    public boolean sellItemsDefined() {
        return !this.getSellItem(0).isEmpty() || !this.getSellItem(1).isEmpty();
    }

    public boolean barterItemsDefined() {
        return !this.getBarterItem(0).isEmpty() || !this.getBarterItem(1).isEmpty();
    }

    public boolean hasStock(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(trader) > 0;
    }

    public boolean hasSpace(ItemTraderData trader, List<ItemStack> collectableItems) {
        return switch (this.tradeType) {
            case TradeDirection.PURCHASE, TradeDirection.BARTER -> trader.getStorage().canFitItems(collectableItems);
            default -> true;
        };
    }

    public int stockCount(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (trader.isCreative()) {
            return 1;
        }
        if (this.tradeType == TradeDirection.PURCHASE) {
            return this.stockCountOfCost(trader);
        }
        if (this.tradeType == TradeDirection.SALE || this.tradeType == TradeDirection.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this);
        }
        return 0;
    }

    @Override
    public int getStock(@Nonnull TradeContext context) {
        TraderData traderData;
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (!context.hasTrader() || !((traderData = context.getTrader()) instanceof ItemTraderData)) {
            return 0;
        }
        ItemTraderData trader = (ItemTraderData)traderData;
        if (trader.isCreative()) {
            return 1;
        }
        if (this.tradeType == TradeDirection.PURCHASE) {
            return this.stockCountOfCost(context);
        }
        if (this.tradeType == TradeDirection.SALE || this.tradeType == TradeDirection.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this);
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasItems(this.getItemRequirement(0), this.getItemRequirement(1));
        }
        if (this.isBarter()) {
            return context.hasItems(this.getItemRequirement(2), this.getItemRequirement(3));
        }
        return false;
    }

    public void RemoveItemsFromStorage(TraderItemStorage storage, List<ItemStack> soldItems) {
        this.restriction.removeItemsFromStorage(storage, soldItems);
    }

    @Override
    public CompoundTag getAsNBT(@Nonnull HolderLookup.Provider lookup) {
        CompoundTag tradeNBT = super.getAsNBT(lookup);
        InventoryUtil.saveAllItems("Items", tradeNBT, (Container)this.items, lookup);
        tradeNBT.putString("TradeDirection", this.tradeType.name());
        tradeNBT.putString("CustomName1", this.customName1);
        tradeNBT.putString("CustomName2", this.customName2);
        ArrayList<Integer> ignoreNBTSlots = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            if (this.getEnforceNBT(i)) continue;
            ignoreNBTSlots.add(i);
        }
        if (!ignoreNBTSlots.isEmpty()) {
            tradeNBT.putIntArray("IgnoreNBT", ignoreNBTSlots);
        }
        return tradeNBT;
    }

    public static void saveAllData(CompoundTag nbt, List<ItemTradeData> data, @Nonnull HolderLookup.Provider lookup) {
        ItemTradeData.saveAllData(nbt, data, "Trades", lookup);
    }

    public static void saveAllData(CompoundTag nbt, List<ItemTradeData> data, String key, @Nonnull HolderLookup.Provider lookup) {
        ListTag listNBT = new ListTag();
        for (ItemTradeData datum : data) {
            listNBT.add((Object)datum.getAsNBT(lookup));
        }
        nbt.put(key, (Tag)listNBT);
    }

    public static ItemTradeData loadData(CompoundTag compound, boolean validateRules, @Nonnull HolderLookup.Provider lookup) {
        ItemTradeData trade = new ItemTradeData(validateRules);
        trade.loadFromNBT(compound, lookup);
        return trade;
    }

    public static List<ItemTradeData> loadAllData(CompoundTag nbt, boolean validateRules, @Nonnull HolderLookup.Provider lookup) {
        return ItemTradeData.loadAllData("Trades", nbt, validateRules, lookup);
    }

    public static List<ItemTradeData> loadAllData(String key, CompoundTag compound, boolean validateRules, @Nonnull HolderLookup.Provider lookup) {
        ArrayList<ItemTradeData> data = new ArrayList<ItemTradeData>();
        ListTag listNBT = compound.getList(key, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            data.add(ItemTradeData.loadData(listNBT.getCompound(i), validateRules, lookup));
        }
        return data;
    }

    @Override
    public void loadFromNBT(CompoundTag nbt, @Nonnull HolderLookup.Provider lookup) {
        super.loadFromNBT(nbt, lookup);
        if (nbt.contains("Items", 9)) {
            this.items = InventoryUtil.loadAllItems("Items", nbt, 4, lookup);
        }
        this.tradeType = nbt.contains("TradeDirection", 8) ? ItemTradeData.loadTradeType(nbt.getString("TradeDirection")) : TradeDirection.SALE;
        this.customName1 = nbt.contains("CustomName1") ? nbt.getString("CustomName1") : (nbt.contains("CustomName") ? nbt.getString("CustomName") : "");
        this.customName2 = nbt.contains("CustomName2") ? nbt.getString("CustomName2") : "";
        this.resetNBTList();
        if (nbt.contains("IgnoreNBT")) {
            for (int i : nbt.getIntArray("IgnoreNBT")) {
                if (i < 0 || i >= this.enforceNBT.size()) continue;
                this.enforceNBT.set(i, false);
            }
        }
    }

    public static TradeDirection loadTradeType(String name) {
        TradeDirection value = TradeDirection.SALE;
        try {
            value = TradeDirection.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            LightmansCurrency.LogError("Could not load '" + name + "' as a TradeDirection.");
        }
        return value;
    }

    public static List<ItemTradeData> listOfSize(int tradeCount, boolean validateRules) {
        ArrayList<ItemTradeData> data = new ArrayList<ItemTradeData>();
        while (data.size() < tradeCount) {
            data.add(new ItemTradeData(validateRules));
        }
        return data;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        TradeComparisonResult result = new TradeComparisonResult();
        if (otherTrade instanceof ItemTradeData) {
            ItemTradeData otherItemTrade = (ItemTradeData)otherTrade;
            result.setCompatible();
            result.addProductResults(ProductComparisonResult.CompareTwoItems(this.getSellItem(0), this.getSellItem(1), otherItemTrade.getSellItem(0), otherItemTrade.getSellItem(1), this.compareNBT(otherItemTrade, 0)));
            if (this.isBarter()) {
                result.addProductResults(ProductComparisonResult.CompareTwoItems(this.getBarterItem(0), this.getBarterItem(1), otherItemTrade.getBarterItem(0), otherItemTrade.getBarterItem(1), this.compareNBT(otherItemTrade, 2)));
            }
            if (!this.isBarter()) {
                result.comparePrices(this.getCost(), otherTrade.getCost());
            }
            result.setTypeResult(this.tradeType == otherItemTrade.tradeType);
        }
        return result;
    }

    private boolean compareNBT(@Nonnull ItemTradeData otherItemTrade, int startingSlot) {
        for (int i = startingSlot; i < startingSlot + 2; ++i) {
            ItemStack true1 = this.getItem(i);
            ItemStack expected1 = otherItemTrade.getItem(i);
            if (true1.isEmpty() && expected1.isEmpty() || !this.enforceNBT.get(i).booleanValue() && !otherItemTrade.enforceNBT.get(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        int i;
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() < 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            ProductComparisonResult sellResult = result.getProductResult(i);
            if (sellResult.SameProductType() && sellResult.SameProductNBT()) {
                if (!(this.isSale() || this.isBarter() ? sellResult.ProductQuantityDifference() < 0 : this.isPurchase() && sellResult.ProductQuantityDifference() > 0)) continue;
                return false;
            }
            return false;
        }
        if (this.isBarter()) {
            if (result.getProductResultCount() < 4) {
                return false;
            }
            for (i = 0; i < 2; ++i) {
                ProductComparisonResult barterResult = result.getProductResult(i + 2);
                if (barterResult.SameProductType() && barterResult.SameProductNBT()) {
                    if (barterResult.ProductQuantityDifference() <= 0) continue;
                    return false;
                }
                return false;
            }
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!differences.PriceMatches()) {
            if (differences.PriceIncompatible()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_MONEY_TYPE.getWithStyle(ChatFormatting.RED));
            }
            if (this.isPurchase()) {
                if (differences.isPriceCheaper()) {
                    list.add((Component)LCText.GUI_TRADE_DIFFERENCE_PURCHASE_CHEAPER.get(differences.priceDifference().getText()).withStyle(ChatFormatting.RED));
                } else {
                    list.add((Component)LCText.GUI_TRADE_DIFFERENCE_PURCHASE_EXPENSIVE.get(differences.priceDifference().getText()).withStyle(ChatFormatting.GOLD));
                }
            } else if (differences.isPriceExpensive()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_EXPENSIVE.get(differences.priceDifference().getText()).withStyle(ChatFormatting.RED));
            } else {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_CHEAPER.get(differences.priceDifference().getText()).withStyle(ChatFormatting.GOLD));
            }
        }
        for (int i = 0; i < differences.getProductResultCount(); ++i) {
            int slot = this.isPurchase() ? i + 2 : i;
            ChatFormatting moreColor = slot >= 2 ? ChatFormatting.RED : ChatFormatting.GOLD;
            ChatFormatting lessColor = slot >= 2 ? ChatFormatting.GOLD : ChatFormatting.RED;
            MutableComponent slotName = slot >= 2 ? LCText.GUI_TRADE_DIFFERENCE_ITEM_PURCHASING.get(new Object[0]) : LCText.GUI_TRADE_DIFFERENCE_ITEM_SELLING.get(new Object[0]);
            ProductComparisonResult productCheck = differences.getProductResult(i);
            if (!productCheck.SameProductType()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_TYPE.get(slotName).withStyle(ChatFormatting.RED));
                continue;
            }
            if (!productCheck.SameProductNBT()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_NBT.get(slotName).withStyle(ChatFormatting.RED));
                continue;
            }
            if (productCheck.SameProductQuantity()) continue;
            int quantityDifference = productCheck.ProductQuantityDifference();
            if (quantityDifference > 0) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_QUANTITY_MORE.get(slotName, quantityDifference).withStyle(moreColor));
                continue;
            }
            list.add((Component)LCText.GUI_TRADE_DIFFERENCE_ITEM_QUANTITY_LESS.get(slotName, -quantityDifference).withStyle(lessColor));
        }
        return list;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new ItemTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
            if (this.isPurchase() && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (data.shiftHeld() || sellItem.isEmpty() && heldItem.isEmpty()) {
                    tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index));
                } else if (InventoryUtil.ItemMatches(sellItem, heldItem) && data.mouseButton() == 1) {
                    sellItem.setCount(Math.min(sellItem.getCount() + 1, sellItem.getMaxStackSize()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.copy();
                    if (data.mouseButton() == 1) {
                        setItem.setCount(1);
                    }
                    this.setItem(setItem, index);
                }
                if (tab.isClient()) {
                    tab.SendInputInteractionMessage(tradeIndex, index, data, heldItem);
                }
            } else if (this.isBarter() && index >= 0 && index < 2) {
                ItemStack barterItem = this.getBarterItem(index);
                if (data.shiftHeld() || barterItem.isEmpty() && heldItem.isEmpty()) {
                    tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index + 2));
                } else if (InventoryUtil.ItemMatches(barterItem, heldItem) && data.mouseButton() == 1) {
                    barterItem.setCount(Math.min(barterItem.getCount() + 1, barterItem.getMaxStackSize()));
                    this.setItem(barterItem, index + 2);
                } else {
                    ItemStack setItem = heldItem.copy();
                    if (data.mouseButton() == 1) {
                        setItem.setCount(1);
                    }
                    this.setItem(setItem, index + 2);
                }
                if (((ITraderStorageMenu)tab.menu).isClient()) {
                    tab.SendInputInteractionMessage(tradeIndex, index, data, heldItem);
                }
            }
        }
    }

    public void onSlotInteraction(int index, ItemStack heldItem, int button) {
        ItemStack setItem;
        if (index < 2) {
            ItemStack sellItem = this.getSellItem(index);
            if (sellItem.isEmpty() && heldItem.isEmpty()) {
                return;
            }
            if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                sellItem.setCount(Math.min(sellItem.getCount() + 1, sellItem.getMaxStackSize()));
                this.setItem(sellItem, index);
            } else {
                setItem = heldItem.copy();
                if (button == 1) {
                    setItem.setCount(1);
                }
                this.setItem(setItem, index);
            }
        }
        if (this.isBarter() && index >= 2 && index < 4) {
            ItemStack barterItem = this.getItem(index);
            if (barterItem.isEmpty() && heldItem.isEmpty()) {
                return;
            }
            if (InventoryUtil.ItemMatches(barterItem, heldItem) && button == 1) {
                barterItem.setCount(Math.min(barterItem.getCount() + 1, barterItem.getMaxStackSize()));
                this.setItem(barterItem, index);
            } else {
                setItem = heldItem.copy();
                if (button == 1) {
                    setItem.setCount(1);
                }
                this.setItem(setItem, index);
            }
        }
    }

    @Override
    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if ((this.isSale() || this.isBarter()) && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (data.shiftHeld() || sellItem.isEmpty() && heldItem.isEmpty()) {
                    tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index));
                } else if (InventoryUtil.ItemMatches(sellItem, heldItem) && data.mouseButton() == 1) {
                    sellItem.setCount(Math.min(sellItem.getCount() + 1, sellItem.getMaxStackSize()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.copy();
                    if (data.mouseButton() == 1) {
                        setItem.setCount(1);
                    }
                    this.setItem(setItem, index);
                }
                if (((ITraderStorageMenu)tab.menu).isClient()) {
                    tab.SendOutputInteractionMessage(tradeIndex, index, data, heldItem);
                }
            } else if (this.isPurchase()) {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
        }
    }

    @Override
    public void OnInteraction(@Nonnull BasicTradeEditTab tab, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex));
        }
    }

    @Override
    protected void collectRelevantInventorySlots(TradeContext context, List<Slot> slots, List<Integer> results) {
        if (this.isPurchase()) {
            context.hightlightItems(Lists.newArrayList((Object[])new ItemRequirement[]{this.getItemRequirement(0), this.getItemRequirement(1)}), slots, results);
        } else if (this.isBarter()) {
            context.hightlightItems(Lists.newArrayList((Object[])new ItemRequirement[]{this.getItemRequirement(2), this.getItemRequirement(3)}), slots, results);
        }
    }

    @Override
    public boolean isMoneyRelevant() {
        return !this.isBarter();
    }
}

