/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettings;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsObject;
import io.github.lightman314.lightmanscurrency.api.ticket.TicketGroupData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.text.TimeUnitTextEntry;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.client.PaygateTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DemandPricing;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PaygateTradeData
extends TradeData
implements IDirectionalSettingsObject {
    private PaygateTraderData parent = null;
    int duration = 1;
    int level = 15;
    private String description = "";
    private String tooltip = "";
    DirectionalSettings outputSettings = new DirectionalSettings(this);
    Item ticketItem = Items.AIR;
    long ticketID = Long.MIN_VALUE;
    int ticketColor = 0xFFFFFF;
    boolean storeTicketStubs = false;

    public PaygateTradeData() {
        super(true);
        for (Direction side : Direction.values()) {
            this.outputSettings.setState(side, DirectionalSettingsState.OUTPUT);
        }
    }

    public void setParent(PaygateTraderData parent) {
        this.parent = parent;
    }

    public int getDuration() {
        return Math.max(this.duration, 1);
    }

    public void setDuration(int duration) {
        this.duration = Math.max(duration, 1);
    }

    public int getRedstoneLevel() {
        return this.level;
    }

    public void setRedstoneLevel(int level) {
        this.level = Math.clamp((long)level, 1, 15);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public List<Component> getDescriptionTooltip() {
        if (!this.tooltip.isBlank()) {
            ArrayList<Component> lines = new ArrayList<Component>();
            for (String line : this.tooltip.split("\\\\n")) {
                lines.add((Component)EasyText.literal(line));
            }
            return lines;
        }
        return ImmutableList.of((Object)EasyText.literal(this.description));
    }

    public DirectionalSettings getOutputSides() {
        return this.outputSettings;
    }

    @Override
    public boolean allowInputs() {
        return false;
    }

    @Override
    @Nullable
    public Block getDisplayBlock() {
        return ModBlocks.PAYGATE.get();
    }

    @Override
    @Nullable
    public ResourceLocation getVariant() {
        return this.parent == null ? null : this.parent.getTraderBlockVariant();
    }

    @Override
    @Nonnull
    public DirectionalSettingsState getSidedState(@Nonnull Direction side) {
        return this.outputSettings.getState(side);
    }

    public int getTicketColor() {
        return this.ticketColor;
    }

    public boolean isTicketTrade() {
        return this.ticketID >= -1L;
    }

    public Item getTicketItem() {
        return this.ticketItem;
    }

    public long getTicketID() {
        return this.ticketID;
    }

    public void setTicket(ItemStack ticket) {
        TicketGroupData data = TicketGroupData.getForMaster(ticket);
        if (data != null && TicketItem.isMasterTicket(ticket)) {
            this.ticketItem = data.ticket;
            this.ticketID = TicketItem.GetTicketID(ticket);
            this.ticketColor = TicketItem.GetTicketColor(ticket);
        } else {
            this.ticketItem = Items.AIR;
            this.ticketID = Long.MIN_VALUE;
            this.ticketColor = 0xFFFFFF;
        }
        this.validateRuleStates();
    }

    @Override
    public int getStock(@Nonnull TradeContext context) {
        return this.isValid() ? 1 : 0;
    }

    @Override
    public boolean allowTradeRule(@Nonnull TradeRule rule) {
        if (rule instanceof DemandPricing) {
            return false;
        }
        return super.allowTradeRule(rule);
    }

    public boolean shouldStoreTicketStubs() {
        return this.storeTicketStubs;
    }

    public void setStoreTicketStubs(boolean value) {
        this.storeTicketStubs = value;
    }

    public ItemStack getTicketStub() {
        TicketGroupData data = TicketGroupData.getForTicket(new ItemStack((ItemLike)this.ticketItem));
        if (data != null) {
            return new ItemStack((ItemLike)data.ticketStub);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public TradeDirection getTradeDirection() {
        return TradeDirection.SALE;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isTicketTrade()) {
            return context.hasTicket(this.ticketID) || context.hasPass(this.ticketID);
        }
        return context.hasFunds(this.cost);
    }

    @Override
    public boolean isValid() {
        return this.getDuration() >= 1 && (this.isTicketTrade() || super.isValid());
    }

    public static void saveAllData(CompoundTag nbt, List<PaygateTradeData> data, @Nonnull HolderLookup.Provider lookup) {
        PaygateTradeData.saveAllData(nbt, data, "Trades", lookup);
    }

    public static void saveAllData(CompoundTag nbt, List<PaygateTradeData> data, String key, @Nonnull HolderLookup.Provider lookup) {
        ListTag listNBT = new ListTag();
        for (PaygateTradeData datum : data) {
            listNBT.add((Object)datum.getAsNBT(lookup));
        }
        if (!listNBT.isEmpty()) {
            nbt.put(key, (Tag)listNBT);
        }
    }

    public static PaygateTradeData loadData(CompoundTag nbt, @Nonnull HolderLookup.Provider lookup) {
        PaygateTradeData trade = new PaygateTradeData();
        trade.loadFromNBT(nbt, lookup);
        return trade;
    }

    public static List<PaygateTradeData> loadAllData(CompoundTag nbt, @Nonnull HolderLookup.Provider lookup) {
        return PaygateTradeData.loadAllData("Trades", nbt, lookup);
    }

    public static List<PaygateTradeData> loadAllData(String key, CompoundTag nbt, @Nonnull HolderLookup.Provider lookup) {
        ListTag listNBT = nbt.getList(key, 10);
        List<PaygateTradeData> data = PaygateTradeData.listOfSize(listNBT.size());
        for (int i = 0; i < listNBT.size(); ++i) {
            data.get(i).loadFromNBT(listNBT.getCompound(i), lookup);
        }
        return data;
    }

    public static List<PaygateTradeData> listOfSize(int tradeCount) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new PaygateTradeData());
        }
        return data;
    }

    public static void setupParents(List<PaygateTradeData> trades, PaygateTraderData parent) {
        for (PaygateTradeData trade : trades) {
            trade.setParent(parent);
        }
    }

    @Override
    public CompoundTag getAsNBT(@Nonnull HolderLookup.Provider lookup) {
        CompoundTag compound = super.getAsNBT(lookup);
        compound.putInt("Duration", this.getDuration());
        compound.putInt("Level", this.level);
        compound.putString("Description", this.description);
        compound.putString("Tooltip", this.tooltip);
        this.outputSettings.save(compound, "OutputSides");
        if (this.ticketID >= -1L) {
            compound.putString("TicketItem", BuiltInRegistries.ITEM.getKey((Object)this.ticketItem).toString());
            compound.putLong("TicketID", this.ticketID);
            compound.putInt("TicketColor", this.ticketColor);
            compound.putBoolean("StoreTicketStubs", this.storeTicketStubs);
        }
        return compound;
    }

    @Override
    protected void loadFromNBT(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.loadFromNBT(compound, lookup);
        this.duration = compound.getInt("Duration");
        this.outputSettings.load(compound, "OutputSides");
        if (compound.contains("Level")) {
            this.level = compound.getInt("Level");
        }
        if (compound.contains("Description")) {
            this.description = compound.getString("Description");
        }
        if (compound.contains("Tooltip")) {
            this.tooltip = compound.getString("Tooltip");
        }
        if (compound.contains("TicketID")) {
            this.ticketID = compound.getLong("TicketID");
            this.ticketItem = compound.contains("TicketItem") ? (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(compound.getString("TicketItem"))) : ModItems.TICKET.get();
        } else {
            this.ticketID = Long.MIN_VALUE;
            this.ticketItem = Items.AIR;
        }
        if (compound.contains("TicketColor")) {
            this.ticketColor = compound.getInt("TicketColor");
        } else if (this.ticketID >= -1L) {
            this.ticketColor = TicketItem.GetDefaultTicketColor(this.ticketID);
        }
        this.storeTicketStubs = compound.contains("StoreTicketStubs") ? compound.getBoolean("StoreTicketStubs") : false;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        LightmansCurrency.LogWarning("Attempting to compare paygate trades, but paygate trades do not support this interaction.");
        return new TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        LightmansCurrency.LogWarning("Attempting to determine if the paygate trades differences are acceptable, but paygate trades do not support this interaction.");
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        LightmansCurrency.LogWarning("Attempting to get warnings for different paygate trades, but paygate trades do not support this interaction.");
        return Lists.newArrayList();
    }

    public static MutableComponent formatDurationShort(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        MutableComponent result = EasyText.empty();
        if (hours > 0) {
            result.append((Component)PaygateTradeData.formatUnitShort(hours, LCText.TIME_UNIT_HOUR));
        }
        if (minutes > 0) {
            result.append((Component)PaygateTradeData.formatUnitShort(minutes, LCText.TIME_UNIT_MINUTE));
        }
        if (seconds > 0) {
            result.append((Component)PaygateTradeData.formatUnitShort(seconds, LCText.TIME_UNIT_SECOND));
        }
        if (ticks > 0 || result.getString().isBlank()) {
            result.append((Component)PaygateTradeData.formatUnitShort(ticks, LCText.TIME_UNIT_TICK));
        }
        return result;
    }

    public static MutableComponent formatDurationDisplay(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        if (hours > 0) {
            return PaygateTradeData.formatUnitShort(hours, LCText.TIME_UNIT_HOUR);
        }
        if (minutes > 0) {
            return PaygateTradeData.formatUnitShort(minutes, LCText.TIME_UNIT_MINUTE);
        }
        if (seconds > 0) {
            return PaygateTradeData.formatUnitShort(seconds, LCText.TIME_UNIT_SECOND);
        }
        return PaygateTradeData.formatUnitShort(ticks, LCText.TIME_UNIT_TICK);
    }

    public static MutableComponent formatDuration(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        MutableComponent result = EasyText.empty();
        boolean addSpacer = false;
        if (hours > 0) {
            PaygateTradeData.appendUnit(result, false, hours, LCText.TIME_UNIT_HOUR);
            addSpacer = true;
        }
        if (minutes > 0) {
            PaygateTradeData.appendUnit(result, addSpacer, minutes, LCText.TIME_UNIT_MINUTE);
            addSpacer = true;
        }
        if (seconds > 0) {
            PaygateTradeData.appendUnit(result, addSpacer, seconds, LCText.TIME_UNIT_SECOND);
            addSpacer = true;
        }
        if (ticks > 0) {
            PaygateTradeData.appendUnit(result, addSpacer, ticks, LCText.TIME_UNIT_TICK);
        }
        return result;
    }

    private static void appendUnit(@Nonnull MutableComponent result, boolean addSpacer, int count, @Nonnull TimeUnitTextEntry entry) {
        if (addSpacer) {
            result.append((Component)EasyText.literal(" "));
        }
        result.append((Component)EasyText.literal(String.valueOf(count)));
        if (count > 1) {
            result.append((Component)entry.pluralText.get(new Object[0]));
        } else {
            result.append((Component)entry.fullText.get(new Object[0]));
        }
    }

    @Nonnull
    private static MutableComponent formatUnitShort(int count, @Nonnull TimeUnitTextEntry entry) {
        return EasyText.literal(String.valueOf(count)).append((Component)entry.shortText.get(new Object[0]));
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new PaygateTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            if (TicketItem.isMasterTicket(heldItem)) {
                this.setTicket(heldItem);
                if (((ITraderStorageMenu)tab.menu).isClient()) {
                    tab.SendInputInteractionMessage(tradeIndex, 0, data, heldItem);
                }
            } else {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setBoolean("PriceEdit", true));
            }
        }
    }

    @Override
    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setBoolean("PriceEdit", false));
        }
    }

    @Override
    public void OnInteraction(@Nonnull BasicTradeEditTab tab, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex));
        }
    }

    @Override
    public boolean isMoneyRelevant() {
        return !this.isTicketTrade();
    }
}

