/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.TradeLimitTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TradeLimit
extends TradeRule {
    public static final TradeRuleType<TradeLimit> TYPE = new TradeRuleType<TradeLimit>(VersionUtil.lcResource("trade_limit"), TradeLimit::new);
    private int limit = 1;
    int count = 0;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = MathUtil.clamp(newLimit, 1, 100);
    }

    public void resetCount() {
        this.count = 0;
    }

    private TradeLimit() {
        super(TYPE);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_COUNT;
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.count >= this.limit) {
            event.addDenial(LCText.TRADE_RULE_TRADE_LIMIT_DENIAL.get(this.count));
            event.addDenial(LCText.TRADE_RULE_PLAYER_TRADE_LIMIT_DENIAL_LIMIT.get(this.limit));
        } else {
            event.addHelpful(LCText.TRADE_RULE_TRADE_LIMIT_INFO.get(this.count, this.limit));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        ++this.count;
        event.markDirty();
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.putInt("Limit", this.limit);
        compound.putInt("Count", this.count);
    }

    @Override
    public JsonObject saveToJson(JsonObject json, HolderLookup.Provider lookup) {
        json.addProperty("Limit", (Number)this.limit);
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("Limit", 3)) {
            this.limit = compound.getInt("Limit");
        }
        if (compound.contains("Count", 3)) {
            this.count = compound.getInt("Count");
        }
    }

    @Override
    public void loadFromJson(JsonObject json, HolderLookup.Provider lookup) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
    }

    @Override
    public void handleUpdateMessage(Player player, LazyPacketData updateInfo) {
        if (updateInfo.contains("Limit")) {
            this.limit = updateInfo.getInt("Limit");
        } else if (updateInfo.contains("ClearMemory")) {
            this.count = 0;
        }
    }

    @Override
    public CompoundTag savePersistentData(HolderLookup.Provider lookup) {
        CompoundTag data = new CompoundTag();
        data.putInt("Count", this.count);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data, HolderLookup.Provider lookup) {
        if (data.contains("Count", 3)) {
            this.count = data.getInt("Count");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new TradeLimitTab(parent);
    }
}

