/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public final class SecurityUpgradeData {
    public static final SecurityUpgradeData DEFAULT = new SecurityUpgradeData(false, new CompoundTag());
    public static final Codec<SecurityUpgradeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("BreakIsValid").forGetter(d -> d.breakIsValid), (App)CompoundTag.CODEC.fieldOf("Owner").forGetter(d -> d.ownerTag)).apply((Applicative)builder, SecurityUpgradeData::new));
    public static final StreamCodec<FriendlyByteBuf, SecurityUpgradeData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        b.writeBoolean(d.breakIsValid);
        b.writeNbt((Tag)d.ownerTag);
    }, b -> new SecurityUpgradeData(b.readBoolean(), b.readNbt()));
    public final boolean breakIsValid;
    private final CompoundTag ownerTag;

    private SecurityUpgradeData(boolean breakIsValid, @Nonnull CompoundTag ownerTag) {
        this.breakIsValid = breakIsValid;
        this.ownerTag = ownerTag;
    }

    @Nonnull
    public OwnerData parseData(@Nonnull CoinChestBlockEntity be) {
        OwnerData data = new OwnerData(be);
        if (this.ownerTag.isEmpty()) {
            return data;
        }
        data.load(this.ownerTag, (HolderLookup.Provider)be.registryAccess());
        return data;
    }

    @Nonnull
    public SecurityUpgradeData withBreakIsValid(boolean newValue) {
        return new SecurityUpgradeData(newValue, this.ownerTag);
    }

    @Nonnull
    public SecurityUpgradeData withOwner(@Nonnull OwnerData data, @Nonnull HolderLookup.Provider lookup) {
        return new SecurityUpgradeData(this.breakIsValid, data.save(lookup));
    }

    public int hashCode() {
        return Objects.hash(this.breakIsValid, this.ownerTag);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecurityUpgradeData) {
            SecurityUpgradeData other = (SecurityUpgradeData)obj;
            return other.breakIsValid == this.breakIsValid && other.ownerTag.equals((Object)this.ownerTag);
        }
        return false;
    }
}

