/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.util;

import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;

public interface IClientTracker {
    public boolean isClient();

    default public boolean isServer() {
        return !this.isClient();
    }

    @Nonnull
    public static IClientTracker entityWrapper(@Nonnull Entity entity) {
        return () -> entity.level().isClientSide;
    }

    @Nonnull
    public static IClientTracker forKnown(boolean isClient) {
        return () -> isClient;
    }

    @Nonnull
    public static IClientTracker forClient() {
        return () -> true;
    }

    @Nonnull
    public static IClientTracker forServer() {
        return () -> false;
    }
}

