/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.util;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber
public class LookupHelper {
    private static RegistryAccess backupCache = null;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    private static void tagReloadedEvent(TagsUpdatedEvent event) {
        backupCache = event.getRegistryAccess();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    private static void villagerTradesEvent(VillagerTradesEvent event) {
        backupCache = event.getRegistryAccess();
    }

    @Nullable
    public static RegistryAccess getRegistryAccess() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.registryAccess();
        }
        RegistryAccess registryAccess = LightmansCurrency.getProxy().getClientRegistryHolder();
        return registryAccess == null ? backupCache : registryAccess;
    }

    @Nullable
    public static Holder<Enchantment> lookupEnchantment(@Nonnull HolderLookup.Provider lookup, @Nonnull ResourceKey<Enchantment> enchantment) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        lookup.lookup(Registries.ENCHANTMENT).flatMap(registry -> registry.get(enchantment)).ifPresent(result::set);
        return result.get();
    }
}

