/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.util;

import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TagUtil {
    public static CompoundTag saveBlockPos(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        return tag;
    }

    public static BlockPos loadBlockPos(CompoundTag tag) {
        return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
    }

    public static ListTag writeStringList(List<String> list) {
        ListTag result = new ListTag();
        for (String value : list) {
            result.add((Object)StringTag.valueOf((String)value));
        }
        return result;
    }

    public static List<String> loadStringList(ListTag list) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(list.getString(i));
        }
        return result;
    }

    public static ListTag writeUUIDList(List<UUID> list) {
        ListTag result = new ListTag();
        for (UUID value : list) {
            result.add((Object)NbtUtils.createUUID((UUID)value));
        }
        return result;
    }

    public static List<UUID> readUUIDList(ListTag list) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Tag tag : list) {
            result.add(NbtUtils.loadUUID((Tag)tag));
        }
        return result;
    }

    public static String writeModelResource(ModelResourceLocation modelID) {
        if (modelID.getVariant().equals("standalone")) {
            return modelID.id().toString();
        }
        return modelID.toString();
    }

    public static ModelResourceLocation readModelResource(String modelID) {
        if (modelID.contains("#")) {
            String[] split = modelID.split("#", 2);
            return new ModelResourceLocation(VersionUtil.parseResource(split[0]), split[1]);
        }
        return ModelResourceLocation.standalone((ResourceLocation)VersionUtil.parseResource(modelID));
    }
}

