/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ListingUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class EnchantedBookForCoinsTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("enchanted_book_for_coins");
    public static final Serializer SERIALIZER = new Serializer();
    protected final Item baseCoin;
    protected final int baseCoinCount;
    protected final TagKey<Enchantment> allowedEnchantments;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;
    private static final Item BASE_COIN = ModItems.COIN_GOLD.get();
    private static final int BASE_COIN_COUNT = 5;

    public EnchantedBookForCoinsTrade(int xp) {
        this(xp, (TagKey<Enchantment>)EnchantmentTags.TRADEABLE);
    }

    public EnchantedBookForCoinsTrade(int xp, @Nonnull TagKey<Enchantment> tag) {
        this(BASE_COIN, 5, tag, 12, xp, 0.05f);
    }

    public EnchantedBookForCoinsTrade(Item baseCoin, int baseCoinCount, int maxTrades, int xp, float priceMult) {
        this(baseCoin, baseCoinCount, (TagKey<Enchantment>)EnchantmentTags.TRADEABLE, maxTrades, xp, priceMult);
    }

    public EnchantedBookForCoinsTrade(Item baseCoin, int baseCoinCount, @Nonnull TagKey<Enchantment> tag, int maxTrades, int xp, float priceMult) {
        this.xp = xp;
        this.baseCoin = baseCoin;
        this.baseCoinCount = baseCoinCount;
        this.allowedEnchantments = tag;
        this.maxTrades = maxTrades;
        this.priceMult = priceMult;
    }

    public MerchantOffer getOffer(@Nonnull Entity trader, @Nonnull RandomSource rand) {
        Optional optional = trader.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getRandomElementOf(EnchantmentTags.TRADEABLE, rand);
        if (optional.isPresent()) {
            MoneyValue v;
            Holder holder = (Holder)optional.get();
            Enchantment enchantment = (Enchantment)holder.value();
            int level = 1;
            if (enchantment.getMaxLevel() > 0) {
                level = rand.nextInt(enchantment.getMaxLevel()) + 1;
            } else {
                LightmansCurrency.LogError("Enchantment of type '" + holder.getRegisteredName() + "' has a max enchantment level of " + enchantment.getMaxLevel() + ". Unable to properly randomize the enchantment level for a villager trade. Will default to a level 1 enchantment.");
            }
            ItemStack itemstack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(holder, level));
            ChainData chain = CoinAPI.API.ChainDataOfCoin(this.baseCoin);
            if (chain == null) {
                LightmansCurrency.LogWarning("Book for coin trade failed as '" + new ItemStack((ItemLike)this.baseCoin).getHoverName().getString() + "' is not a registered coin!");
                return null;
            }
            long baseValue = chain.getCoreValue(this.baseCoin) * (long)this.baseCoinCount;
            int valueRandom = rand.nextInt(5 + level * 10);
            long value = baseValue + baseValue * (long)(level + valueRandom);
            if (holder.is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
                value *= 2L;
            }
            if (!((v = CoinValue.fromNumber(chain.chain, value)) instanceof CoinValue)) {
                return null;
            }
            CoinValue coinValue = (CoinValue)v;
            List<ItemStack> coins = coinValue.getAsSeperatedItemList();
            ItemCost price1 = null;
            Optional<Object> price2 = Optional.empty();
            if (!coins.isEmpty()) {
                price1 = ListingUtil.costFor(coins.get(0));
            }
            if (coins.size() > 1) {
                price2 = Optional.of(ListingUtil.costFor(coins.get(1)));
            }
            if (price1 != null) {
                return new MerchantOffer(price1, price2, itemstack, this.maxTrades, this.xp, this.priceMult);
            }
        }
        return null;
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        @Nonnull
        public JsonObject serializeInternal(@Nonnull JsonObject json, @Nonnull VillagerTrades.ItemListing trade, @Nonnull HolderLookup.Provider lookup) {
            if (trade instanceof EnchantedBookForCoinsTrade) {
                EnchantedBookForCoinsTrade t = (EnchantedBookForCoinsTrade)trade;
                json.addProperty("Coin", BuiltInRegistries.ITEM.getKey((Object)t.baseCoin).toString());
                json.addProperty("StartCoinCount", (Number)t.baseCoinCount);
                json.addProperty("EnchantmentTag", t.allowedEnchantments.location().toString());
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        @Nonnull
        public VillagerTrades.ItemListing deserialize(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
            Item baseCoin = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Coin")));
            int baseCoinCount = GsonHelper.getAsInt((JsonObject)json, (String)"StartCoinCount");
            TagKey enchantmentTag = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"EnchantmentTag")));
            int maxTrades = GsonHelper.getAsInt((JsonObject)json, (String)"MaxTrades");
            int xp = GsonHelper.getAsInt((JsonObject)json, (String)"XP");
            float priceMult = GsonHelper.getAsFloat((JsonObject)json, (String)"PriceMult");
            return new EnchantedBookForCoinsTrade(baseCoin, baseCoinCount, (TagKey<Enchantment>)enchantmentTag, maxTrades, xp, priceMult);
        }
    }
}

