/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.configured;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods.VillagerTradeMod;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;

public class ConfiguredItemListing
implements VillagerTrades.ItemListing {
    final VillagerTrades.ItemListing tradeSource;
    final Supplier<VillagerTradeMod> modSupplier;

    public ConfiguredItemListing(@Nonnull VillagerTrades.ItemListing tradeSource, @Nonnull Supplier<VillagerTradeMod> modSupplier) {
        this.tradeSource = tradeSource;
        this.modSupplier = modSupplier;
    }

    public MerchantOffer getOffer(@Nonnull Entity trader, @Nonnull RandomSource random) {
        try {
            MerchantOffer offer;
            int attempts = 0;
            while ((offer = this.tradeSource.getOffer(trader, random)) == null && attempts++ < 100) {
            }
            if (attempts > 1) {
                if (offer == null) {
                    LightmansCurrency.LogError("Original Item Listing Class: " + this.tradeSource.getClass().getName());
                    throw new NullPointerException("The original Item Listing of the converted trade returned a null trade offer " + attempts + " times!");
                }
                LightmansCurrency.LogWarning("Original Item Listing Class: " + this.tradeSource.getClass().getName());
                LightmansCurrency.LogWarning("Converted Trade took " + attempts + " attempts to receive a non-null trade offer from the original Item Listing!");
            }
            assert (offer != null);
            VillagerTradeMod mod = this.modSupplier.get();
            ItemCost itemA = mod.modifyCost(trader, offer.getItemCostA());
            Optional<ItemCost> itemB = offer.getItemCostB();
            if (itemB.isPresent()) {
                itemB = Optional.of(mod.modifyCost(trader, (ItemCost)itemB.get()));
            }
            ItemStack itemC = mod.modifyResult(trader, offer.getResult());
            return new MerchantOffer(itemA, itemB, itemC, offer.getUses(), offer.getMaxUses(), offer.getXp(), offer.getPriceMultiplier(), offer.getDemand());
        }
        catch (Throwable t) {
            LightmansCurrency.LogDebug("Error converting trade:", t);
            return null;
        }
    }
}

