/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders;

import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MintRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private final int ingredientCount;
    private final Item result;
    private final int count;
    private int duration = 0;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private MintRecipeBuilder(@Nonnull Ingredient ingredient, int ingredientCount, @Nonnull ItemLike result, int count) {
        this.ingredient = ingredient;
        this.ingredientCount = ingredientCount;
        this.result = result.asItem();
        this.count = count;
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, 1, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, int inputCount, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, inputCount, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(input, 1, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, int inputCount, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(Ingredient.of((ItemLike[])new ItemLike[]{input}), inputCount, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, 1, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, int inputCount, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, inputCount, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(input, 1, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, int inputCount, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(Ingredient.of(input), inputCount, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, 1, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, int inputCount, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, inputCount, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(input, 1, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, int inputCount, @Nonnull ItemLike result, int resultCount) {
        return new MintRecipeBuilder(input, inputCount, result, resultCount);
    }

    @Nonnull
    public MintRecipeBuilder ofDuration(int duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public MintRecipeBuilder unlockedBy(@Nonnull String name, @Nonnull Criterion<?> criteria) {
        this.criteria.put(name, criteria);
        return this;
    }

    @Nonnull
    public MintRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @Nonnull
    public Item getResult() {
        return this.result;
    }

    public void save(@Nonnull RecipeOutput consumer, @Nonnull ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancement$builder = consumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        consumer.accept(id, (Recipe)new CoinMintRecipe(this.duration, this.ingredient, this.ingredientCount, new ItemStack((ItemLike)this.result, this.count)), advancement$builder.build(id.withPrefix("recipes/coin_mint/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient defined for " + String.valueOf(id));
        }
    }
}

