/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.data.types.BankDataCache;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketSelectBankAccount
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketSelectBankAccount> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_select_bank_account"));
    public static final CustomPacket.Handler<CPacketSelectBankAccount> HANDLER = new H();
    final BankReference account;

    public CPacketSelectBankAccount(BankReference account) {
        super(TYPE);
        this.account = account;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketSelectBankAccount message) {
        message.account.encode(buffer);
    }

    private static CPacketSelectBankAccount decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketSelectBankAccount(BankReference.decode(buffer));
    }

    private static class H
    extends CustomPacket.Handler<CPacketSelectBankAccount> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketSelectBankAccount::encode, CPacketSelectBankAccount::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketSelectBankAccount message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            BankDataCache data = BankDataCache.TYPE.get(false);
            if (data == null) {
                return;
            }
            data.setSelectedAccount(player, message.account);
        }
    }
}

