/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketOpenStorage
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketOpenStorage> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_trader_menu_storage"));
    public static final CustomPacket.Handler<CPacketOpenStorage> HANDLER = new H();
    private final long traderID;

    public CPacketOpenStorage(long traderID) {
        super(TYPE);
        this.traderID = traderID;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketOpenStorage message) {
        buffer.writeLong(message.traderID);
    }

    private static CPacketOpenStorage decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketOpenStorage(buffer.readLong());
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenStorage> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketOpenStorage::encode, CPacketOpenStorage::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketOpenStorage message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            TraderData trader;
            MenuValidator validator = SimpleValidator.NULL;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof IValidatedMenu) {
                IValidatedMenu tm = (IValidatedMenu)abstractContainerMenu;
                validator = tm.getValidator();
            }
            if ((trader = TraderAPI.API.GetTrader(false, message.traderID)) != null) {
                trader.openStorageMenu(player, validator);
            }
        }
    }
}

