/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import doggytalents.client.ClientSetup;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.NullDogModel;
import doggytalents.client.entity.render.CollarRenderManager;
import doggytalents.client.entity.render.layer.LayerFactory;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_927;
import org.joml.Matrix4f;

public class DogRenderer
extends class_927<Dog, DogModel> {
    private static final int TXTCLR_DIFFOWNER = 1464486474;
    private static final int TXTCLR_HEALTH_70_100 = 720707;
    private static final int TXTCLR_HEALTH_30_70 = 15727189;
    private static final int TXTCLR_HEALTH_0_30 = 0xFF3636;
    private static final int TXTCLR_HEALTH_BKG = 0x4A4A4A;
    private static final int TXCLR_SEPERATOR = -6184543;
    private DogModel defaultModel;
    private NullDogModel nullDogModel;
    private List<class_3887<Dog, DogModel>> originalDogLayers = List.of();

    public DogRenderer(class_5617.class_5618 ctx) {
        super(ctx, null, 0.5f);
        DogModelRegistry.resolve(ctx);
        this.defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
        for (LayerFactory<Dog, DogModel> layer : CollarRenderManager.getLayers()) {
            this.method_4046(layer.createLayer((class_3883<Dog, DogModel>)this, ctx));
        }
        this.originalDogLayers = new ArrayList<class_3887<Dog, DogModel>>(this.field_4738);
        this.nullDogModel = new NullDogModel(ctx.method_32167(ClientSetup.DOG_NULL));
        this.field_4737 = this.nullDogModel;
    }

    protected float getBob(Dog livingBase, float partialTicks) {
        return super.method_4045((class_1309)livingBase, partialTicks);
    }

    public void render(Dog dog, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        DogSkin skin = dog.getClientSkin();
        this.field_4737 = skin.useCustomModel() ? dog.getClientSkin().getCustomModel().getValue() : this.defaultModel;
        ((DogModel)this.field_4737).resetWetShade();
        if (dog.isDogSoaked() && !dog.dogVariant().preventWetShade()) {
            float f = dog.getShadingWhileWet(partialTicks);
            ((DogModel)this.field_4737).setWetShade(f);
        }
        if (((Boolean)ConfigHandler.CLIENT.BLOCK_THIRD_PARTY_NAMETAG.get()).booleanValue()) {
            this.MobRenderer_render(dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            super.method_4054((class_1309)dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
        this.field_4737 = this.nullDogModel;
    }

    private class_2561 getNameUnknown(Dog dogIn) {
        return class_2561.method_43471((String)(dogIn.method_6139() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed"));
    }

    public class_2960 getTextureLocation(Dog dogIn) {
        return DogTextureManager.INSTANCE.getTexture(dogIn);
    }

    protected void scale(Dog dogIn, class_4587 matrixStackIn, float partialTickTime) {
        DogModel model;
        float size = dogIn.method_6109() ? 0.5f : dogIn.getDogSize().getScale();
        this.field_4673 = size * 0.5f;
        DogSkin skin = dogIn.getClientSkin();
        if (skin.useCustomModel() && (model = skin.getCustomModel().getValue()).hasDefaultScale()) {
            float default_scale = model.getDefaultScale();
            matrixStackIn.method_22905(default_scale, default_scale, default_scale);
            this.field_4673 *= default_scale;
        }
    }

    protected boolean shouldShowName(Dog p_115506_) {
        return (Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_DOG_NAME.get() != false || super.method_4071((class_1308)p_115506_);
    }

    protected void renderNameTag(Dog dog, class_2561 text, class_4587 stack, class_4597 buffer, int packedLight, float pTicks) {
        boolean isDiffOwner;
        double d0 = this.field_4676.method_23168((class_1297)dog);
        class_746 player = class_310.method_1551().field_1724;
        boolean renderDiffOwnerName = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_DIFFOWNER_NAME_DIFFERENT) != false && dog != this.field_4676.field_4678;
        boolean bl = isDiffOwner = player == null || !Objects.equals(player.method_5667(), dog.method_6139());
        if (isDiffOwner && ((Boolean)ConfigHandler.CLIENT.DONT_RENDER_DIFFOWNER_NAME.get()).booleanValue()) {
            return;
        }
        if (d0 <= 4096.0) {
            this.renderMainName(dog, text, stack, buffer, packedLight, renderDiffOwnerName && isDiffOwner, isDiffOwner, !isDiffOwner && WhistleItem.isHoldingDutyWhistle((class_1309)player));
        }
        if (d0 <= 4096.0) {
            this.renderExtraInfo(dog, text, stack, buffer, packedLight, d0, renderDiffOwnerName && isDiffOwner, isDiffOwner);
        }
    }

    private void renderMainName(Dog dog, class_2561 text, class_4587 stack, class_4597 buffer, int light, boolean diffOwnerRender, boolean isDiffOwner, boolean renderDogOnDuty) {
        text = this.modifyMainText(dog, text, diffOwnerRender, renderDogOnDuty);
        this.renderDogText(dog, text, 0.0, 0.025f, stack, buffer, light, diffOwnerRender, isDiffOwner);
    }

    private int getBkgTextColorWithOpacity(boolean diffOwnerRender) {
        boolean color = false;
        float bkg_opacity = 0.0f;
        if (!diffOwnerRender) {
            bkg_opacity = class_310.method_1551().field_1690.method_19343(0.25f);
        }
        int alpha = (int)(bkg_opacity * 255.0f) << 24;
        return alpha | 0;
    }

    private void renderDogText(Dog dog, class_2561 text, double y_offset_from_default, float scale, class_4587 stack, class_4597 buffer, int light, boolean render_diffowner, boolean is_diffowner) {
        boolean dog_not_sneaking = !dog.method_21751();
        double render_y_offset = (double)(dog.method_17682() + 0.5f) + y_offset_from_default;
        stack.method_22903();
        stack.method_22904(0.0, render_y_offset, 0.0);
        stack.method_22907(this.field_4676.method_24197());
        stack.method_22905(scale, -scale, scale);
        Matrix4f pose = stack.method_23760().method_23761();
        class_327 font = this.method_3932();
        float tX = -font.method_27525((class_5348)text) / 2;
        float tY = 0.0f;
        boolean bkg_see_through = dog_not_sneaking && !is_diffowner && (Boolean)ConfigHandler.CLIENT.SHOW_DOG_NAME_THRU_WALL.get() != false;
        class_327.class_6415 bkg_display_mode = bkg_see_through ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        int bkg_color = this.getBkgTextColorWithOpacity(render_diffowner);
        int bkg_txtcolor = 0x20FFFFFF;
        font.method_30882(text, tX, tY, bkg_txtcolor, false, pose, buffer, bkg_display_mode, bkg_color, light);
        stack.method_22904(0.0, 0.0, 0.1);
        boolean draw_fg_text = dog_not_sneaking;
        if (draw_fg_text) {
            class_327.class_6415 fg_display_mode = class_327.class_6415.field_33993;
            int fg_color = 0;
            int fg_txtcolor = -1;
            font.method_30882(text, tX, tY, fg_txtcolor, false, pose, buffer, fg_display_mode, fg_color, light);
        }
        stack.method_22909();
    }

    private void renderExtraInfo(Dog dog, class_2561 text, class_4587 stack, class_4597 buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        this.renderInfoDogText(dog, text, stack, buffer, packedLight, d0, diffOwnerRender, isDiffOwner);
        this.renderSecondaryInfoDogText(dog, text, stack, buffer, packedLight, d0, diffOwnerRender, isDiffOwner);
    }

    private void renderInfoDogText(Dog dog, class_2561 text, class_4587 stack, class_4597 buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        boolean renderHealthInNameActivated = this.field_4676.field_4686.method_19331().method_5715() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        String seperator = (String)ConfigHandler.CLIENT.DOG_INFO_SEPERATOR.get();
        class_5250 seperator_c1 = this.createC1WithColor(seperator, -6184543);
        class_5250 extra_info_c1 = class_2561.method_43471((String)dog.getMode().getTip());
        Optional<class_2561> hunger_c1_optional = this.getHungerC1(dog, renderHealthInNameActivated);
        Optional<class_2561> gender_c1_optional = this.getGenderC1(dog);
        if (hunger_c1_optional.isPresent()) {
            extra_info_c1.method_10852((class_2561)seperator_c1);
            class_2561 hunger_c1 = hunger_c1_optional.get();
            extra_info_c1.method_10852(hunger_c1);
        }
        if (gender_c1_optional.isPresent()) {
            extra_info_c1.method_10852((class_2561)seperator_c1);
            class_2561 gender_c1 = gender_c1_optional.get();
            extra_info_c1.method_10852(gender_c1);
        }
        if (diffOwnerRender) {
            extra_info_c1 = this.createC1WithColor((class_2561)extra_info_c1, 1464486474);
        }
        this.renderDogText(dog, (class_2561)extra_info_c1, 0.12f, 0.01f, stack, buffer, packedLight, diffOwnerRender, isDiffOwner);
    }

    private void renderSecondaryInfoDogText(Dog dog, class_2561 text, class_4587 stack, class_4597 buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        if (d0 > 25.0) {
            return;
        }
        class_1297 camera_entity = this.field_4676.field_4686.method_19331();
        if (!camera_entity.method_5715()) {
            return;
        }
        if (dog.method_35057() == camera_entity) {
            return;
        }
        class_2561 ownerC0 = dog.getOwnersName().orElseGet(() -> this.getNameUnknown(dog));
        if (diffOwnerRender) {
            ownerC0 = this.createC1WithColor(ownerC0, 1464486474);
        }
        this.renderDogText(dog, ownerC0, -0.25, 0.01f, stack, buffer, packedLight, diffOwnerRender, isDiffOwner);
    }

    private Optional<class_2561> getHungerC1(Dog dog, boolean renderHealthInNameActivated) {
        boolean hightlight_red;
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && !dog.isDefeated()) {
            return Optional.empty();
        }
        String hunger_format = (String)ConfigHandler.CLIENT.DOG_INFO_HUNGER_FORMAT.get();
        int hunger = 0;
        hunger = dog.isDefeated() ? -dog.getDogIncapValue() : class_3532.method_15386((float)dog.getDogHunger());
        class_5250 hunger_c1 = class_2561.method_43470((String)String.format(Locale.ROOT, hunger_format, hunger));
        boolean bl = hightlight_red = dog.getDogHunger() <= 10.0f && renderHealthInNameActivated || dog.isDefeated();
        if (hightlight_red) {
            hunger_c1.method_27696(class_2583.field_24360.method_36139(0xFF3636));
        }
        return Optional.of(hunger_c1);
    }

    private Optional<class_2561> getGenderC1(Dog dog) {
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue()) {
            return Optional.empty();
        }
        class_5250 ret = class_2561.method_43471((String)dog.getGender().getUnlocalisedTip());
        return Optional.of(ret);
    }

    private class_2561 modifyMainText(Dog dog, class_2561 text, boolean diffOwnerRender, boolean renderDogOnDuty) {
        boolean renderHealthInNameActive;
        if (diffOwnerRender) {
            text = this.createC1WithColor(text, 1464486474);
            return text;
        }
        if (renderDogOnDuty) {
            if (dog.dogOnDuty()) {
                text = this.createC1WithColor(text, -61191);
            }
            return text;
        }
        if (dog.isDogInAnimDebug()) {
            text = this.createC1WithColor(text, -3299584);
            return text;
        }
        boolean bl = renderHealthInNameActive = this.field_4676.field_4686.method_19331().method_5715() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        if (renderHealthInNameActive) {
            text = this.colorTextWithHealth(dog, text);
        }
        return text;
    }

    private class_2561 colorTextWithHealth(Dog dog, class_2561 text) {
        int noCharsInName = text.getString().length();
        float healthPercentage = dog.method_6032() / dog.method_6063();
        healthPercentage = class_3532.method_15363((float)healthPercentage, (float)0.0f, (float)1.0f);
        int noCharHighlighted = class_3532.method_15386((float)((float)noCharsInName * healthPercentage));
        noCharHighlighted = class_3532.method_15340((int)noCharHighlighted, (int)0, (int)noCharsInName);
        String hlPart = text.getString().substring(0, noCharHighlighted);
        String nonHlPart = "";
        if (noCharHighlighted <= noCharsInName) {
            nonHlPart = text.getString().substring(noCharHighlighted, noCharsInName);
        }
        int color = 0xFF3636;
        if ((double)healthPercentage >= 0.7) {
            color = 720707;
        } else if ((double)healthPercentage >= 0.3) {
            color = 15727189;
        }
        class_5250 newTxt = this.createC1WithColor(hlPart, color);
        class_5250 restTxt = this.createC1WithColor(nonHlPart, 0x4A4A4A);
        newTxt.method_10852((class_2561)restTxt);
        text = newTxt;
        return text;
    }

    private class_5250 createC1WithColor(String str, int color) {
        return class_2561.method_43470((String)str).method_27696(class_2583.field_24360.method_36139(color));
    }

    private class_5250 createC1WithColor(class_2561 c1, int color) {
        return this.createC1WithColor(c1.getString(), color);
    }

    public void MobRenderer_render(Dog p_115455_, float p_115456_, float p_115457_, class_4587 p_115458_, class_4597 p_115459_, int p_115460_) {
        this.LivingEntityRenderer_render(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }

    public void LivingEntityRenderer_render(Dog p_115308_, float p_115309_, float p_115310_, class_4587 p_115311_, class_4597 p_115312_, int p_115313_) {
        boolean shouldSit;
        p_115311_.method_22903();
        ((DogModel)this.field_4737).field_3447 = this.method_4044((class_1309)p_115308_, p_115310_);
        ((DogModel)this.field_4737).field_3449 = shouldSit = false;
        ((DogModel)this.field_4737).field_3448 = p_115308_.method_6109();
        float f = class_3532.method_17821((float)p_115310_, (float)p_115308_.field_6220, (float)p_115308_.field_6283);
        float f1 = class_3532.method_17821((float)p_115310_, (float)p_115308_.field_6259, (float)p_115308_.field_6241);
        float f2 = f1 - f;
        if (shouldSit && p_115308_.method_5854() instanceof class_1309) {
            class_1309 livingentity = (class_1309)p_115308_.method_5854();
            f = class_3532.method_17821((float)p_115310_, (float)livingentity.field_6220, (float)livingentity.field_6283);
            f2 = f1 - f;
            float f3 = class_3532.method_15393((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = class_3532.method_16439((float)p_115310_, (float)p_115308_.field_6004, (float)p_115308_.method_36455());
        float f7 = this.getBob(p_115308_, p_115310_);
        this.setupRotations(p_115308_, p_115311_, f7, f, p_115310_, p_115308_.method_55693());
        p_115311_.method_22905(-1.0f, -1.0f, 1.0f);
        this.scale(p_115308_, p_115311_, p_115310_);
        p_115311_.method_46416(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && p_115308_.method_5805()) {
            f8 = p_115308_.field_42108.method_48570(p_115310_);
            f5 = p_115308_.field_42108.method_48572(p_115310_);
            if (p_115308_.method_6109()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((DogModel)this.field_4737).prepareMobModel(p_115308_, f5, f8, p_115310_);
        ((DogModel)this.field_4737).setupAnim(p_115308_, f5, f8, f7, f2, f6);
        class_310 minecraft = class_310.method_1551();
        boolean flag = this.method_4056((class_1309)p_115308_);
        boolean flag1 = !flag && !p_115308_.method_5756((class_1657)minecraft.field_1724);
        boolean flag2 = minecraft.method_27022((class_1297)p_115308_);
        class_1921 rendertype = this.method_24302((class_1309)p_115308_, flag, flag1, flag2);
        if (rendertype != null) {
            class_4588 vertexconsumer = p_115312_.getBuffer(rendertype);
            int i = DogRenderer.method_23622((class_1309)p_115308_, (float)this.method_23185((class_1309)p_115308_, p_115310_));
            ((DogModel)this.field_4737).method_2828(p_115311_, vertexconsumer, p_115313_, i, flag1 ? 0x26FFFFFF : -1);
        }
        if (!p_115308_.method_7325()) {
            for (class_3887<Dog, DogModel> renderlayer : this.originalDogLayers) {
                renderlayer.method_4199(p_115311_, p_115312_, p_115313_, (class_1297)p_115308_, f5, f8, p_115310_, f7, f2, f6);
            }
        }
        p_115311_.method_22909();
        if (this.shouldShowName(p_115308_)) {
            this.renderNameTag(p_115308_, p_115308_.method_5476(), p_115311_, p_115312_, p_115313_, p_115310_);
        }
    }

    protected void setupRotations(Dog p_115317_, class_4587 p_115318_, float p_115319_, float p_115320_, float p_115321_, float x) {
        if (((Boolean)ConfigHandler.CLIENT.BLOCK_THIRD_PARTY_NAMETAG.get()).booleanValue()) {
            if (p_115317_.field_6213 > 0) {
                float f = ((float)p_115317_.field_6213 + p_115321_ - 1.0f) / 20.0f * 1.6f;
                if ((f = class_3532.method_15355((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                p_115318_.method_22907(class_7833.field_40718.rotationDegrees(f * this.method_4039((class_1309)p_115317_)));
            } else {
                p_115318_.method_22907(class_7833.field_40716.rotationDegrees(180.0f - p_115320_));
            }
            return;
        }
        super.method_4058((class_1309)p_115317_, p_115318_, p_115319_, p_115320_, p_115321_, x);
    }
}

