/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView;

import doggytalents.DoggyEntityTypes;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView.DogSkinElement;
import doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView.SkinButtonElement;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.client.screen.framework.widget.ScrollBar;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_638;
import org.apache.commons.lang3.StringUtils;

public class SkinView
extends AbstractElement {
    Dog dog;
    List<DogSkin> textureList;
    Dog dummyDog;
    class_342 filterBox;
    ScrollBar scrollBar;
    FlatButton searchModeButton;
    boolean searchByTag;
    int activeSkinId;
    boolean skipReOffset;

    public SkinView(AbstractElement parent, class_437 screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        this.dummyDog = this.createDummyDog();
        this.filterBox = new class_342(class_310.method_1551().field_1772, 0, 0, 100, 16, (class_2561)class_2561.method_43473());
        this.filterBox.method_1863(str -> {
            this.method_25396().clear();
            this.activeSkinId = 0;
            this.init();
        });
        this.scrollBar = new ScrollBar(0, 0, 0, 0, ScrollBar.Direction.HORIZONTAL, 0, this.getScreen()){

            @Override
            public void onValueUpdated() {
                SkinView.this.calulateAndSetActiveId(this.getProgressValue());
            }
        };
        this.activeSkinId = DogTextureManager.INSTANCE.getAll().indexOf(dog.getClientSkin());
        this.searchByTag = false;
        this.searchModeButton = new FlatButton(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"doggui.style.skins.search_by_name"), b -> {
            this.searchByTag = !this.searchByTag;
            b.method_25355((class_2561)(this.searchByTag ? class_2561.method_43471((String)"doggui.style.skins.search_by_tags") : class_2561.method_43471((String)"doggui.style.skins.search_by_name")));
        });
    }

    @Override
    public AbstractElement init() {
        this.textureList = DogTextureManager.INSTANCE.getAll();
        this.textureList = this.filterValidDogSkin(this.textureList);
        String searchMsg = this.filterBox.method_1882();
        if (!searchMsg.isEmpty()) {
            this.textureList = this.filterDogSkin(this.textureList, searchMsg);
        }
        if (this.activeSkinId < 0) {
            this.activeSkinId = 0;
        } else if (this.activeSkinId >= this.textureList.size()) {
            this.activeSkinId = 0;
        }
        this.getPosition().setChildDirection(ElementPosition.ChildDirection.COL);
        DogSkinElement dogSkinPreview = new DogSkinElement(this, this.getScreen(), this.dog, this.dummyDog, this.textureList, this.activeSkinId);
        dogSkinPreview.setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 0.8f).setBackgroundColor(-2026490314).init();
        this.addChildren((class_364)dogSkinPreview);
        SkinButtonElement skinSelect = new SkinButtonElement(this, this.getScreen(), this.dog, this.textureList, this.activeSkinId, b -> this.decreaseActiveId((class_364)b), b -> this.increaseActiveId((class_364)b));
        skinSelect.setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 0.2f).setBackgroundColor(1079597144).init();
        this.addChildren((class_364)skinSelect);
        this.filterBox.method_46421(this.getRealX() + 8);
        this.filterBox.method_46419(this.getRealY() + 8);
        this.addChildren((class_364)this.filterBox);
        this.scrollBar.method_46421(this.getRealX());
        this.scrollBar.method_46419(this.getRealY() + this.getSizeY() - 8);
        this.scrollBar.method_25358(this.getSizeX());
        this.scrollBar.method_53533(8);
        int barsize = 0;
        if (!this.textureList.isEmpty()) {
            barsize = class_3532.method_15375((float)(this.scrollBar.method_25368() / this.textureList.size()));
            barsize = Math.max(barsize, 20);
        }
        this.scrollBar.setBarSize(barsize);
        if (this.skipReOffset) {
            this.skipReOffset = false;
        } else {
            this.moveBarToDog();
        }
        this.addChildren((class_364)this.scrollBar);
        this.searchModeButton.method_46421(this.getRealX() + this.getSizeX() - 107);
        this.searchModeButton.method_46419(this.getRealY() + 7);
        this.addChildren((class_364)this.searchModeButton);
        return this;
    }

    private void moveBarToDog() {
        if (this.textureList.isEmpty()) {
            return;
        }
        double progress = (double)this.activeSkinId / (double)(this.textureList.size() - 1);
        double barOffset = progress * (double)this.scrollBar.getMaxOffsetValue();
        this.scrollBar.setBarOffset(barOffset);
    }

    @Override
    public void renderElement(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private List<DogSkin> filterDogSkin(List<DogSkin> locList, String s) {
        if (this.searchByTag) {
            return this.filterDogSkinByTag(locList, s);
        }
        ArrayList<DogSkin> ret = new ArrayList<DogSkin>();
        for (DogSkin x : locList) {
            if (!StringUtils.containsIgnoreCase((CharSequence)x.getName(), (CharSequence)s)) continue;
            ret.add(x);
        }
        return ret;
    }

    private List<DogSkin> filterDogSkinByTag(List<DogSkin> locList, String s) {
        String[] tag_strs = s.split(Pattern.quote(" "));
        ArrayList<DogSkin> ret = new ArrayList<DogSkin>();
        for (DogSkin x : locList) {
            if (!this.isTagMatch(x, tag_strs)) continue;
            ret.add(x);
        }
        return ret;
    }

    private boolean isTagMatch(DogSkin skin, String[] tag_strs) {
        for (String str : tag_strs) {
            if (StringUtils.containsIgnoreCase((CharSequence)skin.getTags(), (CharSequence)str)) continue;
            return false;
        }
        return true;
    }

    private List<DogSkin> filterValidDogSkin(List<DogSkin> locList) {
        if (ConfigHandler.DogCustomSkinConfig.getStrategy() == ConfigHandler.DogCustomSkinConfig.DataStrategy.NONE) {
            return locList;
        }
        ArrayList<DogSkin> filtered = new ArrayList<DogSkin>(locList.size());
        for (DogSkin filter : locList) {
            String hash = DogTextureManager.INSTANCE.getHash(filter);
            if (!DogUtil.vertifySkinData(hash)) continue;
            filtered.add(filter);
        }
        return filtered;
    }

    private void decreaseActiveId(class_364 b) {
        this.activeSkinId = Math.max(0, this.activeSkinId - 1);
        this.method_25396().clear();
        this.init();
    }

    private void increaseActiveId(class_364 b) {
        this.activeSkinId = Math.min(this.textureList.size() - 1, this.activeSkinId + 1);
        this.method_25396().clear();
        this.init();
    }

    private void calulateAndSetActiveId(double progress) {
        int id = class_3532.method_15357((double)(progress * (double)(this.textureList.size() - 1)));
        if (this.activeSkinId == id) {
            return;
        }
        this.activeSkinId = id;
        this.skipReOffset = true;
        this.method_25396().clear();
        this.init();
    }

    private Dog createDummyDog() {
        class_638 level = class_310.method_1551().field_1687;
        Dog dog = (Dog)DoggyEntityTypes.DOG.get().method_5883((class_1937)level);
        return dog;
    }
}

