/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.framework.widget.TextOnlyButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class StringEntrySelectScreen
extends class_437 {
    private List<String> entries;
    private List<Integer> filteredIndexes;
    protected final MouseUpdate mouseUpdate = new MouseUpdate(this);
    protected final EntryView entryView = new EntryView(this);
    protected final TextField searchField = new TextField(this);
    private TextOnlyButton prevPageButton;
    private TextOnlyButton nextPageButton;
    private boolean isSneakPressed = false;

    public StringEntrySelectScreen(class_2561 title) {
        super(title);
        this.entries = new ArrayList<String>();
        this.filteredIndexes = new ArrayList<Integer>();
    }

    public void method_25426() {
        super.method_25426();
        this.addPageButtons();
        this.addUtilitiesButton();
    }

    protected void addPageButtons() {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        TextOnlyButton prevPage = new TextOnlyButton(half_width - this.getSelectAreaSize() / 2 - 20, half_height - 10, 20, 20, (class_2561)class_2561.method_43470((String)"<"), b -> this.prevPage(), this.field_22793);
        TextOnlyButton nextPage = new TextOnlyButton(half_width + this.getSelectAreaSize() / 2, half_height - 10, 20, 20, (class_2561)class_2561.method_43470((String)">"), b -> this.nextPage(), this.field_22793);
        this.prevPageButton = prevPage;
        this.nextPageButton = nextPage;
        this.method_37063((class_364)prevPage);
        this.method_37063((class_364)nextPage);
    }

    protected void addUtilitiesButton() {
    }

    protected void nextPage() {
        this.entryView.movePage(x -> x + 1);
    }

    protected void prevPage() {
        this.entryView.movePage(x -> x - 1);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.mouseUpdate.update(mouseX, mouseY);
        this.searchField.update();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.entryView.render(graphics);
        this.searchField.render(graphics);
        this.prevPageButton.field_22763 = this.entryView.prevPageActive();
        this.nextPageButton.field_22763 = this.entryView.nextPageActive();
    }

    protected void onMouseMoved(double mouseX, double mouseY) {
        this.entryView.onMouseMoved(mouseX, mouseY);
    }

    protected void drawSelectAreaBackground(class_332 graphics) {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        graphics.method_25294(half_width - this.getSelectAreaSize() / 2, half_height - this.getSelectAreaSize() / 2, half_width + this.getSelectAreaSize() / 2, half_height + this.getSelectAreaSize() / 2, Integer.MIN_VALUE);
    }

    protected void drawEntry(class_332 graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        class_5250 text = class_2561.method_43470((String)this.entries.get(entry_id)).method_10862(class_2583.field_24360.method_36139(color));
        text = this.modifyEntryText((class_2561)text, entry_id, is_selected);
        graphics.method_27535(this.field_22793, (class_2561)text, entry_x, entry_y, -1);
    }

    protected class_2561 modifyEntryText(class_2561 entryText, int entryId, boolean is_selected) {
        return entryText;
    }

    protected void drawNoEntryMsg(class_332 graphics, int x, int y) {
    }

    protected void drawPageIndicator(class_332 graphics, int pageCount, int activePage) {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        String page_str = activePage + 1 + "/" + pageCount;
        int page_str_width = this.field_22793.method_1727(page_str);
        graphics.method_25303(this.field_22793, page_str, half_width - page_str_width / 2, half_height - this.getSelectAreaSize() / 2 - this.getPageIndicatorOffset(), -1);
    }

    public boolean method_25400(char code, int p_231042_2_) {
        return this.searchField.charTyped(code, p_231042_2_);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean move_right;
        boolean move_left;
        boolean focus_search_field;
        boolean text_field_focused;
        class_310 mc = class_310.method_1551();
        boolean bl = text_field_focused = this.searchField.focusState() == TextField.FocusState.FOCUS;
        if (mc.field_1690.field_1832.method_1417(keyCode, scanCode)) {
            this.isSneakPressed = true;
        }
        if (this.entryView.keyPressed(text_field_focused, keyCode, scanCode, modifiers)) {
            return true;
        }
        boolean bl2 = focus_search_field = mc.field_1690.field_1903.method_1417(keyCode, scanCode) && this.isSneakPressed && this.searchField.focusState() == TextField.FocusState.NONE;
        if (focus_search_field) {
            this.searchField.setFocusState(TextField.FocusState.READY);
            return true;
        }
        boolean bl3 = move_left = !text_field_focused && (keyCode == 263 || mc.field_1690.field_1913.method_1417(keyCode, scanCode));
        if (move_left) {
            if (this.prevPageButton.field_22763) {
                this.prevPageButton.method_25348(0.0, 0.0);
            }
            return true;
        }
        boolean bl4 = move_right = !text_field_focused && (keyCode == 262 || mc.field_1690.field_1849.method_1417(keyCode, scanCode));
        if (move_right) {
            if (this.nextPageButton.field_22763) {
                this.nextPageButton.method_25348(0.0, 0.0);
            }
            return true;
        }
        if (this.searchField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        boolean is_confirm;
        boolean text_field_focus_ready;
        class_310 mc = class_310.method_1551();
        boolean bl = text_field_focus_ready = this.searchField.focusState() == TextField.FocusState.READY && mc.field_1690.field_1903.method_1417(keyCode, scanCode);
        if (text_field_focus_ready) {
            this.searchField.setFocusState(TextField.FocusState.FOCUS);
        }
        if (mc.field_1690.field_1832.method_1417(keyCode, scanCode)) {
            this.isSneakPressed = false;
        }
        boolean bl2 = is_confirm = keyCode == 257 || mc.field_1690.field_1903.method_1417(keyCode, scanCode) && !this.isSneakPressed && this.searchField.focusState() == TextField.FocusState.NONE;
        if (is_confirm) {
            Optional<Integer> selected_indx = this.entryView.getSelectedFilterId(this.filteredIndexes);
            if (selected_indx.isPresent()) {
                this.onEntrySelected(selected_indx.get());
            }
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double x, double y, int p_94697_) {
        this.searchField.setFocusState(TextField.FocusState.NONE);
        Optional<Integer> clicked_id = this.entryView.getHoveringEntry(x, y, this.filteredIndexes);
        if (clicked_id.isPresent()) {
            this.onEntrySelected(clicked_id.get());
            return true;
        }
        return super.method_25402(x, y, p_94697_);
    }

    protected void onEntrySelected(int id) {
    }

    protected void updateEntries(List<String> new_entries) {
        if (new_entries == null) {
            return;
        }
        this.entries = new_entries;
        this.updateFilteredIndexes();
    }

    protected void onTextFieldUpdated() {
        this.updateFilteredIndexes();
    }

    protected void updateFilteredIndexes() {
        this.filteredIndexes.clear();
        String search_str = this.searchField.getValue();
        if (search_str == null || search_str.isEmpty()) {
            for (int i = 0; i < this.entries.size(); ++i) {
                this.filteredIndexes.add(i);
            }
            this.onFilteredIndexesUpdated();
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean matched;
            String entry = this.entries.get(i);
            if (entry.length() < search_str.length()) continue;
            boolean bl = matched = this.matchIgnoreCaseSearch() ? entry.toLowerCase().contains(search_str.toLowerCase()) : entry.contains(search_str);
            if (!matched) continue;
            this.filteredIndexes.add(i);
        }
        this.onFilteredIndexesUpdated();
    }

    protected void onFilteredIndexesUpdated() {
        this.entryView.onFilteredIndexesUpdated(this.filteredIndexes);
    }

    public void setBlockCharInputTime(int millis) {
        this.searchField.setBlockCharInputTime(millis);
    }

    public Optional<Integer> getHoveredEntry(int mouseX, int mouseY) {
        return this.entryView.getHoveringEntry(mouseX, mouseY, this.filteredIndexes);
    }

    protected int getMaxEntriesPerPage() {
        return 19;
    }

    protected int getSelectAreaSize() {
        return 200;
    }

    protected int getSearchBarOffset() {
        return 7;
    }

    protected int getPageIndicatorOffset() {
        return 10;
    }

    protected int getSpacePerEntry() {
        return 10;
    }

    protected int getHightlightSelectedColor() {
        return -61191;
    }

    protected int getMaxSearchBufferSize() {
        return 64;
    }

    protected boolean matchIgnoreCaseSearch() {
        return false;
    }

    @Nullable
    public class_364 method_25399() {
        return null;
    }

    public boolean method_25421() {
        return false;
    }

    public static class MouseUpdate {
        private final StringEntrySelectScreen parent;
        private boolean startedUpdate = false;
        private int mouseX0 = 0;
        private int mouseY0 = 0;

        private MouseUpdate(StringEntrySelectScreen parent) {
            this.parent = parent;
        }

        public void update(int mouseX, int mouseY) {
            if (this.startedUpdate) {
                this.updateMouseMoved(mouseX, mouseY);
            } else {
                this.mayStartUpdatingMouseMove(mouseX, mouseY);
            }
        }

        private void updateMouseMoved(int mouseX, int mouseY) {
            boolean mouse_moved;
            boolean bl = mouse_moved = this.mouseX0 != mouseX || this.mouseY0 != mouseY;
            if (!mouse_moved) {
                return;
            }
            this.parent.onMouseMoved(mouseX, mouseY);
            this.mouseX0 = mouseX;
            this.mouseY0 = mouseY;
        }

        private void mayStartUpdatingMouseMove(int mouseX, int mouseY) {
            int half_width = this.parent.field_22789 / 2;
            int half_height = this.parent.field_22790 / 2;
            int dx = Math.abs(mouseX - half_width);
            int dy = Math.abs(mouseY - half_height);
            if (dx > 10 || dy > 10) {
                this.startedUpdate = true;
                this.mouseX0 = mouseX;
                this.mouseY0 = mouseY;
            }
        }
    }

    public static class EntryView {
        private final StringEntrySelectScreen parent;
        private int pageCount = 1;
        private int activePage = 0;
        private int selectedEntryInPage = 0;

        public boolean keyPressed(boolean textFieldFocused, int keyCode, int scanCode, int modifiers) {
            boolean is_up;
            boolean is_down;
            class_310 mc = class_310.method_1551();
            class_3675.class_306 mouseKey = class_3675.method_15985((int)keyCode, (int)scanCode);
            boolean bl = is_down = keyCode == 264 || !textFieldFocused && mc.field_1690.field_1881.method_1417(keyCode, scanCode);
            if (is_down) {
                this.moveSelectedEntryInPage(x -> x + 1);
                return true;
            }
            boolean bl2 = is_up = keyCode == 265 || !textFieldFocused && mc.field_1690.field_1894.method_1417(keyCode, scanCode);
            if (is_up) {
                this.moveSelectedEntryInPage(x -> x - 1);
                return true;
            }
            return false;
        }

        public void onMouseMoved(double mouseX, double mouseY) {
            Optional<Integer> new_indx_optional = this.getHoveredIndexInPage(mouseX, mouseY);
            if (!new_indx_optional.isPresent()) {
                return;
            }
            int new_indx = new_indx_optional.get();
            this.moveSelectedEntryInPage(x -> new_indx);
        }

        public void onFilteredIndexesUpdated(List<Integer> filtered_indexes) {
            this.resetSelectedEntryInPage();
            this.updatePages(filtered_indexes);
        }

        public Optional<Integer> getHoveringEntry(double x, double y, List<Integer> filtered_indexes) {
            if (filtered_indexes.isEmpty()) {
                return Optional.empty();
            }
            Optional<Integer> indx_optional = this.getHoveredIndexInPage(x, y);
            if (!indx_optional.isPresent()) {
                return Optional.empty();
            }
            return this.getSelectedFilterId(filtered_indexes);
        }

        public boolean prevPageActive() {
            return this.activePage > 0;
        }

        public boolean nextPageActive() {
            return this.activePage < this.pageCount - 1;
        }

        private EntryView(StringEntrySelectScreen parent) {
            this.parent = parent;
        }

        private void updatePages(List<Integer> filtered_indexes) {
            int filter_size = filtered_indexes.size();
            this.activePage = 0;
            this.pageCount = filter_size / this.parent.getMaxEntriesPerPage();
            if (filter_size % this.parent.getMaxEntriesPerPage() > 0) {
                ++this.pageCount;
            }
        }

        protected void render(class_332 graphics) {
            this.parent.drawSelectAreaBackground(graphics);
            this.drawEntries(graphics);
            this.parent.drawPageIndicator(graphics, this.pageCount, this.activePage);
        }

        protected void drawEntries(class_332 graphics) {
            int half_width = this.parent.field_22789 / 2;
            int half_height = this.parent.field_22790 / 2;
            int entry_offset = 0;
            int entry_start_x = half_width - this.parent.getSelectAreaSize() / 2 + 2;
            int entry_start_y = half_height - this.parent.getSelectAreaSize() / 2 + 2;
            int startIndx = this.activePage * this.parent.getMaxEntriesPerPage();
            int drawNo = 0;
            if (this.parent.filteredIndexes.isEmpty()) {
                this.parent.drawNoEntryMsg(graphics, entry_start_x, entry_start_y);
                return;
            }
            for (int i = startIndx; i < this.parent.filteredIndexes.size(); ++i) {
                this.parent.drawEntry(graphics, entry_start_x, entry_start_y + entry_offset, this.parent.filteredIndexes.get(i), i == startIndx + this.selectedEntryInPage);
                entry_offset += this.parent.getSpacePerEntry();
                if (++drawNo >= this.parent.getMaxEntriesPerPage()) break;
            }
        }

        public void movePage(IntFunction<Integer> mover) {
            if (this.pageCount <= 0) {
                return;
            }
            int new_page = mover.apply(this.activePage);
            this.activePage = class_3532.method_15340((int)new_page, (int)0, (int)(this.pageCount - 1));
            this.onPageMove();
        }

        protected void onPageMove() {
            this.resetSelectedEntryInPage();
        }

        public int getCurrentPageEntries() {
            boolean is_last_page;
            boolean bl = is_last_page = this.activePage >= this.pageCount - 1;
            if (!is_last_page) {
                return this.parent.getMaxEntriesPerPage();
            }
            int exccess = this.parent.filteredIndexes.size() % this.parent.getMaxEntriesPerPage();
            return exccess != 0 ? exccess : this.parent.filteredIndexes.size();
        }

        public Optional<Integer> getSelectedFilterId(List<Integer> filter_list) {
            if (filter_list.isEmpty()) {
                return Optional.empty();
            }
            int ret = this.activePage * this.parent.getMaxEntriesPerPage() + this.selectedEntryInPage;
            if (0 <= ret && ret < filter_list.size()) {
                return Optional.of(filter_list.get(ret));
            }
            return Optional.empty();
        }

        protected final void moveSelectedEntryInPage(IntFunction<Integer> mover) {
            int current_page_entries = this.getCurrentPageEntries();
            if (current_page_entries <= 0) {
                return;
            }
            int new_value = mover.apply(this.selectedEntryInPage);
            this.selectedEntryInPage = class_3532.method_15340((int)new_value, (int)0, (int)(current_page_entries - 1));
        }

        protected final void resetSelectedEntryInPage() {
            this.selectedEntryInPage = 0;
        }

        public Optional<Integer> getHoveredIndexInPage(double x, double y) {
            boolean outside_of_area;
            int entry_size = this.getCurrentPageEntries();
            int mX = this.parent.field_22789 / 2;
            int mY = this.parent.field_22790 / 2;
            int area_size = this.parent.getSelectAreaSize();
            boolean bl = outside_of_area = Math.abs(x - (double)mX) > (double)(area_size / 2) || Math.abs(y - (double)mY) > (double)(area_size / 2);
            if (outside_of_area) {
                return Optional.empty();
            }
            int baseY = mY - area_size / 2;
            int indx = class_3532.method_15357((double)(y - (double)baseY)) / this.parent.getSpacePerEntry();
            if (indx >= entry_size) {
                return Optional.empty();
            }
            return Optional.of(indx);
        }
    }

    public static class TextField {
        private final StringEntrySelectScreen parent;
        private long blockCharInputMillis = 0L;
        private long prevMillis = 0L;
        private String searchString = "";
        private FocusState focusState = FocusState.NONE;

        private TextField(StringEntrySelectScreen parent) {
            this.parent = parent;
        }

        public String getValue() {
            return this.searchString;
        }

        public void update() {
            if (this.blockCharInputMillis <= 0L) {
                return;
            }
            long passed = System.currentTimeMillis() - this.prevMillis;
            if (passed > 0L) {
                this.blockCharInputMillis -= passed;
                this.prevMillis = System.currentTimeMillis();
            }
        }

        public void render(class_332 graphics) {
            int selected_area_size = this.parent.getSelectAreaSize();
            int half_width = this.parent.field_22789 / 2;
            int half_height = this.parent.field_22790 / 2;
            int txtorgx = half_width - selected_area_size / 2 + 10;
            int txtorgy = half_height + selected_area_size / 2 + this.parent.getSearchBarOffset();
            graphics.method_25294(half_width - selected_area_size / 2, half_height + selected_area_size / 2 + 5, half_width + selected_area_size / 2, half_height + selected_area_size / 2 + 17, Integer.MIN_VALUE);
            if (this.isActive()) {
                graphics.method_25303(this.parent.field_22793, this.searchString + "_", txtorgx, txtorgy, -1);
            }
        }

        public void insertText(String x) {
            if (this.searchString.length() < this.parent.getMaxSearchBufferSize()) {
                this.searchString = this.searchString + x;
            }
            this.parent.onTextFieldUpdated();
        }

        public void popCharInText() {
            if (this.searchString.length() <= 0) {
                return;
            }
            this.searchString = this.searchString.substring(0, this.searchString.length() - 1);
            this.parent.onTextFieldUpdated();
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (!this.isActive()) {
                return false;
            }
            if (keyCode == 259) {
                this.popCharInText();
                return true;
            }
            return false;
        }

        public boolean charTyped(char code, int p_231042_2_) {
            if (!this.isActive()) {
                return false;
            }
            if (class_3544.method_57175((char)code)) {
                this.insertText(Character.toString(code));
                return true;
            }
            return false;
        }

        public void setBlockCharInputTime(int millis) {
            this.blockCharInputMillis = millis;
            this.prevMillis = System.currentTimeMillis();
        }

        public boolean isActive() {
            return this.focusState == FocusState.FOCUS && this.blockCharInputMillis <= 0L;
        }

        public FocusState focusState() {
            return this.focusState;
        }

        public void setFocusState(FocusState focusState) {
            this.focusState = focusState;
        }

        public static enum FocusState {
            NONE,
            READY,
            FOCUS;

        }
    }
}

