/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.element;

import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ScrollView
extends AbstractElement {
    private static final double SCROLL_SPEED = 10.0;
    private static final int SCROLL_BAR_MARGIN_HORZ = 6;
    private static final int SCROLL_BAR_MARGIN_RIGHT = 4;
    private static final int SCROLL_BAR_THICK = 3;
    private static final int SCROLL_BAR_HANDLE_CLR = -2631209;
    private static final int SCROLL_BAR_REST_CLR = -1864902185;
    long millis0;
    long scrollBarAppearDuration = 0L;
    ScrollContentContainer container;

    public ScrollView(AbstractElement parent, class_437 screen) {
        super(parent, screen);
    }

    @Override
    public AbstractElement init() {
        this.container = new ScrollContentContainer(this, this.getScreen());
        this.container.init();
        this.addChildren((class_364)this.container);
        this.scrollBarAppearDuration = 0L;
        return this;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_44379(this.getRealX(), this.getRealY(), this.getRealX() + this.getSizeX(), this.getRealY() + this.getSizeY());
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        long millis = System.currentTimeMillis();
        long millis_elapsed = millis - this.millis0;
        if (this.scrollBarAppearDuration > 0L && millis_elapsed > 0L) {
            this.scrollBarAppearDuration -= millis_elapsed;
            this.millis0 = millis;
            this.drawScrollBar(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.method_44380();
    }

    private void shiftWidgetOffsetRescursive(List<? extends class_364> childrens, int offset) {
        if (offset == 0) {
            return;
        }
        for (class_364 class_3642 : childrens) {
            if (class_3642 instanceof class_339) {
                class_339 widget = (class_339)class_3642;
                widget.method_46419(widget.method_46427() + offset);
                continue;
            }
            if (!(class_3642 instanceof AbstractElement)) continue;
            AbstractElement element = (AbstractElement)class_3642;
            this.shiftWidgetOffsetRescursive(element.method_25396(), offset);
        }
    }

    private void drawScrollBar(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int fullBarSize = this.getSizeY() - 12;
        int containerSize = this.container.getSizeY();
        if (containerSize <= 0) {
            return;
        }
        if (containerSize <= this.getSizeY()) {
            return;
        }
        float viewportToFullRatio = (float)this.getSizeY() / (float)containerSize;
        int handleSize = class_3532.method_15375((float)(viewportToFullRatio * (float)fullBarSize));
        int maxHandleOffset = fullBarSize - handleSize;
        int handleOffset = class_3532.method_15375((float)(this.getPercentScrolled() * (float)maxHandleOffset));
        int barX = this.getRealX() + this.getSizeX() - 4 - 3;
        int barY = this.getRealY() + 6;
        graphics.method_25294(barX, barY, barX + 3, barY + fullBarSize, -1864902185);
        int handleX = barX;
        int handleY = barY + handleOffset;
        graphics.method_25294(handleX, handleY, handleX + 3, handleY + handleSize, -2631209);
    }

    public boolean method_25401(double x, double y, double dir_x, double dir) {
        this.scrollBarAppearDuration = 1500L;
        this.millis0 = System.currentTimeMillis();
        int offset0 = this.container.getOffset();
        this.container.setOffset(class_3532.method_15384((double)((double)this.container.getOffset() + -dir * 10.0)));
        int maxOff = this.getMaxOffset();
        if (this.container.getOffset() < 0) {
            this.container.setOffset(0);
        } else if (this.container.getOffset() >= maxOff) {
            this.container.setOffset(maxOff);
        }
        int offset1 = this.container.getOffset();
        this.shiftWidgetOffsetRescursive(this.container.method_25396(), -(offset1 - offset0));
        return super.method_25401(x, y, dir_x, dir);
    }

    @Override
    public void renderElement(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void addScrollChildren(AbstractElement element) {
        this.container.addChildren((class_364)element);
    }

    public int getMaxOffset() {
        return Math.max(0, this.container.getSizeY() - this.getSizeY());
    }

    public float getPercentScrolled() {
        int maxOff = this.getMaxOffset();
        if (maxOff <= 0) {
            return 1.0f;
        }
        return (float)this.container.getPosition().getScrollYOffset() / (float)maxOff;
    }

    public AbstractElement getContainer() {
        return this.container;
    }

    public boolean method_25402(double x, double y, int p_94697_) {
        if (!this.method_25405(x, y)) {
            return false;
        }
        return super.method_25402(x, y, p_94697_);
    }

    private static class ScrollContentContainer
    extends AbstractElement {
        public ScrollContentContainer(AbstractElement parent, class_437 screen) {
            super(parent, screen);
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.SCROLL_ABSOLUTE, 0, 0).setSizeDynamicY(this.getParent().getSizeX()).getPosition().setChildDirection(ElementPosition.ChildDirection.COL);
            return this;
        }

        @Override
        public void renderElement(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        }

        public int getOffset() {
            return this.getPosition().getScrollYOffset();
        }

        public void setOffset(int off) {
            this.getPosition().setScrollYOffset(off);
        }
    }
}

