/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import doggytalents.client.entity.render.RenderUtil;
import doggytalents.common.util.Util;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_6382;

public class FlatCheckbox
extends class_4264 {
    private static final int DEFAULT_COLOR = 0x5E5D5D;
    private static final int DEFAULT_ACTIVE_COLOR = 7667877;
    private static final int HOVER_MASK = -2097152000;
    private static final int NON_HOVER_MASK = 0x48000000;
    private class_327 font;
    protected final OnChange onPress;
    private boolean value = false;
    private int activeColor;
    private float animTimeline = 0.0f;
    private long millis0 = 0L;

    public FlatCheckbox(int x, int y, int activeColor, OnChange onPress) {
        super(x, y, 28, 14, (class_2561)class_2561.method_43473());
        this.font = class_310.method_1551().field_1772;
        this.onPress = onPress;
        this.activeColor = activeColor;
        this.millis0 = System.currentTimeMillis();
    }

    public FlatCheckbox(int x, int y, OnChange onPress) {
        this(x, y, 7667877, onPress);
    }

    public void method_25306() {
        this.onPress.onChange(this);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float pTicks) {
        if (!this.field_22763) {
            this.animTimeline = 0.0f;
            return;
        }
        this.updateAnim();
        int bg_color = this.maskColorHovered(this.colorLerp(0x5E5D5D, this.activeColor, this.animTimeline));
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, bg_color);
        int nob_spacing = 2;
        int nob_size = this.method_25364() - 4;
        int nob_x = this.getNobX(2, nob_size);
        int nob_y = this.method_46427() + 2;
        if (this.value) {
            graphics.method_25294(nob_x, nob_y, nob_x + nob_size, nob_y + nob_size, -1);
        } else {
            graphics.method_25294(nob_x, nob_y, nob_x + nob_size, nob_y + nob_size, -1);
        }
    }

    private void updateAnim() {
        long current_millis = System.currentTimeMillis();
        long passed_millis = current_millis - this.millis0;
        if (passed_millis <= 0L) {
            return;
        }
        this.millis0 = current_millis;
        float anim_amount = (float)passed_millis / (float)this.getAnimMillis();
        this.animTimeline += this.value ? anim_amount : -anim_amount;
        this.animTimeline = class_3532.method_15363((float)this.animTimeline, (float)0.0f, (float)1.0f);
    }

    private int getNobX(int nob_spacing, int nob_size) {
        int nobX_true = this.method_46426() + this.method_25368() - nob_spacing - nob_size;
        int nobX_false = this.method_46426() + nob_spacing;
        if (nobX_false > nobX_true) {
            int sw = nobX_true;
            nobX_true = nobX_false;
            nobX_false = sw;
        }
        int ret = (int)class_3532.method_16439((float)this.animTimeline, (float)nobX_false, (float)nobX_true);
        return class_3532.method_15340((int)ret, (int)nobX_false, (int)nobX_true);
    }

    private int colorLerp(int from_color, int to_color, float progress) {
        int[] acolor0 = Util.rgbIntToIntArray(from_color);
        int[] acolor1 = Util.rgbIntToIntArray(to_color);
        int red = (int)class_3532.method_15363((float)((float)acolor0[0] + (float)(acolor1[0] - acolor0[0]) * progress), (float)0.0f, (float)255.0f);
        int green = (int)class_3532.method_15363((float)((float)acolor0[1] + (float)(acolor1[1] - acolor0[1]) * progress), (float)0.0f, (float)255.0f);
        int blue = (int)class_3532.method_15363((float)((float)acolor0[2] + (float)(acolor1[2] - acolor0[2]) * progress), (float)0.0f, (float)255.0f);
        return RenderUtil.rgbToInt(new int[]{red, green, blue});
    }

    private int maskColorHovered(int color) {
        if (this.field_22762) {
            return color | 0x83000000;
        }
        return color | 0x48000000;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public FlatCheckbox initialValue(boolean value) {
        this.value = value;
        this.animTimeline = value ? 1.0f : 0.0f;
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    private int getAnimMillis() {
        return 30;
    }

    protected void method_47399(class_6382 p_259858_) {
    }

    public static interface OnChange {
        public void onChange(FlatCheckbox var1);
    }
}

