/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public class ScrollBar
extends class_339 {
    private int barSize;
    private double barOffset;
    private Direction dir;
    private class_437 screen;
    private boolean holdInflate;
    private long inflateAnim = 0L;
    private final long MAX_INFLATE_ANIM = 50L;
    private long prevAnimUpdateMillis = 0L;
    private boolean startedAnimate = false;

    public ScrollBar(int x, int y, int w, int h, Direction dir, int barsize, class_437 screen) {
        super(x, y, w, h, (class_2561)class_2561.method_43473());
        this.barSize = dir == Direction.VERTICAL ? Math.min(h, barsize) : Math.min(w, barsize);
        this.dir = dir;
        this.screen = screen;
        this.prevAnimUpdateMillis = System.currentTimeMillis();
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float pTicks) {
        long currentTimeMillis;
        long passedAnimMillis;
        if (!this.startedAnimate) {
            this.startedAnimate = true;
            this.prevAnimUpdateMillis = System.currentTimeMillis();
        }
        if ((passedAnimMillis = (currentTimeMillis = System.currentTimeMillis()) - this.prevAnimUpdateMillis) > 0L) {
            this.prevAnimUpdateMillis = currentTimeMillis;
        }
        int barOffset = class_3532.method_15357((double)this.barOffset);
        if (this.holdInflate) {
            this.holdInflate = this.screen.method_25397();
        }
        int BASE_THICK = 3;
        if (passedAnimMillis > 0L) {
            this.inflateAnim = !this.field_22762 && !this.holdInflate ? (this.inflateAnim -= passedAnimMillis) : (this.inflateAnim += passedAnimMillis);
        }
        if (this.inflateAnim < 0L) {
            this.inflateAnim = 0L;
        }
        if (this.inflateAnim > 50L) {
            this.inflateAnim = 50L;
        }
        float inflateAnimProgress = (float)this.inflateAnim / 50.0f;
        int maxBarThick = this.dir == Direction.VERTICAL ? this.method_25368() : this.method_25364();
        int barThickAfterAnim = 3 + class_3532.method_15386((float)(inflateAnimProgress * (float)maxBarThick));
        if (this.dir == Direction.VERTICAL) {
            graphics.method_25294(this.method_46426() + this.field_22758 - barThickAfterAnim, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -2026490314);
        } else {
            graphics.method_25294(this.method_46426(), this.method_46427() + this.field_22759 - barThickAfterAnim, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -2026490314);
        }
        if (this.dir == Direction.VERTICAL) {
            graphics.method_25294(this.method_46426() + this.method_25368() - barThickAfterAnim, this.method_46427() + barOffset, this.method_46426() + this.method_25368(), this.method_46427() + barOffset + this.barSize, -1);
        } else {
            graphics.method_25294(this.method_46426() + barOffset, this.method_46427() + this.method_25364() - barThickAfterAnim, this.method_46426() + barOffset + this.barSize, this.method_46427() + this.method_25364(), -1);
        }
    }

    protected void method_25349(double mouseX, double mouseY, double dY, double dX) {
        double offset;
        this.holdInflate = true;
        if (!this.checkAndHandleMouseOutBound(mouseX, mouseY)) {
            return;
        }
        double d = offset = this.dir == Direction.VERTICAL ? dX : dY;
        if (offset == 0.0) {
            return;
        }
        this.offsetBar(offset);
        this.onValueUpdated();
    }

    private boolean checkAndHandleMouseOutBound(double mouseX, double mouseY) {
        if (mouseX < (double)this.method_46426()) {
            if (this.barOffset > 0.0) {
                this.setBarOffset(0.0);
                this.onValueUpdated();
            }
            return false;
        }
        if (mouseX > (double)(this.method_46426() + this.field_22758)) {
            if (this.barOffset < (double)this.getMaxOffsetValue()) {
                this.setBarOffset(this.getMaxOffsetValue());
                this.onValueUpdated();
            }
            return false;
        }
        return true;
    }

    private void offsetBar(double offset) {
        this.barOffset = class_3532.method_15350((double)(this.barOffset + offset), (double)0.0, (double)this.getMaxOffsetValue());
    }

    public void setBarOffset(double offset) {
        this.barOffset = class_3532.method_15350((double)offset, (double)0.0, (double)this.getMaxOffsetValue());
    }

    public int getMaxOffsetValue() {
        int ret;
        int n = ret = this.dir == Direction.VERTICAL ? this.field_22759 - this.barSize : this.field_22758 - this.barSize;
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }

    public double getProgressValue() {
        int maxOffset = this.getMaxOffsetValue();
        if (maxOffset <= 0) {
            return 0.0;
        }
        return this.barOffset / (double)maxOffset;
    }

    public void onValueUpdated() {
    }

    public void setBarSize(int size) {
        this.barSize = size;
    }

    protected void method_47399(class_6382 p_259858_) {
    }

    public void method_53533(int h) {
        this.field_22759 = h;
    }

    public int method_25364() {
        return this.field_22759;
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

