/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.config;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import fuzs.forgeconfigapiport.fabric.api.forge.v4.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeModConfigEvents;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static ClientConfig CLIENT;
    public static ServerConfig SERVER;
    public static TalentConfig TALENT;
    public static RespawnTagConfig RESPAWN_TAGS;
    public static DogCustomSkinConfig CUSTOM_SKINS;
    public static DogCustomSkinClientConfig CUSTOM_SKINS_CLIENT;
    private static ForgeConfigSpec CONFIG_SERVER_SPEC;
    private static ForgeConfigSpec CONFIG_CLIENT_SPEC;
    private static ForgeConfigSpec CONFIG_TALENT_SPEC;
    private static ForgeConfigSpec CONFIG_RESPAWN_TAG_SPEC;
    private static ForgeConfigSpec CONFIG_CUSTOM_SKINS_SPEC;
    private static ForgeConfigSpec CONFIG_CUSTOM_SKINS_CLIENT_SPEC;
    public static final boolean ALWAYS_SHOW_DOG_NAME = true;
    public static final float DEFAULT_MAX_HUNGER = 120.0f;
    public static final boolean SEND_SKIN = false;
    public static final boolean DISPLAY_OTHER_DOG_SKINS = false;
    public static final boolean WHISTLE_SOUNDS = true;

    public static void init() {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG_SERVER_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)commonPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG_CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (ClientConfig)clientPair.getLeft();
        ForgeConfigRegistry.INSTANCE.register("doggytalents", ModConfig.Type.SERVER, (IConfigSpec)CONFIG_SERVER_SPEC);
        ForgeConfigRegistry.INSTANCE.register("doggytalents", ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_CLIENT_SPEC);
        ConfigHandler.initRespawnTagsConfig();
        ConfigHandler.initCustomSkinsConfig();
        ConfigHandler.initCustomSkinsConfigClient();
        NeoForgeModConfigEvents.loading((String)"doggytalents").register(ConfigHandler::onConfigLoad);
    }

    public static void initTalentConfig() {
        Pair talentPair = new ForgeConfigSpec.Builder().configure(TalentConfig::new);
        CONFIG_TALENT_SPEC = (ForgeConfigSpec)talentPair.getRight();
        TALENT = (TalentConfig)talentPair.getLeft();
        ForgeConfigRegistry.INSTANCE.register("doggytalents", ModConfig.Type.SERVER, (IConfigSpec)CONFIG_TALENT_SPEC, "doggytalents-talents.toml");
    }

    public static void initRespawnTagsConfig() {
        Pair respawnPair = new ForgeConfigSpec.Builder().configure(RespawnTagConfig::new);
        CONFIG_RESPAWN_TAG_SPEC = (ForgeConfigSpec)respawnPair.getRight();
        RESPAWN_TAGS = (RespawnTagConfig)respawnPair.getLeft();
        ForgeConfigRegistry.INSTANCE.register("doggytalents", ModConfig.Type.SERVER, (IConfigSpec)CONFIG_RESPAWN_TAG_SPEC, "doggytalents-respawn_tags_to_remove.toml");
    }

    public static void initCustomSkinsConfig() {
        Pair customSkinPair = new ForgeConfigSpec.Builder().configure(DogCustomSkinConfig::new);
        CONFIG_CUSTOM_SKINS_SPEC = (ForgeConfigSpec)customSkinPair.getRight();
        CUSTOM_SKINS = (DogCustomSkinConfig)customSkinPair.getLeft();
        ForgeConfigRegistry.INSTANCE.register("doggytalents", ModConfig.Type.SERVER, (IConfigSpec)CONFIG_CUSTOM_SKINS_SPEC, "doggytalents-dog_custom_skins.toml");
    }

    public static void initCustomSkinsConfigClient() {
        Pair customSkinPair = new ForgeConfigSpec.Builder().configure(DogCustomSkinClientConfig::new);
        CONFIG_CUSTOM_SKINS_CLIENT_SPEC = (ForgeConfigSpec)customSkinPair.getRight();
        CUSTOM_SKINS_CLIENT = (DogCustomSkinClientConfig)customSkinPair.getLeft();
        ForgeConfigRegistry.INSTANCE.register("doggytalents", ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_CUSTOM_SKINS_CLIENT_SPEC, "doggytalents-dog_custom_skins_client.toml");
    }

    public static void onConfigLoad(ModConfig config) {
        ModConfig loaded_config = config;
        if (loaded_config.getSpec() == CONFIG_CUSTOM_SKINS_SPEC) {
            if (CUSTOM_SKINS != null) {
                CUSTOM_SKINS.reloadSets();
            }
        } else if (loaded_config.getSpec() == CONFIG_CUSTOM_SKINS_CLIENT_SPEC && CUSTOM_SKINS_CLIENT != null) {
            CUSTOM_SKINS_CLIENT.reloadSets();
        }
    }

    public static class ServerConfig {
        public ForgeConfigSpec.BooleanValue DISABLE_HUNGER;
        public ForgeConfigSpec.BooleanValue STARTING_ITEMS;
        public ForgeConfigSpec.BooleanValue DISABLE_GENDER;
        public ForgeConfigSpec.BooleanValue PUPS_GET_PARENT_LEVELS;
        public ForgeConfigSpec.BooleanValue IMMORTAL_DOGS;
        public ForgeConfigSpec.BooleanValue PLAY_TAG_WITH_DOG;
        public ForgeConfigSpec.BooleanValue DOG_GREET_OWNER;
        public ForgeConfigSpec.IntValue DOG_GREET_OWNER_LIMIT;
        public ForgeConfigSpec.BooleanValue MAX_CREEPER_SWEEPER_DONT_GROWL;
        public ForgeConfigSpec.BooleanValue ALL_PLAYER_CANNOT_ATTACK_DOG;
        public ForgeConfigSpec.BooleanValue ALL_DOG_BLOCK_PORTAL;
        public ForgeConfigSpec.IntValue MAX_HEEL_LIMIT;
        public ForgeConfigSpec.DoubleValue HUNGER_MODIFIER;
        public ForgeConfigSpec.BooleanValue DISABLE_PRESERVE_UUID;
        public ForgeConfigSpec.IntValue DUPLICATION_RESOLVE_STRATEGY;
        public ForgeConfigSpec.BooleanValue TRUST_THIRD_PARTY_STORAGE;
        public ForgeConfigSpec.BooleanValue DISABLE_TRAIN_UNTAMED_WOLF;
        public ForgeConfigSpec.BooleanValue DOG_RESPAWN_INCAPACITATED_WHEN_KILLED;
        public ForgeConfigSpec.BooleanValue MOB_RETRIEVER_ONLY_CARRY_DOG;
        public ForgeConfigSpec.BooleanValue WOLF_MOUNT_PASSENGER_COLLISION;
        public ForgeConfigSpec.BooleanValue CONDUCTING_BONE_CROSS_ORIGIN;
        public ForgeConfigSpec.BooleanValue INCAP_VAL_RESET_WHEN_HURT;
        public ForgeConfigSpec.IntValue TRAIN_WOLF_LIMIT;
        public ForgeConfigSpec.BooleanValue RANDOM_VAR_WITH_CHARM;
        public ForgeConfigSpec.BooleanValue DOGGY_TOOLS_USE_TRIDENT;
        public ForgeConfigSpec.BooleanValue DOGGY_TOOLS_PROJECTILE_PASS_ALLIES;
        public ForgeConfigSpec.BooleanValue DOGGY_TOOLS_BRIDGING;
        public ForgeConfigSpec.IntValue DOGGY_TOOLS_BRIDGING_LIMIT;
        public ForgeConfigSpec.BooleanValue DOG_PETTING;
        public ForgeConfigSpec.BooleanValue DOG_PETITNG_JEALOUS;
        public ForgeConfigSpec.BooleanValue ALLOW_TRACK_ANY_DOG;
        public ForgeConfigSpec.BooleanValue LOG_WHEN_DOG_GO_OFFLINE;
        public ForgeConfigSpec.BooleanValue BG_MODE_LESS_STRICT;
        public ForgeConfigSpec.BooleanValue DOG_DONT_PUSH_OWNER;
        public ForgeConfigSpec.BooleanValue INJURED_DOG_BLOCK_PORTAL;
        public ForgeConfigSpec.BooleanValue WANDERING_DOG_WHISTLE;
        public ForgeConfigSpec.BooleanValue DISABLE_KILL_STATS;
        public ForgeConfigSpec.BooleanValue DISABLE_WOLF_ARMOR_FUNCTION;
        public ForgeConfigSpec.BooleanValue PREVENT_WILD_WOLVES_ANGRY;
        public ForgeConfigSpec.IntValue TACTICAL_LIMIT;
        public ForgeConfigSpec.BooleanValue CARRY_ME_WHISTLE;
        public ForgeConfigSpec.BooleanValue DOG_MAX_BUILD_Y_CAP;
        public ForgeConfigSpec.BooleanValue RANDOM_VAR_ON_PALE;
        public ForgeConfigSpec.BooleanValue SWIMMER_DOG_RIDER_WATER_VISION;
        public ForgeConfigSpec.BooleanValue DOG_CAN_EAT_ALL_FOOD;
        public Map<String, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Constants");
            this.DISABLE_HUNGER = builder.comment("By default, Dogs can starve to Incapacitated if are not fed properly.").comment("Disable this to prevent this behaviour. Do note that you can still feed").comment("your Dog to recover health.").translation("doggytalents.config.dog.disable_hunger").define("disable_hunger", false);
            this.STARTING_ITEMS = builder.comment("When enabled, DTN will provide new players of this world").comment("(relative to the point that this option is first enabled on this world)").comment("a Starter Bundle which contains certain key items which assist you in starting").comment("with DTN.").translation("doggytalents.config.enable_starter_bundle").define("enable_starter_bundle", false);
            this.DISABLE_GENDER = builder.comment("By default, each Dog will be one of the Biological Genders. This, like how Biological Genders").comment("work, add restrictions how Dogs can breed. Therefore, only Dogs whose gender is Biologically Opposed").comment("can mate with each other. Set this to true to disable this behaviour.").translation("doggytalents.config.disable_dog_gender").define("disable_dog_gender", false);
            this.PUPS_GET_PARENT_LEVELS = builder.comment("When enabled, puppies get some levels from their parents. When disabled, puppies start at 0 points.").translation("doggytalents.config.enable_pup_get_parent_levels").define("enable_pup_get_parent_levels", false);
            this.IMMORTAL_DOGS = builder.comment("When enabled, dogs cannot be killed by any means (except creative-mode-bypass damage, in that case, you can still respawn your dog using his linked bed or commands).").comment("Instead, when his health reaches Zero, he will go into Incapacitated Mode.").translation("doggytalents.config.immortal_dogs").define("immortal_dogs", true);
            this.PLAY_TAG_WITH_DOG = builder.comment("When enabled, dog can play tag with you. To make them play, throw a snowball at them.").translation("doggytalents.config.play_tag_with_dog").define("play_tag_with_dog", true);
            this.DOG_GREET_OWNER = builder.comment("When enabled, dogs will start to miss you when you leave them for too long.").comment("And when you come back, they will rush to you and greet you with love!").translation("doggytalents.dog_greet_owner").define("dog_greet_owner", true);
            this.DOG_GREET_OWNER_LIMIT = builder.comment("Specify how many dogs can greet you when you approach more than one missing dog.").comment("The remaning dogs will remain in their position.").comment("To disable the limit, set this to any non-positive integer.").comment("Although this will cause all of your dogs to stand up and greet.").comment("YOU HAVE BEEN WARNED! :)").translation("doggytalents.dog_greet_owner_limit").defineInRange("dog_greet_owner_limit", 5, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.MAX_CREEPER_SWEEPER_DONT_GROWL = builder.comment("Option to disable dogs who mastered Creeper Sweeper and ").comment("and are able to tackle Creepers. This is helpful if players intend").comment("their Creeper Sweeper master dogs to focus on fighting Creeper instead of").comment("warning you, which may causes a bunch of false positives due to the range").comment("being so wide that it includes Creepers which are not in danger zone or not reachable.").translation("doggytalents.max_creeper_sweeper_dont_growl").define("max_creeper_sweeper_dont_growl", true);
            this.ALL_PLAYER_CANNOT_ATTACK_DOG = builder.comment("Option to disable friendly fire for all players toward all dogs.").comment("This is used to always be the case with friendly fire disabled for a single dog.").translation("doggytalents.all_player_cannot_attack_dog").define("all_player_cannot_attack_dog", false);
            this.ALL_DOG_BLOCK_PORTAL = builder.comment("Option to prevent dogs from accidentally going into a portal and get").comment("unnecessary transferred to another dimension, causing the owner to have").comment("to take them back. The preferred way to make a dog go to another dimension is").comment("to have Cross Origin Teleport set to true on that dog.").translation("doggytalents.all_dog_block_portal").define("all_dog_block_portal", true);
            this.MAX_HEEL_LIMIT = builder.comment("Define how many dogs a player can listen to commands which summon more than one dog to you").comment("at the same time. Set this to any negative value to remove the limit completely.").translation("doggytalents.max_heel_limit").defineInRange("max_heel_limit", 20, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.HUNGER_MODIFIER = builder.comment("Adjust this value to increase or decrease the Dog's hunger speed to your liking.").comment("ex: Set this to 0.5 to halve the Dog Hunger decrease speed.").translation("doggytalents.hunger_modifier").defineInRange("hunger_modifier", 1.0, 0.0, 2.0);
            this.DISABLE_PRESERVE_UUID = builder.comment("Determine if the UUIDs of the dogs are being kept when training from vanilla").comment("and when they respawn on bed. This also allows Duplication Detection.").translation("doggytalents.preserve_uuid").define("disable_preserve_uuid", false);
            this.DUPLICATION_RESOLVE_STRATEGY = builder.comment("Duplication Detection").comment("Specify what to do when a Duplication is detected when third parties are trying").comment("to load the dog from their own copy.").comment("Option are specified via the following Integer values").comment("0 - Throw an exception out, this may produce a crash. However, this is the recommended way.").comment("1 - Silently remove the dog.").comment("Other - Do nothing.").translation("doggytalents.duplication_resolve_strategy").defineInRange("duplication_resolve_strategy", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.TRUST_THIRD_PARTY_STORAGE = builder.comment("Allow third party storage to store Dog and and load them back. This allow").comment("Mods which, for example, having an item that can store an entity, to work").comment("with DTN Dogs. This option requires a world restart to take effect.").comment("Disclaimer: While the Dog is in third-party storage, we do not").comment("guarantee any data integrity as it is entirely up to the other Mod to").comment("maintain the Dog Data. If the other Mod failed to keep the data,").comment("the Dog cannot be respawned and will be gone forever. You have been warned.").translation("doggytalents.trust_third_party_storage").worldRestart().define("trust_third_party_storage", false);
            this.DISABLE_TRAIN_UNTAMED_WOLF = builder.comment("By default, you can directly train an untamed wolf to a Dog").comment("with a Training Treat. Set this to True to disable.").translation("doggytalents.train_untamed_wolf").define("disable_train_untamed_wolf", false);
            this.DOG_RESPAWN_INCAPACITATED_WHEN_KILLED = builder.comment("By default, Dogs respawning from bed after being killed will").comment("be incapacitated and are required to be nursed back to life.").comment("Set this to False to disable.").translation("doggytalents.dog_respawn_incapacitated_when_killed").define("dog_respawn_incapacitated_when_killed", true);
            this.MOB_RETRIEVER_ONLY_CARRY_DOG = builder.comment("Enable this if you prefer Mob Retriever to only work with DTN's dog.").translation("doggytalents.mob_retriever_only_carry_dog").define("mob_retriever_only_carry_dog", false);
            this.WOLF_MOUNT_PASSENGER_COLLISION = builder.comment("By default, Dogs extend their bounding box covering the passengers").comment("to avoid suffocating them while calculating the appropriate path.").comment("Set this to false to disable it, but be warned, although Mob Retriever Dogs will still").comment("try to calculate the appropriate path while carrying another mob, there might be accidental suffocations.").translation("doggytalents.wolf_mount_passenger_collision").define("wolf_mount_passenger_collision", true);
            this.CONDUCTING_BONE_CROSS_ORIGIN = builder.comment("By default, Conducting Bone users can summon their Dogs even when they are in").comment("other dimensions. Set this to false to limit Conducting Bone Users to only summon").comment("Dogs of the same dimension.").translation("doggytalents.conducting_bone_cross_origin").define("conducting_bone_cross_origin", true);
            this.INCAP_VAL_RESET_WHEN_HURT = builder.comment("Determine if Dog's incapacitated value should be reset when taking any damage").comment("while being Incapacitated.").translation("doggytalents.incap_val_reset_when_hurt").define("incap_val_reset_when_hurt", true);
            this.TRAIN_WOLF_LIMIT = builder.comment("Set the maximum amount of wolves each players can train to DTN's Dogs.").comment("If a player meet or exceed this cap, he will not be able to train more wolves into DTN's Dogs.").comment("Set this to a value greater than Zero to activate this cap, other value").comment("will disable the cap, meaning players can get unlimited dogs.").translation("doggytalents.train_wolf_limit").defineInRange("train_wolf_limit", -1, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.RANDOM_VAR_WITH_CHARM = builder.comment("Determine if Dogs summoned from Doggy Charms will have").comment("random Classical Variants instead of always being summoned as Pale.").translation("doggytalents.random_var_with_charm").define("random_var_with_charm", true);
            this.DOGGY_TOOLS_USE_TRIDENT = builder.comment("Allow Doggy Tools Dogs to use Trident").translation("doggytalents.doggy_tools_trident").define("doggy_tools_trident", true);
            this.DOGGY_TOOLS_PROJECTILE_PASS_ALLIES = builder.comment("Allow Doggy Tools Dogs's projectiles to pass through allies instead of just").comment("despawning if hit. Notice that this option does not affect Crossbow").comment("projectile and will cause Dog to interpret any third-party").comment("arrows as vanilla's arrow. Disable this, if you prefer Dogs to utilize third-party").comment("Arrows as it is. Regardless, the arrows fired from Dog will do no harm to allies.").translation("doggytalents.doggy_tools_projectile_pass_allies").define("doggy_tools_projectile_pass_allies", true);
            this.DOGGY_TOOLS_BRIDGING = builder.comment("Allow Dogs who have Doggy Tools maxed out to help their owners bridging.").translation("doggytalents.doggy_tools_bridging").define("doggy_tools_bridging", true);
            this.DOGGY_TOOLS_BRIDGING_LIMIT = builder.comment("Specify how many Maxed out Doggy Tools dogs can help a player bridge at once.").translation("doggytalents.doggy_tools_bridging_limit").defineInRange("doggy_tools_bridging_limit", 1, 0, 16);
            this.DOG_PETTING = builder.comment("Allow Players to Pet their Dogs.").translation("doggytalents.dog_petting").define("dog_petting", true);
            this.DOG_PETITNG_JEALOUS = builder.comment("By default, one of the nearby Dogs will get jealous if you").comment("pet a Dog for too long.").translation("doggytalents.dog_petting_jealous").define("dog_petting_jealous", true);
            this.ALLOW_TRACK_ANY_DOG = builder.comment("Allow Players to track Dogs using the Canine Tracker despite").comment("not having neither Radio Collars nor Locator Orbs equipped.").translation("doggytalents.allow_track_any_dog").define("allow_track_any_dog", false);
            this.LOG_WHEN_DOG_GO_OFFLINE = builder.comment("When this option is enabled, Debug Information is Logged when").comment("a dog goes Offline, for example, being Unloaded To Chunk.").translation("doggytalents.log_when_dog_go_offline").define("log_when_dog_go_offline", true);
            this.BG_MODE_LESS_STRICT = builder.comment("Enable this to allow Besserker&Guard Dogs to consider any entity that is").comment("targetting the player a potential danger instead of just 'Enemy'(s)").translation("doggytalents.besserker_less_strict").define("b_g_mode_less_strict", false);
            this.DOG_DONT_PUSH_OWNER = builder.comment("Enable this to prevent Dogs from pushing their Owners").translation("doggytalents.dog_dont_push_owner").define("dog_dont_push_owner", false);
            this.INJURED_DOG_BLOCK_PORTAL = builder.comment("By default, Injured Dogs won't block portal, allowing them to").comment("be brought back from another dimension. Enable this").comment("to make Injured Dogs still block portals.").translation("doggytalents.injured_dog_block_portal").define("injured_dog_block_portal", false);
            this.WANDERING_DOG_WHISTLE = builder.comment("By default, Wandering Dogs will not respond to the stay/stand whistle.").comment("Enable this to make them respond as usual.").translation("doggytalents.wandering_dog_whistle").define("wandering_dog_whistle", false);
            this.DISABLE_KILL_STATS = builder.comment("Prevent all Dogs' kills from being recorded into its Kill Stats.").translation("doggytalents.disable_kill_stats").define("disable_kill_stats", false);
            this.DISABLE_WOLF_ARMOR_FUNCTION = builder.comment("Disable all Wolf Armor Protection for DTN Dogs. They can still be").comment("used for Style.").translation("doggytalents.disable_wolf_armor_protection").define("disable_wolf_armor_protection", false);
            this.PREVENT_WILD_WOLVES_ANGRY = builder.comment("Prevent Wild Wolves from being angry when you accidentally hit them.").translation("doggytalents.prevent_wild_wolves_angry").define("prevent_wild_wolves_angry", false);
            this.TACTICAL_LIMIT = builder.comment("Set the maxmium number of Tactical Dogs that will reponse").comment("when a their owner issues a Tactical Command via the Tactical Whistle.").comment("Set this to a value greater than Zero to activate this cap, other value").comment("will disable the cap.").translation("doggytalents.tactical_limit").defineInRange("tactical_limit", 8, -1, 32);
            this.CARRY_ME_WHISTLE = builder.comment("Set to false to disable the Carry Me Whistle.").translation("doggytalents.carry_me_whistle").define("carry_me_whistle", true);
            this.DOG_MAX_BUILD_Y_CAP = builder.comment("Prevent Dog from going over the MaxBuildHeight of the world.").translation("doggytalents.dog_max_build_y_cap").define("dog_max_build_y_cap", true);
            this.RANDOM_VAR_ON_PALE = builder.comment("Upon training a Vanilla Pale Wolf, if this option is enabled, a random").comment("Vanilla Dog Variant will be assigned to the newly trained DTN Dog instead of").comment("the Pale one only.").translation("doggytalents.random_var_on_pale").define("random_var_on_pale", false);
            this.SWIMMER_DOG_RIDER_WATER_VISION = builder.comment("By default, players who are riding their Dog with Swimmer Dog Maxed out will be").comment("able to see well underwater. Set this to false to disable this behaviour.").translation("doggytalents.dog_riding_water_vision").define("dog_riding_water_vision", true);
            this.DOG_CAN_EAT_ALL_FOOD = builder.comment("Enable this to allow DTN Dogs to eat all food with the obvious").comment("exception of Rotten Flesh. Note that this might result in DTN Dogs").comment("being able to eat food that must not be fed to a real life Dog").comment("e.g. Cookie. Use with caution.").translation("doggytalents.dog_can_eat_all_food").define("dog_can_eat_all_food", false);
            builder.pop();
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_SERVER_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }

        public static <T> T getConfigOrDefault(ForgeConfigSpec.ConfigValue<T> config, T default_val) {
            if (CONFIG_SERVER_SPEC == null || config == null) {
                return default_val;
            }
            if (CONFIG_SERVER_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return default_val;
        }
    }

    public static class ClientConfig {
        public ForgeConfigSpec.BooleanValue KAMI_PARTICLES;
        public ForgeConfigSpec.BooleanValue RENDER_CHEST;
        public ForgeConfigSpec.BooleanValue ALWAYS_RENDER_CLASSICAL;
        public ForgeConfigSpec.BooleanValue RENDER_INCAPACITATED_TEXTURE;
        public ForgeConfigSpec.BooleanValue RENDER_HEALTH_IN_NAME;
        public ForgeConfigSpec.ConfigValue<String> DOG_INFO_SEPERATOR;
        public ForgeConfigSpec.ConfigValue<String> DOG_INFO_HUNGER_FORMAT;
        public ForgeConfigSpec.BooleanValue DOG_INV_BUTTON_IN_INV;
        public ForgeConfigSpec.IntValue DOG_INV_IN_INV_BUTTON_X;
        public ForgeConfigSpec.IntValue DOG_INV_IN_INV_BUTTON_Y;
        public ForgeConfigSpec.BooleanValue RENDER_INCAP_TXT_LESS_GRAPHIC;
        public ForgeConfigSpec.BooleanValue RENDER_DIFFOWNER_NAME_DIFFERENT;
        public ForgeConfigSpec.BooleanValue DONT_RENDER_DIFFOWNER_NAME;
        public ForgeConfigSpec.BooleanValue ALWAYS_RENDER_DOG_NAME;
        public ForgeConfigSpec.BooleanValue BLOCK_THIRD_PARTY_NAMETAG;
        public ForgeConfigSpec.BooleanValue USE_VANILLA_RES_FOR_CLASSICAL;
        public ForgeConfigSpec.BooleanValue WORD_LOAD_ICON;
        public ForgeConfigSpec.BooleanValue AMMY_SPINNA;
        public ForgeConfigSpec.BooleanValue RENDER_ARMOR;
        public ForgeConfigSpec.BooleanValue BLOCK_RED_OVERLAY_WHEN_HURT;
        public ForgeConfigSpec.BooleanValue DISPLAY_SMOKE_WHEN_ON_FIRE;
        public ForgeConfigSpec.BooleanValue MOUTH_ITEM_FORCE_RENDER;
        public ForgeConfigSpec.IntValue MAX_ANIMATION_LATENCY_ALLOWED;
        public ForgeConfigSpec.BooleanValue USE_LEGACY_DOG_ARMOR_RENDER;
        public ForgeConfigSpec.BooleanValue USE_PLAYER_HELMET_MODEL_BY_DEFAULT;
        public ForgeConfigSpec.BooleanValue USE_THIRD_PARTY_PLAYER_HELMET_MODEL;
        public ForgeConfigSpec.BooleanValue ENABLE_STARTER_BUNDLE_BY_DEFAULT;
        public ForgeConfigSpec.BooleanValue DOG_VARIANT_CLIENT_EFFECT;
        public ForgeConfigSpec.BooleanValue RENDER_RADIO_COLLAR;
        public ForgeConfigSpec.BooleanValue TRANSLUCENT_ALL_OVERLAY;
        public ForgeConfigSpec.BooleanValue HIDE_WOLF_MOUNT_STATUS;
        public ForgeConfigSpec.BooleanValue HIDE_WOLF_MOUNT_STATUS_CREATIVE;
        public ForgeConfigSpec.BooleanValue DTN_WOLF_MOUNT_OVERLAY;
        public ForgeConfigSpec.BooleanValue SHOW_DOG_NAME_THRU_WALL;
        public ForgeConfigSpec.IntValue MAX_DOG_BED_MODEL_CACHE;
        public ForgeConfigSpec.BooleanValue DOGBED_FORCE_DEFAULT_MODEL;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Render");
            this.KAMI_PARTICLES = builder.comment("Enables the particle effect on Full Kami dogs.").translation("doggytalents.config.client.enable_kami_particles").define("enable_kami_particles", false);
            this.RENDER_CHEST = builder.comment("Disable this if you want to force all PackPuppy Dog to not render their Chest.").translation("doggytalents.config.client.render_chest").define("render_chest", true);
            this.ALWAYS_RENDER_CLASSICAL = builder.comment("Enable this if you prefer to have The Classical Skin rendered on all dog regardless.").translation("doggytalents.config.client.always_render_classical").define("always_render_classical", false);
            this.RENDER_INCAPACITATED_TEXTURE = builder.comment("When enabled, Dogs will show injured texture while incapacitated.").translation("doggytalents.config.client.render_incapacitated_overlay").define("render_incapacitated_overlay", true);
            this.RENDER_HEALTH_IN_NAME = builder.comment("When sneaking, a part of the dog's name will be rendered with a certain color").comment(", the length of the part is based on the health percentage the dog has left").translation("doggytalents.config.client.render_health_in_name").define("render_health_in_name", true);
            this.DOG_INFO_SEPERATOR = builder.comment("Configure what will be displayed in the middle of").comment("each of the info section (e.g Hunger, Gender, Mode) when rendering ").comment("the Dog Status String located above the main Dog Name String.").translation("doggytalents.config.client.dog_info_seperator").define("dog_info_seperator", (Object)" \u00b7 ");
            this.DOG_INFO_HUNGER_FORMAT = builder.comment("Configure the format that will be used to display hunger value").comment("when rendering the Dog Status String located above the main").comment("Dog Name String.").translation("doggytalents.config.client.dog_info_hunger_format").define("dog_info_hunger_format", (Object)"%d");
            this.DOG_INV_BUTTON_IN_INV = builder.comment("Render a universal dog inventory access button in your inventory gui.").comment("If this is turned off, you can still access the button via the dog's").comment("GUI in Talents > Pack Puppy.").translation("doggytalents.config.client.dog_inv_button_in_inv").define("dog_inv_button_in_inv", true);
            builder.comment("Set a custom position for the universal dog inventory access button here.").comment("Can be utilizedwhen the button overlaps with another mod's GUI feature or you ").comment("simply prefer it being in a different position.").comment("This option only affects the Survival inventory screen.").comment("The position is the offset of the button is the offset from the top left corner").comment("of the box wrapping the whole inventory gui.");
            this.DOG_INV_IN_INV_BUTTON_X = builder.translation("doggytalents.config.client.dog_inv_button_in_inv_x").defineInRange("dog_inv_button_in_inv_x", 78, -500, 500);
            this.DOG_INV_IN_INV_BUTTON_Y = builder.translation("doggytalents.config.client.dog_inv_button_in_inv_y").defineInRange("dog_inv_button_in_inv_y", 48, -500, 500);
            this.RENDER_INCAP_TXT_LESS_GRAPHIC = builder.comment("If the default incapacitated texture proof too many graphics.").comment("You can substitute this friendlier texture instead.").translation("doggytalents.config.client.render_incap_txt_less_graphic").define("render_incap_txt_less_graphic", false);
            this.RENDER_DIFFOWNER_NAME_DIFFERENT = builder.comment("Render the dogs' name whose owner is not you with a different color.").translation("doggytalents.config.client.render_diffowner_name_different").define("render_diffowner_name_different", true);
            this.DONT_RENDER_DIFFOWNER_NAME = builder.comment("Do not render dogs' names whose owner is not you.").translation("doggytalents.config.client.render_diffowner_name_dont").define("render_diffowner_name_dont", false);
            this.ALWAYS_RENDER_DOG_NAME = builder.comment("Always render dog nametags regardless even if the player blocks it by F1 mode.").translation("doggytalents.config.client.always_render_dog_name").define("always_render_dog_name", false);
            this.BLOCK_THIRD_PARTY_NAMETAG = builder.comment("Attempt to block third parties from rendering overlays that may conflict").comment("with DT's built-in tag. It is recommended that this be achieved via the target third-party's").comment("configurations if they have the option to disable nametag overlay for certain mobs").comment("(Which they should). This option should only be used as the last resort.").translation("doggytalents.config.client.block_third_party_nametag").define("block_third_party_nametag", false);
            this.USE_VANILLA_RES_FOR_CLASSICAL = builder.comment("By default, a copy of the Classical (Vanilla Wolf Texture) provided by the mod").comment("is used to render The Classical Skin, this is to avoid conflicts with resource packs").comment("like Fresh Animations which are directly using the in-game wolf texture. Turning this on").comment("will make DTN directly reference the in-game texture.").translation("doggytalents.config.client.use_vanilla_res_for_classical").define("use_vanilla_res_for_classical", false);
            this.WORD_LOAD_ICON = builder.comment("Show a fun icon on world loading screen.").translation("doggytalents.config.client.world_load_icon").define("world_load_icon", true);
            this.AMMY_SPINNA = builder.comment("DTN's fun little world loading icon will occasionally").comment("show Ammy instead of Classical Pale. Disable this").comment("to force the icon to always show Classical Pale.").translation("doggytalents.config.client.ammy_spinna").define("ammy_spinna", true);
            this.RENDER_ARMOR = builder.comment("Determine if dogs will render their armor.").translation("doggytalents.config.client.render_armor").define("render_armor", true);
            this.BLOCK_RED_OVERLAY_WHEN_HURT = builder.comment("Determine if dogs still render with a red overlay upon hurt like they usually do.").comment("This can be toggled on if the user prefers to not have the red overlay and relies on the animation ").comment("to indicate hurting.").translation("doggytalents.config.client.block_red_overlay_when_hurt").define("block_red_overlay_when_hurt", false);
            this.DISPLAY_SMOKE_WHEN_ON_FIRE = builder.comment("Display extra smoke when the dog is on fire.").translation("doggytalents.config.client.display_smoke_when_on_fire").define("display_smoke_when_on_fire", true);
            this.MOUTH_ITEM_FORCE_RENDER = builder.comment("By default, dogs will render items in their mouth, regardless of models.").comment("This can be disabled if you prefer not to render it on some").comment("less compatible model.").translation("doggytalents.config.client.mouth_item_force_render").define("mouth_item_force_render", true);
            this.MAX_ANIMATION_LATENCY_ALLOWED = builder.comment("Specify the max latency allowed before force adjusting the animation time").comment("client side to sync with server's animation time. The unit is in ticks.").comment("Provide a non positive integer to disable this. Value from 0 to 7 both inclusive will be defaulted to 7.").translation("doggytalents.config.client.max_animation_latency_allowed").defineInRange("max_animation_latency_allowed", 10, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.USE_LEGACY_DOG_ARMOR_RENDER = builder.comment("Currently, DTN is utilizing a new system for rendering Doggy Armor's Armor").comment("which allows DTN to directly use any texture which the armor item provided").comment("for the player, thus better replicating third-party armor. Set this to true").comment("if you prefer to use the old system instead.").translation("doggytalents.config.client.use_legacy_dog_armor_render").define("use_legacy_dog_armor_render", false);
            this.USE_THIRD_PARTY_PLAYER_HELMET_MODEL = builder.comment("By default, DTN will try querying models from third parties designed for the player when").comment("rendering helmet on the Dog. Disable this to force DTN to use either vanilla's player model or").comment("DTN provided model designed for Dogs (specified by the below option).").translation("doggytalents.config.client.use_third_party_player_helmet_model").define("use_third_party_player_helmet_model", false);
            this.USE_PLAYER_HELMET_MODEL_BY_DEFAULT = builder.comment("By default, if there is no custom Helmet Armor model for the Helmet Item,").comment("DTN will use its own helmet armor model designed for DTN Dog to").comment("render it on the Dog's head. Enable this to make DTN reuse the player's Helmet Model instead.").translation("doggytalents.config.client.use_player_helmet_model_by_default").define("use_player_helmet_model_by_default", false);
            this.ENABLE_STARTER_BUNDLE_BY_DEFAULT = builder.comment("Enable this to allow every World which is running on this Minecraft").comment("instance's Integrated Server to provide new players with a Starter Bundle").comment("regardless of the world's serverconfig.").translation("doggytalents.config.client.enable_starter_bundle_by_default").define("enable_starter_bundle_by_default", false);
            this.DOG_VARIANT_CLIENT_EFFECT = builder.comment("Some special Dog Variants may display some special effects").comment("clientside. Set this to false to disable this behaviour.").translation("doggytalents.config.client.dog_variant_client_effect").define("dog_variant_client_effect", true);
            this.RENDER_RADIO_COLLAR = builder.comment("Disable this to prevent Radio Collars from being rendered in case if").comment("the server requires those or Locator Orb to be present to be tracked").comment("using the Canine Tracker and you prefer to make the tracker invisible.").define("render_radio_collar", true);
            this.TRANSLUCENT_ALL_OVERLAY = builder.comment("Always render Overlay Accessories on Dogs as Translucent ").comment("This is to prevent Special Variant's overlay to override on the Overlay Accessories").define("translucent_all_overlay", true);
            this.HIDE_WOLF_MOUNT_STATUS = builder.comment("Enable this to hide Wolf Mount Dog's Status Overlay when riding it.").define("hide_wolf_mount_status", false);
            this.HIDE_WOLF_MOUNT_STATUS_CREATIVE = builder.comment("Enable this to hide Wolf Mount Dog's Status Overlay when riding it in Creative.").define("hide_wolf_mount_status_creative", true);
            this.DTN_WOLF_MOUNT_OVERLAY = builder.comment("Use DTN's Dedicated Wolf Mount Overlay when riding the Dog to show its").comment("status. This will takes up two health lines and will render where").comment("the Vanilla Vehicle Health is and instead of it.").define("dtn_wolf_mount_overlay", true);
            this.MAX_DOG_BED_MODEL_CACHE = builder.comment("Configure the maximum value of Dog Bed variants that will be rendered.").comment("If the amount of Dog Bed variants rendered exceeds this limit,").comment("other variants will be rendered as the default variant.").comment("To reset the cache, do a resource reload (F3+T).").comment("Set this option to any value less than zero to remove the limit.").defineInRange("max_dog_bed_model_cache", 65536, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.SHOW_DOG_NAME_THRU_WALL = builder.comment("By default, DTN will render your Dogs' Names through walls. Disable").comment("this to make Owned Dogs' Names no longer visible through walls.").define("show_dog_name_thru_wall", true);
            this.DOGBED_FORCE_DEFAULT_MODEL = builder.comment("Currently, DTN Dog Bed renders with missing texture when Sodium/Iris").comment("is installed. That is due to Iris/Sodium causing some problems with Fabric").comment("Indigo rendering API which DTN utilize to render any supported material on").comment("the Dog Bed, which is out of our control. This option force DTN").comment("to not use its Custom Model and revert back to using vanilla's baked model.").comment("This prevent the Missing Texture with Iris/Sodium but also means that").comment("the Dog Bed can only render one casing and one bedding material.").translation("doggytalents.config.client.dogbed_force_default_model").define("dogbed_force_default_model", false);
            builder.pop();
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_CLIENT_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }
    }

    public static class TalentConfig {
        public Map<Talent, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public TalentConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Here you can disable talents.").comment("Notice that players with admin privileges can bypass this.").push("Talents");
            this.DISABLED_TALENTS = new HashMap<Talent, ForgeConfigSpec.BooleanValue>();
            DoggyTalentsAPI.TALENTS.get().forEach(loc -> this.DISABLED_TALENTS.put((Talent)loc, builder.define(DoggyTalentsAPI.TALENTS.get().method_10221(loc).toString(), true)));
            builder.pop();
        }

        public boolean getFlag(Talent talent) {
            ForgeConfigSpec.BooleanValue booleanValue = this.DISABLED_TALENTS.get(talent);
            if (booleanValue == null) {
                return true;
            }
            return (Boolean)TalentConfig.getConfig(booleanValue);
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_TALENT_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }
    }

    public static class RespawnTagConfig {
        public ForgeConfigSpec.IntValue STRATEGY;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> TAGS_TO_REMOVE;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> TAGS_TO_KEEP;

        public RespawnTagConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Specify the Strategy to be used when picking which data to keep and remove");
            builder.comment("when a Dog got unloaded into DTN Respawn Storage");
            builder.comment("0: Removes all tags, keeping only the Dog's Owner, the Dog's Age, DTN's saved data");
            builder.comment("and additional tags provided by tags_to_keep below.");
            builder.comment("1: Keep all tags, and remove certain tags specified in respawn_removal_tags except");
            builder.comment("important DTN tags.");
            builder.comment("Other: Defaulted to 0");
            this.STRATEGY = builder.defineInRange("restore_strategy", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.TAGS_TO_REMOVE = builder.translation("doggytalents.respawn_removal_tags").defineList("respawn_removal_tags", List.of(), obj -> obj instanceof String);
            this.TAGS_TO_KEEP = builder.translation("doggytalents.tags_to_keep").defineList("tags_to_keep", List.of(), obj -> obj instanceof String);
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_RESPAWN_TAG_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }
    }

    public static class DogCustomSkinConfig {
        public ForgeConfigSpec.IntValue STRATEGY;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> WHITELISTED_SHA1;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_SHA1;
        private Set<String> whitelistedSet = Set.of();
        private Set<String> blacklistedSet = Set.of();

        public DogCustomSkinConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Specify the Strategy to be used when picking which Dog Custom Skin");
            builder.comment("could be set for a Dog. The texture's Hash Value is required to be");
            builder.comment("the entry for these lists, they can be obtained via the Show Info");
            builder.comment("page of Style > Skins at the Dog GUI.");
            builder.comment("0: Allow all");
            builder.comment("1: Allow all except blacklisted");
            builder.comment("2: Disallow all except whitelisted");
            builder.comment("Other: Defaulted to 0");
            this.STRATEGY = builder.defineInRange("strategy", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.WHITELISTED_SHA1 = builder.translation("doggytalents.whitelisted_sha1").defineList("whitelisted_sha1", List.of(), obj -> obj instanceof String);
            this.BLACKLISTED_SHA1 = builder.translation("doggytalents.blacklisted_sha1").defineList("blacklisted_sha1", List.of(), obj -> obj instanceof String);
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_CUSTOM_SKINS_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }

        public boolean isBlacklisted(String val) {
            return this.blacklistedSet.contains(val);
        }

        public boolean isWhitelisted(String val) {
            return this.whitelistedSet.contains(val);
        }

        public void reloadSets() {
            List<? extends String> blacklist = DogCustomSkinConfig.getConfig(ConfigHandler.CUSTOM_SKINS.BLACKLISTED_SHA1);
            List<? extends String> whitelist = DogCustomSkinConfig.getConfig(ConfigHandler.CUSTOM_SKINS.WHITELISTED_SHA1);
            this.blacklistedSet = new HashSet<String>(blacklist);
            this.whitelistedSet = new HashSet<String>(whitelist);
        }

        public static DogCustomSkinConfig getInstance() {
            return CUSTOM_SKINS;
        }

        public static DataStrategy getStrategy() {
            if (CUSTOM_SKINS == null) {
                return DataStrategy.NONE;
            }
            if (ConfigHandler.CUSTOM_SKINS.STRATEGY == null) {
                return DataStrategy.NONE;
            }
            Integer id = (Integer)DogCustomSkinConfig.getConfig(ConfigHandler.CUSTOM_SKINS.STRATEGY);
            if (id == 1) {
                return DataStrategy.ALLOW_EXCEPT;
            }
            if (id == 2) {
                return DataStrategy.DISALLOW_EXCEPT;
            }
            return DataStrategy.NONE;
        }

        public static enum DataStrategy {
            ALLOW_EXCEPT,
            DISALLOW_EXCEPT,
            NONE;

        }
    }

    public static class DogCustomSkinClientConfig {
        public ForgeConfigSpec.IntValue STRATEGY;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> WHITELISTED_ID;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_ID;
        private Set<String> whitelistedSet = Set.of();
        private Set<String> blacklistedSet = Set.of();

        public DogCustomSkinClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Specify the Strategy to be used when picking which Dog Custom Skin");
            builder.comment("will not be loaded clientside. The entry for these lists is");
            builder.comment("required to be the texture's path in ResourceLocation format");
            builder.comment("(e.g. doggytalents:textures/entity/dog/custom/arcanine_shiro.png).");
            builder.comment("Your client do need to be restarted for any changes to take places.");
            builder.comment("0: Allow all");
            builder.comment("1: Allow all except blacklisted");
            builder.comment("2: Disallow all except whitelisted");
            builder.comment("Other: Defaulted to 0");
            this.STRATEGY = builder.defineInRange("strategy", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.WHITELISTED_ID = builder.translation("doggytalents.whitelisted_id").defineList("whitelisted_id", List.of(), obj -> obj instanceof String);
            this.BLACKLISTED_ID = builder.translation("doggytalents.blacklisted_id").defineList("blacklisted_id", List.of(), obj -> obj instanceof String);
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_CUSTOM_SKINS_CLIENT_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }

        public boolean isBlacklisted(String val) {
            return this.blacklistedSet.contains(val);
        }

        public boolean isWhitelisted(String val) {
            return this.whitelistedSet.contains(val);
        }

        public void reloadSets() {
            List<? extends String> blacklist = DogCustomSkinClientConfig.getConfig(ConfigHandler.CUSTOM_SKINS_CLIENT.BLACKLISTED_ID);
            List<? extends String> whitelist = DogCustomSkinClientConfig.getConfig(ConfigHandler.CUSTOM_SKINS_CLIENT.WHITELISTED_ID);
            this.blacklistedSet = new HashSet<String>(blacklist);
            this.whitelistedSet = new HashSet<String>(whitelist);
        }

        public static DogCustomSkinClientConfig getInstance() {
            return CUSTOM_SKINS_CLIENT;
        }

        public static DataStrategy getStrategy() {
            if (CUSTOM_SKINS_CLIENT == null) {
                return DataStrategy.NONE;
            }
            if (ConfigHandler.CUSTOM_SKINS_CLIENT.STRATEGY == null) {
                return DataStrategy.NONE;
            }
            Integer id = (Integer)DogCustomSkinClientConfig.getConfig(ConfigHandler.CUSTOM_SKINS_CLIENT.STRATEGY);
            if (id == 1) {
                return DataStrategy.ALLOW_EXCEPT;
            }
            if (id == 2) {
                return DataStrategy.DISALLOW_EXCEPT;
            }
            return DataStrategy.NONE;
        }

        public static enum DataStrategy {
            ALLOW_EXCEPT,
            DISALLOW_EXCEPT,
            NONE;

        }
    }
}

