/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import net.minecraft.class_1271;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class DogHungerManager {
    public static final class_2960 HUNGER_MOVEMENT = Util.getResource("dog_hunger_slowndown");
    public static final float MAX_HUNGER_TICK = 800.0f;
    private final Dog dog;
    private float hungerTick = 0.0f;
    private int saturation = 0;
    private int saturationHealingTick = 0;
    private int hungerDamageTick = 0;
    private boolean lowHunger = false;
    private boolean zeroHunger = false;

    public DogHungerManager(Dog dog) {
        this.dog = dog;
    }

    public void tick() {
        this.handleHunger();
        this.mayHealWithSaturation();
    }

    private void handleHunger() {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue()) {
            return;
        }
        if (this.dog.isDogInAnimDebug()) {
            return;
        }
        this.hungerTick += this.getIncreaseHungerTick();
        if (this.hungerTick >= 800.0f) {
            if (this.saturation > 0) {
                --this.saturation;
            } else {
                this.dog.setDogHunger(this.dog.getDogHunger() - 1.0f);
            }
            this.hungerTick = 0.0f;
        }
        if (this.zeroHunger) {
            this.handleZeroHunger();
        }
    }

    private float getIncreaseHungerTick() {
        float inc_tick = 0.0f;
        if (!this.dog.method_5782() && !this.dog.method_6172()) {
            inc_tick = 1.0f;
        }
        if (!this.dog.method_5942().method_6357()) {
            inc_tick = 2.0f;
        }
        for (IDogAlteration alter : this.dog.getAlterations()) {
            class_1271<Float> result = alter.hungerTick(this.dog, inc_tick);
            if (!result.method_5467().method_23666()) continue;
            inc_tick = ((Float)result.method_5466()).floatValue();
        }
        float modifier = ((Double)ConfigHandler.SERVER.HUNGER_MODIFIER.get()).floatValue();
        return inc_tick * modifier;
    }

    private void handleZeroHunger() {
        ++this.hungerDamageTick;
        int hurt_interval = -1;
        boolean hurt_last_health = false;
        switch (this.dog.method_37908().method_8407()) {
            case field_5805: {
                hurt_interval = 125;
                break;
            }
            case field_5802: {
                hurt_interval = 100;
                break;
            }
            case field_5807: {
                hurt_interval = 75;
                hurt_last_health = true;
                break;
            }
            default: {
                hurt_interval = -1;
            }
        }
        if (hurt_interval >= 0 && ++this.hungerDamageTick >= hurt_interval && (hurt_last_health || this.dog.method_6032() > 1.0f)) {
            this.dog.method_5643(this.dog.method_48923().method_48825(), 0.5f);
            this.hungerDamageTick = 0;
        }
    }

    private void mayHealWithSaturation() {
        if (this.saturation <= 0) {
            return;
        }
        if (this.dog.method_6032() >= this.dog.method_6063()) {
            return;
        }
        if (--this.saturationHealingTick <= 0) {
            this.saturationHealingTick = 10;
            this.dog.method_6025(2.0f);
            this.saturation -= 3;
        }
    }

    public int saturation() {
        return this.saturation;
    }

    public boolean isLowHunger() {
        return this.lowHunger;
    }

    public void onHungerUpdated(float new_hunger) {
        boolean lowHunger_updated;
        if (this.dog.method_37908().field_9236) {
            return;
        }
        boolean bl = lowHunger_updated = new_hunger <= 10.0f;
        if (this.lowHunger && !lowHunger_updated) {
            this.hungerLowToHigh();
        }
        if (!this.lowHunger && lowHunger_updated) {
            this.hungerHighToLow();
        }
        this.lowHunger = lowHunger_updated;
        this.zeroHunger = new_hunger <= 0.0f;
    }

    private void hungerHighToLow() {
        if (!this.dog.isDefeated()) {
            this.dog.setAttributeModifier((class_6880<class_1320>)class_5134.field_23719, HUNGER_MOVEMENT, (d, u) -> new class_1322(u, (double)-0.35f, class_1322.class_1323.field_6331));
        }
    }

    private void hungerLowToHigh() {
        this.dog.removeAttributeModifier((class_6880<class_1320>)class_5134.field_23719, HUNGER_MOVEMENT);
    }

    public void onBeingIncapacitated() {
        this.dog.removeAttributeModifier((class_6880<class_1320>)class_5134.field_23719, HUNGER_MOVEMENT);
    }

    public void addHunger(float add) {
        float h0 = this.dog.getDogHunger();
        float h1 = h0 + add;
        int h2 = (int)(h1 - this.dog.getMaxHunger());
        if (h2 > 0) {
            this.saturation = Math.max(this.saturation, h2);
        }
        this.dog.setDogHunger(h0 + add);
    }
}

