/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.feature.DogSize;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.RandomUtil;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.apache.commons.lang3.ObjectUtils;

public class DogPettingManager {
    private final Dog dog;
    private boolean locked = false;
    private long lastPetTimestamp = 0L;
    private int burn_cooldown = 10;

    public DogPettingManager(Dog dog) {
        this.dog = dog;
    }

    public boolean isPetting() {
        return this.dog.getPettingState().is_petting();
    }

    public UUID getPetterId() {
        return this.dog.getPettingState().petting_id();
    }

    public void setPetting(class_1657 petter, DogPettingType type) {
        if (petter == null || type == null || !this.canPet(petter)) {
            return;
        }
        if (this.isPetting()) {
            return;
        }
        this.dog.setPettingState(new DogPettingState(petter.method_5667(), true, type));
        petter.field_6283 = petter.field_6241;
    }

    public void stopPetting() {
        if (!this.dog.method_37908().field_9236) {
            this.lastPetTimestamp = this.dog.method_37908().method_8532();
        }
        this.dog.setPettingState(DogPettingState.NULL);
    }

    public long getTimeSinceLastPet() {
        long ret = this.dog.method_37908().method_8532() - this.lastPetTimestamp;
        if (ret < 0L) {
            ret = 0L;
        }
        return ret;
    }

    public float getJealousChance() {
        long chance_time_start = 400L;
        long chance_time_end = 6000L;
        float max_chance = 0.2f;
        float min_chance = 0.05f;
        long last_pet_time = this.getTimeSinceLastPet();
        if (last_pet_time <= 400L) {
            return -1.0f;
        }
        long chance_time = last_pet_time - 400L;
        double progress = (double)chance_time / 5600.0;
        progress = class_3532.method_15350((double)progress, (double)0.0, (double)1.0);
        double ret = (double)0.05f + progress * (double)0.15f;
        return (float)ret;
    }

    public void tick() {
        class_1657 petter;
        if (!this.dog.method_37908().field_9236 && this.isPetting() && !this.canPet(this.getPetterFromDog())) {
            this.stopPetting();
        }
        if (this.dog.method_37908().field_9236 && this.isPetting()) {
            this.playParticleEffect();
        }
        if (!this.dog.method_37908().field_9236 && this.isPetting() && this.dog.dogVariant().burnsPetter()) {
            this.mayDoLoveBurns();
        }
        if (this.isPetting() && (petter = this.getPetterFromDog()) != null) {
            petter.field_6283 = petter.field_6241;
        }
    }

    public void mayDoLoveBurns() {
        if (--this.burn_cooldown > 0) {
            return;
        }
        class_5819 random = this.dog.method_59922();
        if (random.method_43048(100) != 0) {
            return;
        }
        this.burn_cooldown = (7 + random.method_43048(9)) * 20;
        class_1657 petter = this.getPetterFromDog();
        if (petter == null) {
            return;
        }
        boolean hurt_result = petter.method_5643(petter.method_48923().method_48817(), 0.1f);
        if (hurt_result) {
            petter.method_5783(class_3417.field_14821, 0.4f, 2.0f + random.method_43057() * 0.4f);
            if (this.dog.method_37908() instanceof class_3218) {
                ((class_3218)this.dog.method_37908()).method_14199((class_2394)class_2398.field_17430, petter.method_23317(), petter.method_23318(), petter.method_23321(), random.method_39332(2, 4), (double)petter.method_17681(), (double)0.8f, (double)petter.method_17681(), 0.1);
            }
        }
    }

    public void playParticleEffect() {
        class_5819 random = this.dog.method_59922();
        if (this.dog.method_59922().method_43048(20) == 0) {
            double x = this.dog.method_23317() + (double)RandomUtil.nextFloatRemapped(random) * ((double)(this.dog.method_17681() / 2.0f) + 0.3);
            double y = this.dog.method_23318() + 0.4 + (double)random.method_43057() * ((double)this.dog.method_17682() - 0.4);
            double z = this.dog.method_23321() + (double)RandomUtil.nextFloatRemapped(random) * ((double)(this.dog.method_17681() / 2.0f) + 0.3);
            double dx = random.method_43059() * 0.02;
            double dy = random.method_43059() * 0.02;
            double dz = random.method_43059() * 0.02;
            this.dog.method_37908().method_8406((class_2394)class_2398.field_11201, x, y, z, dx, dy, dz);
        }
    }

    public boolean canPet(class_1657 player) {
        if (this.locked) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.dog.method_6139(), (Object)player.method_5667())) {
            return false;
        }
        if (!this.isInPetDistance(this.dog, player)) {
            return false;
        }
        if (!this.isSelectingDog(player, this.dog)) {
            return false;
        }
        if (!DogPettingManager.isPlayerAbleToPet(player)) {
            return false;
        }
        return DogPettingManager.isDogAbleToBePet(this.dog);
    }

    public static boolean isPlayerAbleToPet(class_1657 player) {
        class_1799 mainhand_item = player.method_6047();
        if (mainhand_item != null && !mainhand_item.method_7960()) {
            return false;
        }
        if (player.method_5782() || player.method_5765()) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        return player.method_5715();
    }

    public static boolean isDogAbleToBePet(Dog dog) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!dog.method_6172() || !DogPettingManager.isDogPoseCanPet(dog.getDogPose())) {
            return false;
        }
        if (dog.method_5809()) {
            return false;
        }
        if (dog.method_5782() || dog.method_5765()) {
            return false;
        }
        DogSize size = dog.getDogSize();
        return size.largerOrEquals(DogSize.MODERATO);
    }

    public static boolean isDogPoseCanPet(DogPose dogPose) {
        return dogPose == DogPose.SIT || dogPose == DogPose.REST_BELLY;
    }

    public boolean isInPetDistance(Dog dog, class_1657 player) {
        double max_dist = this.getMaxPetDistance(dog, player);
        if (dog.method_5858((class_1297)player) >= max_dist * max_dist) {
            return false;
        }
        return this.checkEyeDistance(dog, player);
    }

    private double getMaxPetDistance(Dog dog, class_1657 player) {
        float dog_bbw = dog.method_17681();
        return (double)(dog_bbw / 2.0f + player.method_17681() / 2.0f) + 0.5;
    }

    private boolean checkEyeDistance(Dog dog, class_1657 player) {
        double dog_eye_y;
        double player_eye_y = player.method_23320();
        double d_eye_y = player_eye_y - (dog_eye_y = dog.method_23320());
        return 0.3 <= d_eye_y || d_eye_y <= 0.5;
    }

    private boolean isSelectingDog(class_1657 player, Dog dog) {
        class_243 eye_pos;
        double pick_range = player.method_55755();
        class_243 view_vec = player.method_5828(1.0f);
        class_243 from_vec = eye_pos = player.method_5836(0.0f);
        class_243 to_vec = eye_pos.method_1019(view_vec.method_1021(pick_range));
        class_238 dog_bb = dog.method_5829();
        boolean hit_dog = dog_bb.method_992(from_vec, to_vec).isPresent();
        return hit_dog;
    }

    private class_1657 getPetterFromDog() {
        if (!this.isPetting()) {
            return null;
        }
        UUID pet_uuid = this.getPetterId();
        class_1657 petter = this.dog.method_37908().method_18470(pet_uuid);
        return petter;
    }

    public boolean checkPush(class_1297 source) {
        if (!this.isPetting()) {
            return false;
        }
        class_1657 petting = this.getPetterFromDog();
        if (petting != source) {
            return false;
        }
        float max_go_inside_bb_dist = this.getMinClipDistanceWhenPet();
        if (max_go_inside_bb_dist <= 0.0f) {
            return false;
        }
        return !(petting.method_5858((class_1297)this.dog) < (double)(max_go_inside_bb_dist * max_go_inside_bb_dist));
    }

    private float getMinClipDistanceWhenPet() {
        DogPettingType type = this.dog.getPettingState().type();
        if (type == DogPettingType.BACK_HUG || type == DogPettingType.BELLY_RUB) {
            return 0.7f * this.dog.method_17681() / 2.0f;
        }
        return -1.0f;
    }

    public void setLocked(boolean lock) {
        this.locked = lock;
    }

    public void save(class_2487 tag) {
        class_2487 tag0 = new class_2487();
        tag0.method_10544("dog_last_pet_time", this.lastPetTimestamp);
        tag.method_10566("dogPettingManager", (class_2520)tag0);
    }

    public void load(class_2487 tag) {
        this.lastPetTimestamp = 0L;
        if (tag.method_10573("dogPettingManager", 10)) {
            class_2487 tag0 = tag.method_10562("dogPettingManager");
            this.lastPetTimestamp = tag0.method_10537("dog_last_pet_time");
        }
    }

    public record DogPettingState(UUID petting_id, boolean is_petting, DogPettingType type) {
        public static DogPettingState NULL = new DogPettingState(class_156.field_25140, false, DogPettingType.FACERUB);
    }

    public static enum DogPettingType {
        FACERUB(0),
        HUG(1),
        BELLY_RUB(2),
        BACK_HUG(3);

        private final int id;

        private DogPettingType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static DogPettingType fromId(int id) {
            DogPettingType[] vals = DogPettingType.values();
            if (id < 0 || id >= vals.length) {
                id = 0;
            }
            return vals[id];
        }
    }
}

