/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.DogSize;
import doggytalents.client.DTNClientDogSleepOnManager;
import doggytalents.common.entity.Dog;
import doggytalents.common.talent.BedDogTalent;
import doggytalents.forge_imitate.event.CanContinueSleepingEvent;
import doggytalents.forge_imitate.event.SleepFinishedTimeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class DogSleepOnManager {
    private static final DogSleepOnManager SERVER_INSTANCE = new DogSleepOnManager();
    private final Map<UUID, SleepOnPair> sleepingOnPairs = Maps.newHashMap();
    private final List<SleepOnPair> toRemove = new ArrayList<SleepOnPair>();

    private DogSleepOnManager() {
    }

    public static DogSleepOnManager getServer(class_1937 level) {
        if (level.field_9236) {
            throw new IllegalStateException("Only access this class's instance from the Logical Server.");
        }
        return SERVER_INSTANCE;
    }

    public static DogSleepOnManager getServer(MinecraftServer server) {
        if (server == null) {
            throw new IllegalStateException("Only access this class's instance from the Logical Server.");
        }
        return SERVER_INSTANCE;
    }

    public StartSleepOnDogResult setOrRequestSleepOn(Dog dog, class_1657 player) {
        StartSleepOnDogResult sleep_condition = this.isSleepCondition(dog);
        if (!sleep_condition.ok()) {
            return sleep_condition;
        }
        if (dog.sleepOnManager.isSleepOnReady()) {
            return this.setPlayerSleepOn(dog, player);
        }
        dog.sleepOnManager.setRequestedSleepOn(true);
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult setPlayerSleepOn(Dog dog, class_1657 player) {
        StartSleepOnDogResult can_start = this.canPlayerStartSleepOnDog(dog, player);
        if (!can_start.ok()) {
            return can_start;
        }
        Optional<Pair<Float, class_243>> sleep_pair_optional = this.findSleepRot(dog, player);
        if (!sleep_pair_optional.isPresent()) {
            return DogSleepOnFailMessage.NO_POS.asResult();
        }
        Pair<Float, class_243> sleep_pair = sleep_pair_optional.get();
        float sleep_yrot = ((Float)sleep_pair.getLeft()).floatValue();
        player.method_18403(dog.method_24515());
        player.method_29495((class_243)sleep_pair.getRight());
        this.rotateDogPerpenToSleepYRot(dog, sleep_yrot);
        DogSleepOnManager.rotatePlayerYRotToDog(dog, player, sleep_yrot);
        dog.setSleepOnState(new DogSleepOnState(player.method_5667(), true, sleep_yrot));
        this.addDogSleepOnPair(player, dog);
        ((class_3218)player.method_37908()).method_8448();
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult canPlayerStartSleepOnDog(Dog dog, class_1657 player) {
        StartSleepOnDogResult sleep_condition = this.isSleepCondition(dog);
        if (!sleep_condition.ok()) {
            return sleep_condition;
        }
        if (!dog.sleepOnManager.sleepOnReady) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult isSleepCondition(Dog dog) {
        if (!dog.isDoingFine()) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        class_3218 level = (class_3218)dog.method_37908();
        if (level.method_8530()) {
            return DogSleepOnFailMessage.NOT_SLEEP_TIME.asResult();
        }
        if (!level.method_33144()) {
            return DogSleepOnFailMessage.CANT_SLEEP_THROUGH_NIGHT.asResult();
        }
        if (!dog.getDogSize().largerOrEquals(DogSize.MODERATO)) {
            return DogSleepOnFailMessage.TOO_SMOL.asResult();
        }
        if (dog.getDogSize().largerOrEquals(DogSize.FORTE)) {
            return DogSleepOnFailMessage.TOO_BIG.asResult();
        }
        Optional<BedDogTalent> inst = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst.isPresent()) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        StartSleepOnDogResult inst_result = BedDogTalent.isSleepCondition(dog, inst.get());
        if (!inst_result.ok()) {
            return inst_result;
        }
        return StartSleepOnDogResult.OK;
    }

    private Optional<Pair<Float, class_243>> findSleepRot(Dog dog, class_1657 player) {
        float check_yrot1 = player.method_36454() + 180.0f;
        class_243 check_pos1 = this.getPlayerSleepPos(dog, check_yrot1);
        if (this.checkIfSleepPosIsEligible(dog, check_pos1)) {
            return Optional.of(Pair.of((Object)Float.valueOf(check_yrot1), (Object)check_pos1));
        }
        float dog_yrot = dog.method_36454();
        for (int i = 0; i < 8; ++i) {
            float check_yrot = dog_yrot + (float)i * 45.0f;
            class_243 check_pos = this.getPlayerSleepPos(dog, check_yrot);
            if (!this.checkIfSleepPosIsEligible(dog, check_pos)) continue;
            return Optional.of(Pair.of((Object)Float.valueOf(check_yrot), (Object)check_pos));
        }
        return Optional.empty();
    }

    private boolean checkIfSleepPosIsEligible(Dog dog, class_243 check_pos) {
        Iterable air_iterater = class_2338.method_10097((class_2338)class_2338.method_49638((class_2374)check_pos.method_1031(-1.0, 0.0, -1.0)), (class_2338)class_2338.method_49638((class_2374)check_pos.method_1031(1.0, 0.0, 1.0)));
        for (class_2338 pos : air_iterater) {
            class_2680 state = dog.method_37908().method_8320(pos);
            if (state.method_26215()) continue;
            return false;
        }
        Iterable solid_iterater = class_2338.method_10097((class_2338)class_2338.method_49638((class_2374)check_pos.method_1031(-1.0, -1.0, -1.0)), (class_2338)class_2338.method_49638((class_2374)check_pos.method_1031(1.0, -1.0, 1.0)));
        for (class_2338 pos : solid_iterater) {
            class_2680 state = dog.method_37908().method_8320(pos);
            if (state.method_26234((class_1922)dog.method_37908(), pos)) continue;
            return false;
        }
        return true;
    }

    private class_243 getPlayerSleepPos(Dog dog, float dog_sleep_rot) {
        class_243 sleep_on_pos = this.getSleepOnHeadPos(dog, dog_sleep_rot);
        class_243 dog_view_vec = dog.method_5631(0.0f, dog_sleep_rot);
        double distance_to_dog = 0.3;
        return new class_243(dog_view_vec.field_1352, 0.0, dog_view_vec.field_1350).method_1029().method_1021(0.3).method_1019(sleep_on_pos);
    }

    private class_243 getSleepOnHeadPos(Dog dog, float dog_sleep_rot) {
        float side_translate = -0.3f;
        float translate_rot = dog_sleep_rot + 90.0f;
        class_243 translate_vec = dog.method_5631(0.0f, translate_rot).method_1021((double)-0.3f);
        return dog.method_19538().method_1019(translate_vec);
    }

    private void rotateDogPerpenToSleepYRot(Dog dog, float dog_sleep_yrot) {
        float rotate_yrot = class_3532.method_15393((float)(dog_sleep_yrot + 90.0f));
        dog.method_36456(rotate_yrot);
        dog.field_6241 = dog.field_6283 = dog.method_36454();
    }

    public Optional<Dog> getSleepingOnDog(class_1309 entity) {
        if (this.sleepingOnPairs.isEmpty()) {
            return Optional.empty();
        }
        if (!(entity instanceof class_1657)) {
            return Optional.empty();
        }
        class_1657 player = (class_1657)entity;
        return Optional.ofNullable(this.sleepingOnPairs.get(player.method_5667()).dog());
    }

    public void stopPlayerSleepOn(Dog dog) {
        dog.setSleepOnState(DogSleepOnState.NULL);
        this.clearPlayerSleepOnFor(dog);
    }

    public static void tickServer(MinecraftServer server) {
        DogSleepOnManager.getServer(server).invalidateSleepers();
    }

    public static void onServerStop(MinecraftServer server) {
        DogSleepOnManager.getServer((MinecraftServer)server).sleepingOnPairs.clear();
    }

    private void invalidateSleepers() {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, SleepOnPair> entry : this.sleepingOnPairs.entrySet()) {
            SleepOnPair pair = entry.getValue();
            if (this.stillValidSleepingPair(pair.dog(), pair.player())) continue;
            this.toRemove.add(pair);
        }
        if (this.toRemove.isEmpty()) {
            return;
        }
        for (SleepOnPair x : this.toRemove) {
            this.stopPlayerSleepOn(x.dog());
        }
        this.toRemove.clear();
    }

    private boolean stillValidSleepingPair(Dog dog, class_1657 player) {
        if (!player.method_5805() || !dog.method_5805()) {
            return false;
        }
        if (!player.method_6113()) {
            return false;
        }
        DogSleepOnState dog_sleeping_state = dog.getSleepOnState();
        if (!dog_sleeping_state.is_sleeping()) {
            return false;
        }
        if (!this.isSleepCondition(dog).ok()) {
            return false;
        }
        class_243 sleep_pos = this.getPlayerSleepPos(dog, dog_sleeping_state.sleep_yrot());
        return !(player.method_5707(sleep_pos) > 0.010000000000000002);
    }

    private void addDogSleepOnPair(class_1657 player, Dog dog) {
        UUID uuid = player.method_5667();
        if (uuid == null) {
            return;
        }
        this.sleepingOnPairs.put(uuid, new SleepOnPair(dog, player));
    }

    private void removeSleepingOnDogToMap(UUID sleeper_id) {
        this.sleepingOnPairs.remove(sleeper_id);
    }

    private void clearPlayerSleepOnFor(Dog dog) {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, SleepOnPair> entry : this.sleepingOnPairs.entrySet()) {
            if (entry.getValue().dog() != dog) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID key : toRemove) {
            this.removeSleepingOnDogToMap(key);
        }
    }

    private void checkAndClearWhenPlayerWakeUp(class_1657 player) {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        SleepOnPair pair = this.sleepingOnPairs.get(player.method_5667());
        if (pair == null) {
            return;
        }
        this.stopPlayerSleepOn(pair.dog());
    }

    private void notifySleepSuccesAllDogAndStopSleeping(class_3218 level) {
        this.invalidateSleepers();
        for (Map.Entry<UUID, SleepOnPair> x : this.sleepingOnPairs.entrySet()) {
            SleepOnPair pair = x.getValue();
            Dog dog = pair.dog();
            if (!this.stillValidSleepingPair(dog, pair.player()) || dog.method_37908() != level) continue;
            this.notifySleepSuccessDog(dog);
            this.stopPlayerSleepOn(dog);
        }
    }

    private void notifySleepSuccessDog(Dog dog) {
        Optional<BedDogTalent> inst = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst.isPresent()) {
            return;
        }
        inst.get().onSuccessfulSleep(dog);
    }

    public static void canPlayerContinueSleeping(CanContinueSleepingEvent event) {
        if (event.getProblem() != class_1657.class_1658.field_7528) {
            return;
        }
        class_1309 player = event.getEntity();
        Optional<Dog> dog_optional = DogSleepOnManager.getServer(player.method_5682()).getSleepingOnDog(player);
        if (!dog_optional.isPresent()) {
            return;
        }
        event.setContinueSleeping(true);
    }

    public static void beforeSleepFinishedForAllPlayer(SleepFinishedTimeEvent event) {
        class_3218 level = (class_3218)event.getLevel();
        DogSleepOnManager.getServer((class_1937)level).notifySleepSuccesAllDogAndStopSleeping(level);
    }

    public static void onPlayerWakeUp(class_1657 player) {
        class_3218 level = (class_3218)player.method_37908();
        DogSleepOnManager.getServer((class_1937)level).checkAndClearWhenPlayerWakeUp(player);
    }

    public static void onDogSleepOnDataUpdated(Dog dog, DogSleepOnState state) {
        if (dog.method_37908().field_9236) {
            DTNClientDogSleepOnManager.get().onDogSleepOnDataUpdated(dog, state);
        }
    }

    public static void onSleepGoalStop(Dog dog) {
        dog.sleepOnManager.onSleepOnGoalStop();
        DogSleepOnManager.getServer(dog.method_37908()).stopPlayerSleepOn(dog);
    }

    public static void onHurt(Dog dog) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (!dog.getSleepOnState().is_sleeping()) {
            return;
        }
        DogSleepOnManager.getServer(dog.method_37908()).stopPlayerSleepOn(dog);
    }

    public static boolean shouldBlockPush(Dog dog) {
        return dog.getSleepOnState().is_sleeping();
    }

    public static void rotatePlayerYRotToDog(Dog dog, class_1657 player, float dog_sleep_yrot) {
        float rotate_yrot = class_3532.method_15393((float)(dog_sleep_yrot - 180.0f));
        player.method_36456(rotate_yrot);
        player.field_6241 = player.field_6283 = player.method_36454();
    }

    public static Optional<class_1657> getSleeperFromDog(Dog dog) {
        DogSleepOnState state = dog.getSleepOnState();
        return DogSleepOnManager.getSleeperFromDog(dog, state);
    }

    public static Optional<class_1657> getSleeperFromDog(Dog dog, DogSleepOnState state) {
        class_1657 sleeper = dog.method_37908().method_18470(state.sleeper());
        return Optional.ofNullable(sleeper);
    }

    public static class StartSleepOnDogResult {
        public static StartSleepOnDogResult OK = new StartSleepOnDogResult(Optional.empty());
        private Optional<DogSleepOnFailMessage> failMsg = Optional.empty();

        public StartSleepOnDogResult(Optional<DogSleepOnFailMessage> failMsg) {
            this.failMsg = failMsg;
        }

        public boolean ok() {
            return !this.failMsg.isPresent();
        }

        public boolean other() {
            return this.isFailMsg(DogSleepOnFailMessage.OTHER);
        }

        public DogSleepOnFailMessage failMsg() {
            return this.failMsg.orElse(null);
        }

        public boolean isFailMsg(DogSleepOnFailMessage msg) {
            return this.failMsg.isPresent() && this.failMsg.get() == msg;
        }
    }

    public static class PerDog {
        private final Dog dog;
        private boolean sleepOnRequested = false;
        private boolean sleepOnReady = false;
        private int requestTimeout = 0;

        public PerDog(Dog dog) {
            this.dog = dog;
        }

        public void tick() {
            if (!this.dog.method_37908().field_9236) {
                this.invalidateRequest();
            }
        }

        public void setSleepOnReady(boolean val) {
            this.sleepOnReady = val;
        }

        public boolean isSleepOnReady() {
            return this.sleepOnReady;
        }

        private void invalidateRequest() {
            if (!this.sleepOnRequested) {
                return;
            }
            if (this.requestTimeout > 0) {
                --this.requestTimeout;
            }
            if (this.requestTimeout <= 0) {
                this.sleepOnRequested = false;
            }
        }

        public void setRequestedSleepOn(boolean val) {
            this.sleepOnRequested = val;
            this.requestTimeout = 20;
        }

        public boolean isSleepOnRequested() {
            return this.sleepOnRequested;
        }

        public void onSleepOnGoalStop() {
            this.sleepOnRequested = false;
            this.sleepOnReady = false;
        }
    }

    public static enum DogSleepOnFailMessage {
        NOT_SLEEP_TIME("not_sleep_time", (dog, locId) -> class_2561.method_43469((String)locId, (Object[])new Object[]{dog.method_5477().getString()})),
        OTHER("other", (dog, locId) -> class_2561.method_43471((String)locId)),
        CANT_SLEEP_THROUGH_NIGHT("cant_sleep_thru_night", (dog, locId) -> class_2561.method_43471((String)locId)),
        DOG_LOW_HUNGER("low_hunger", (dog, locId) -> class_2561.method_43469((String)locId, (Object[])new Object[]{dog.method_5477().getString(), dog.getGenderSubject()})),
        COOLDOWN("cooldown", (dog, locId) -> class_2561.method_43473()),
        NO_POS("no_pos", (dog, locId) -> class_2561.method_43469((String)locId, (Object[])new Object[]{dog.method_5477().getString(), dog.getGenderSubject()})),
        TOO_SMOL("to_smol", (dog, locId) -> class_2561.method_43469((String)locId, (Object[])new Object[]{dog.method_5477().getString(), dog.getGenderSubject()})),
        TOO_BIG("to_big", (dog, locId) -> class_2561.method_43469((String)locId, (Object[])new Object[]{dog.method_5477().getString(), dog.getGenderSubject()}));

        private final String locId;
        private final BiFunction<Dog, String, class_2561> msgGetter;

        private DogSleepOnFailMessage(String locId, BiFunction<Dog, String, class_2561> msgGetter) {
            this.locId = "talent.doggytalents.bed_dog.fail." + locId;
            this.msgGetter = msgGetter;
        }

        public class_2561 getMsg(Dog dog) {
            return this.msgGetter.apply(dog, this.locId);
        }

        public StartSleepOnDogResult asResult() {
            return new StartSleepOnDogResult(Optional.of(this));
        }
    }

    public record DogSleepOnState(UUID sleeper, boolean is_sleeping, float sleep_yrot) {
        public static DogSleepOnState NULL = new DogSleepOnState(class_156.field_25140, false, 0.0f);
    }

    private record SleepOnPair(Dog dog, class_1657 player) {
    }
}

