/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_3417;

public class DogFeelingNakeyGoal
extends class_1352 {
    private Dog dog;
    private boolean prevNaked = true;
    private boolean turnedNaked = false;
    private int updateInterval = 60;
    private int lastUpdateTick;
    private int stopTick;
    private int tickAnim;

    public DogFeelingNakeyGoal(Dog dog) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        this.dog = dog;
    }

    public boolean method_6264() {
        this.findOutIfTurningToNakid();
        if (!this.dog.method_24345()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        return this.turnedNaked && this.isNaked(this.dog);
    }

    public boolean method_6266() {
        if (!this.dog.method_24345()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        if (!this.isNaked(this.dog)) {
            return false;
        }
        return this.dog.field_6012 < this.stopTick;
    }

    public void method_6269() {
        this.turnedNaked = false;
        DogAnimation currentAnimation = DogAnimation.NAKEY;
        this.stopTick = this.dog.field_6012 + currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(currentAnimation);
        this.tickAnim = 0;
    }

    public void method_6268() {
        if (this.tickAnim == 67) {
            this.dog.method_5783(class_3417.field_14807, this.dog.method_6107(), this.dog.method_6017());
        }
        ++this.tickAnim;
    }

    public void method_6270() {
        if (this.dog.getAnim() == DogAnimation.NAKEY) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    private void findOutIfTurningToNakid() {
        int updateAtTick = this.lastUpdateTick + this.updateInterval;
        if (this.dog.field_6012 < updateAtTick) {
            return;
        }
        this.lastUpdateTick = this.dog.field_6012;
        boolean naked = this.isNaked(this.dog);
        if (!naked) {
            this.turnedNaked = false;
        }
        if (naked && !this.prevNaked) {
            this.turnedNaked = this.dog.method_59922().method_43057() <= 0.9f;
        }
        this.updateInterval = naked ? (5 + this.dog.method_59922().method_43048(21)) * 20 : (1 + this.dog.method_59922().method_43048(3)) * 20;
        this.prevNaked = naked;
    }

    private boolean isNaked(Dog dog) {
        List<AccessoryInstance> accessories;
        if (!dog.hideArmor()) {
            Iterable<class_1799> armors = dog.method_5661();
            boolean hasArmor = false;
            for (class_1799 s : armors) {
                if (s.method_7960()) continue;
                hasArmor = true;
                break;
            }
            if (hasArmor) {
                return false;
            }
            if (dog.hasWolfArmor()) {
                return false;
            }
        }
        if ((accessories = dog.getAccessories()).isEmpty()) {
            return true;
        }
        boolean hasNonNaked = false;
        for (AccessoryInstance x : accessories) {
            Accessory accessory = x.getAccessory();
            if (accessory.isDogStillNakedWhenWear()) continue;
            hasNonNaked = true;
            break;
        }
        return !hasNonNaked;
    }

    public boolean method_38846() {
        return true;
    }
}

