/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network;

import com.google.common.collect.Maps;
import doggytalents.common.util.Util;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTNNetworkHandler {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/network");
    public static final class_8710.class_9154<DTNNetworkPayload<?>> CHANNEL_ID = new class_8710.class_9154(Util.getResource("payload_channel"));
    private static Map<Integer, PacketCodec<?>> PACKET_MAP = Maps.newHashMap();
    private static Map<Class<?>, Integer> DATACLASS_ID_MAP = Maps.newHashMap();
    private static final DTNNetworkPayload<Object> ERROR_DATA = new DTNNetworkPayload<Object>(null, null);

    public static void init() {
        class_9139 rw_stream_codec = class_9139.method_56437(DTNNetworkHandler::toBuf, DTNNetworkHandler::fromBuf);
        PayloadTypeRegistry.playC2S().register(CHANNEL_ID, rw_stream_codec);
        PayloadTypeRegistry.playS2C().register(CHANNEL_ID, rw_stream_codec);
        ServerPlayNetworking.registerGlobalReceiver(CHANNEL_ID, DTNNetworkHandler::handlePayloadServer);
    }

    public static synchronized <D> void registerMessage(int id, Class<D> dataClass, BiConsumer<D, class_2540> encoder, Function<class_2540, D> decoder, BiConsumer<D, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_MAP.put(id, new PacketCodec<D>(dataClass, encoder, decoder, messageConsumer));
        DATACLASS_ID_MAP.put(dataClass, id);
    }

    public static <D> void send(PacketDistributor.PacketTarget<?> target, D data) {
        Integer dataId = DATACLASS_ID_MAP.get(data.getClass());
        if (dataId == null) {
            return;
        }
        PacketCodec<?> codec = null;
        try {
            codec = PACKET_MAP.get(dataId);
        }
        catch (ClassCastException e) {
            codec = null;
            LOGGER.error("What ? [" + String.valueOf(e) + "]");
        }
        if (codec == null) {
            return;
        }
        DTNNetworkPayload<D> payload = new DTNNetworkPayload<D>(data, codec);
        target.sendPacket(payload);
    }

    private static DTNNetworkPayload<?> fromBuf(class_2540 buf) {
        int id = buf.readInt();
        if (id < 0) {
            return ERROR_DATA;
        }
        PacketCodec<?> packet = PACKET_MAP.get(id);
        if (packet == null) {
            return ERROR_DATA;
        }
        DTNNetworkPayload<Object> ret = null;
        try {
            ret = DTNNetworkHandler.decodeWithDecoder(packet, buf);
        }
        catch (Exception e) {
            LOGGER.error("Decoding packet failed with decoder_id [" + id + "]  data [" + packet.dataClass.getName() + "] error_message [" + e.getMessage() + "]");
            ret = ERROR_DATA;
        }
        return ret;
    }

    private static <T> DTNNetworkPayload<T> decodeWithDecoder(PacketCodec<T> codec, class_2540 buf) {
        T data = codec.decode(buf);
        return new DTNNetworkPayload<T>(data, codec);
    }

    private static void toBuf(class_2540 buf, DTNNetworkPayload<?> payload) {
        if (payload == ERROR_DATA) {
            buf.method_53002(-1);
            return;
        }
        Integer dataId = DATACLASS_ID_MAP.get(payload.data.getClass());
        if (dataId == null) {
            buf.method_53002(-1);
            return;
        }
        buf.method_53002(dataId.intValue());
        DTNNetworkHandler.encodePayloadDataToBuf(payload, buf);
    }

    private static <T> void encodePayloadDataToBuf(DTNNetworkPayload<T> payload, class_2540 buf) {
        payload.codec.encode(buf, payload.data);
    }

    private static void handlePayloadServer(DTNNetworkPayload<?> payload, ServerPlayNetworking.Context context) {
        NetworkEvent.Context ctx = new NetworkEvent.Context();
        ctx.sender = context.player();
        ctx.isClientRecipent = false;
        DTNNetworkHandler.handlePayloadContext(payload, ctx);
    }

    public static void handlePayloadClient(DTNNetworkPayload<?> payload) {
        NetworkEvent.Context ctx = new NetworkEvent.Context();
        ctx.sender = null;
        ctx.isClientRecipent = true;
        DTNNetworkHandler.handlePayloadContext(payload, ctx);
    }

    private static void handlePayloadContext(DTNNetworkPayload<?> payload, NetworkEvent.Context ctx) {
        if (payload == ERROR_DATA || payload.data == null || payload.codec == null) {
            LOGGER.error("Recieved error data!");
            return;
        }
        DTNNetworkHandler.handleForCodec(payload, ctx);
    }

    private static <T> void handleForCodec(DTNNetworkPayload<T> payload, NetworkEvent.Context ctx) {
        payload.codec.consume(payload.data, ctx);
    }

    private static class PacketCodec<T> {
        public final Class<T> dataClass;
        public final BiConsumer<T, class_2540> encoder;
        public final Function<class_2540, T> decoder;
        public final BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer;

        PacketCodec(Class<T> dataClass, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
            this.dataClass = dataClass;
            this.encoder = encoder;
            this.decoder = decoder;
            this.messageConsumer = messageConsumer;
        }

        public void consume(T data, NetworkEvent.Context ctx) {
            this.messageConsumer.accept(data, () -> ctx);
        }

        public T decode(class_2540 buf) {
            return this.decoder.apply(buf);
        }

        public void encode(class_2540 buf, T data) {
            this.encoder.accept(data, buf);
        }
    }

    public static class DTNNetworkPayload<T>
    implements class_8710 {
        private final T data;
        private final PacketCodec<T> codec;

        public DTNNetworkPayload(T data, PacketCodec<T> codec) {
            this.data = data;
            this.codec = codec;
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return CHANNEL_ID;
        }
    }

    public static class NetworkEvent {

        public static class Context {
            @Nullable
            private class_3222 sender;
            private boolean isClientRecipent = false;

            public void enqueueWork(Runnable runnable) {
                runnable.run();
            }

            @Nullable
            public class_3222 getSender() {
                return this.sender;
            }

            public boolean isClientRecipent() {
                return this.isClientRecipent;
            }

            public boolean isServerRecipent() {
                return !this.isClientRecipent;
            }

            public void setPacketHandled(boolean val) {
            }
        }
    }
}

