/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogExplosionData;
import doggytalents.common.talent.OokamiKazeTalent;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class DogExplosionPacket
implements IPacket<DogExplosionData> {
    @Override
    public void encode(DogExplosionData data, class_2540 buf) {
        buf.method_53002(data.dogId);
        boolean has_knockback = data.knockback().isPresent();
        buf.method_52964(has_knockback);
        if (has_knockback) {
            class_243 knock = data.knockback().get();
            buf.method_52940(knock.method_10216());
            buf.method_52940(knock.method_10214());
            buf.method_52940(knock.method_10215());
        }
    }

    @Override
    public DogExplosionData decode(class_2540 buf) {
        int id = buf.readInt();
        boolean has_knockback = buf.readBoolean();
        class_243 knock = null;
        if (has_knockback) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            knock = new class_243(x, y, z);
        }
        return new DogExplosionData(id, knock);
    }

    @Override
    public void handle(DogExplosionData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                class_310 mc = class_310.method_1551();
                class_1297 e = mc.field_1687.method_8469(data.dogId);
                if (e instanceof Dog) {
                    Dog dog = (Dog)e;
                    OokamiKazeTalent.explodeClient(dog);
                    data.knockback().ifPresent(x -> {
                        class_746 player = mc.field_1724;
                        if (player == null) {
                            return;
                        }
                        class_243 knock_movement = player.method_18798().method_1019(x);
                        player.method_18799(knock_movement);
                    });
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

