/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.client.screen.DogNewInfoScreen.store.slice.ActiveTabSlice;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogGroupsData;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_638;

public class DogGroupPackets {

    public static class UPDATE
    implements IPacket<DogGroupsData.UPDATE> {
        @Override
        public void encode(DogGroupsData.UPDATE data, class_2540 buf) {
            buf.method_53002(data.dogId);
            buf.method_53002(data.groups.size());
            for (DogGroupsManager.DogGroup group : data.groups) {
                buf.method_10788(group.name, 16);
                buf.method_53002(group.color);
            }
        }

        @Override
        public DogGroupsData.UPDATE decode(class_2540 buf) {
            int id = buf.readInt();
            int size = buf.readInt();
            ArrayList<DogGroupsManager.DogGroup> groups = new ArrayList<DogGroupsManager.DogGroup>(size);
            for (int i = 0; i < size; ++i) {
                String group = buf.method_10800(16);
                int color = buf.readInt();
                groups.add(new DogGroupsManager.DogGroup(group, color));
            }
            return new DogGroupsData.UPDATE(id, groups);
        }

        @Override
        public void handle(DogGroupsData.UPDATE data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    return;
                }
                class_310 mc = class_310.method_1551();
                class_638 level = mc.field_1687;
                if (level == null) {
                    return;
                }
                class_1297 e = level.method_8469(data.dogId);
                if (!(e instanceof Dog)) {
                    return;
                }
                Dog d = (Dog)e;
                DogGroupsManager groups = d.getGroups();
                groups.clear();
                for (DogGroupsManager.DogGroup group : data.groups) {
                    groups.add(group);
                }
                ActiveTabSlice.dispatchGroupUpdates();
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class FETCH_REQUEST
    extends DogPacket<DogGroupsData.FETCH_REQUEST> {
        @Override
        public DogGroupsData.FETCH_REQUEST decode(class_2540 buf) {
            return new DogGroupsData.FETCH_REQUEST(buf.readInt());
        }

        @Override
        public void handleDog(Dog dogIn, DogGroupsData.FETCH_REQUEST data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            if (dogIn.method_37908().field_9236) {
                return;
            }
            DogGroupsManager groups = dogIn.getGroups();
            class_3222 sender = ctx.get().getSender();
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new DogGroupsData.UPDATE(dogIn.method_5628(), new ArrayList<DogGroupsManager.DogGroup>(groups.getGroupsReadOnly())));
        }
    }

    public static class EDIT
    extends DogPacket<DogGroupsData.EDIT> {
        @Override
        public void encode(DogGroupsData.EDIT data, class_2540 buf) {
            super.encode(data, buf);
            buf.method_52964(data.add);
            buf.method_10788(data.group.name, 16);
            buf.method_53002(data.group.color);
        }

        @Override
        public DogGroupsData.EDIT decode(class_2540 buf) {
            int id = buf.readInt();
            boolean add = buf.readBoolean();
            String group = buf.method_10800(16);
            int color = buf.readInt();
            return new DogGroupsData.EDIT(id, new DogGroupsManager.DogGroup(group, color), add);
        }

        @Override
        public void handleDog(Dog dogIn, DogGroupsData.EDIT data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            if (dogIn.method_37908().field_9236) {
                return;
            }
            class_3222 sender = ctx.get().getSender();
            if (!dogIn.canInteract((class_1309)sender)) {
                return;
            }
            DogGroupsManager groups = dogIn.getGroups();
            boolean update = false;
            update = data.add ? groups.add(data.group) : groups.remove(data.group);
            if (update) {
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new DogGroupsData.UPDATE(dogIn.method_5628(), new ArrayList<DogGroupsManager.DogGroup>(groups.getGroupsReadOnly())));
            }
        }
    }
}

