/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyItems;
import doggytalents.api.feature.DogGender;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.LocatorOrbAccessory;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.NBTUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class DogLocationData
implements IDogData {
    private final DogLocationStorage storage;
    private final UUID uuid;
    @Nullable
    private UUID ownerId;
    @Nullable
    private UUID sessionUUID;
    @Nullable
    private class_243 position;
    @Nullable
    private class_5321<class_1937> dimension;
    @Nullable
    private class_2561 name;
    @Nullable
    private DogGender gender;
    private boolean hasRadarCollar;
    private int locateColor;

    protected DogLocationData(DogLocationStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Nullable
    public UUID getSessionUUID() {
        return this.sessionUUID;
    }

    public void setSessionUUID(UUID sessionUUID) {
        this.sessionUUID = sessionUUID;
        this.storage.method_80();
    }

    @Override
    public String getDogName() {
        return this.name == null ? "" : this.name.getString();
    }

    public void populate(Dog dogIn) {
        this.update(dogIn);
    }

    public void update(Dog dogIn) {
        this.ownerId = dogIn.method_6139();
        this.position = dogIn.method_19538();
        this.dimension = dogIn.method_37908().method_27983();
        this.name = dogIn.method_5477();
        this.gender = dogIn.getGender();
        this.updateLocator(dogIn);
        this.storage.method_80();
    }

    private void updateLocator(Dog dog) {
        this.hasRadarCollar = false;
        this.locateColor = 0;
        Optional<LocatorOrbAccessory> locator_optional = this.checkLocatorOrb(dog);
        if (locator_optional.isPresent()) {
            LocatorOrbAccessory locator = locator_optional.get();
            this.hasRadarCollar = true;
            this.locateColor = locator.getOrbColor();
            return;
        }
        boolean has_radio = this.checkLegacyRadioCollar(dog);
        if (has_radio) {
            this.hasRadarCollar = true;
            return;
        }
    }

    private Optional<LocatorOrbAccessory> checkLocatorOrb(Dog dog) {
        Optional<AccessoryInstance> accessory_optional = dog.getAccessory(DoggyAccessoryTypes.SCARF.get());
        if (!accessory_optional.isPresent()) {
            return Optional.empty();
        }
        AccessoryInstance accessory = accessory_optional.get();
        Accessory accessory2 = accessory.getAccessory();
        if (accessory2 instanceof LocatorOrbAccessory) {
            LocatorOrbAccessory locator = (LocatorOrbAccessory)accessory2;
            return Optional.of(locator);
        }
        return Optional.empty();
    }

    private boolean checkLegacyRadioCollar(Dog dog) {
        Optional<AccessoryInstance> accessory_optional = dog.getAccessory(DoggyAccessoryTypes.RADIO_COLLAR_LEGACY.get());
        return accessory_optional.isPresent();
    }

    public void read(class_2487 compound) {
        this.ownerId = NBTUtil.getUniqueId(compound, "ownerId");
        this.position = NBTUtil.getVector3d(compound);
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)NBTUtil.getResourceLocation(compound, "dimension"));
        this.name = NBTUtil.getTextComponent(compound, "name_text_component");
        if (compound.method_10573("gender", 8)) {
            this.gender = DogGender.bySaveName(compound.method_10558("gender"));
        }
        this.hasRadarCollar = compound.method_10577("collar");
        if (compound.method_25928("sessionUUID")) {
            this.sessionUUID = compound.method_25926("sessionUUID");
        }
        this.locateColor = compound.method_10550("locateOrbColor");
    }

    public class_2487 write(class_2487 compound) {
        NBTUtil.putUniqueId(compound, "ownerId", this.ownerId);
        NBTUtil.putVector3d(compound, this.position);
        NBTUtil.putResourceLocation(compound, "dimension", this.dimension.method_29177());
        NBTUtil.putTextComponent(compound, "name_text_component", this.name);
        if (this.gender != null) {
            compound.method_10582("gender", this.gender.getSaveName());
        }
        compound.method_10556("collar", this.hasRadarCollar);
        if (this.sessionUUID != null) {
            compound.method_25927("sessionUUID", this.sessionUUID);
        }
        compound.method_10569("locateOrbColor", this.locateColor);
        return compound;
    }

    public static DogLocationData from(DogLocationStorage storageIn, Dog dogIn) {
        DogLocationData locationData = new DogLocationData(storageIn, dogIn.method_5667());
        locationData.populate(dogIn);
        return locationData;
    }

    public boolean shouldDisplay(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (((Boolean)ConfigHandler.SERVER.ALLOW_TRACK_ANY_DOG.get()).booleanValue()) {
            return true;
        }
        return this.hasRadarCollar || playerIn.method_7337() || playerIn.method_5998(handIn).method_7909() == DoggyItems.CREATIVE_CANINE_TRACKER.get();
    }

    public Optional<Dog> getOnlineDog() {
        return this.storage.getOnlineDogsManager().getOnlineDog(this.uuid);
    }

    @Nullable
    public class_2561 getName(@Nullable class_1937 worldIn) {
        return this.getOnlineDog().map(class_1297::method_5476).orElse(this.name);
    }

    @Nullable
    public class_243 getPos(@Nullable class_3218 worldIn) {
        return this.getOnlineDog().map(class_1297::method_19538).orElse(this.position);
    }

    @Nullable
    public class_243 getPos() {
        return this.position;
    }

    @Nullable
    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public int getLocateColor() {
        return this.locateColor;
    }

    public String toString() {
        return "DogLocationData [uuid=" + String.valueOf(this.uuid) + ", owner=" + String.valueOf(this.ownerId) + ", position=" + String.valueOf(this.position) + ", dimension=" + String.valueOf(this.dimension) + ", name=" + String.valueOf(this.name) + ", gender=" + String.valueOf((Object)this.gender) + ", hasRadarCollar=" + this.hasRadarCollar + "]";
    }
}

