/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.entity.Dog;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9;

public class GatePasserTalent
extends TalentInstance {
    private boolean allowPassingGate = true;
    private int openDoorCooldown = 0;
    private int keepOpenDoorTick = 0;
    private Optional<class_2338> currentOpenedDoor = Optional.empty();
    private int navTickLeftTillCanOpenDoor = 20;
    private boolean canApplyBeginNavCooldown = true;

    public GatePasserTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dog) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (!this.allowPassingGate) {
            if (this.currentOpenedDoor.isPresent()) {
                this.currentOpenedDoor = Optional.empty();
            }
            return;
        }
        this.updateNavTickLeftTillCanOpenDoor(dog);
        if (this.openDoorCooldown > 0) {
            --this.openDoorCooldown;
        }
        if (this.keepOpenDoorTick > 0) {
            --this.keepOpenDoorTick;
        }
        if (this.currentOpenedDoor.isPresent()) {
            this.invalidateAndMayCloseOpenedDoor(dog);
        } else {
            this.checkPathForDoorAndTryOpen(dog);
        }
    }

    private void updateNavTickLeftTillCanOpenDoor(AbstractDog dog) {
        class_1408 nav = dog.method_5942();
        if (this.canApplyBeginNavCooldown && nav.method_6357()) {
            this.navTickLeftTillCanOpenDoor = 20;
            this.canApplyBeginNavCooldown = false;
            return;
        }
        --this.navTickLeftTillCanOpenDoor;
        if (this.navTickLeftTillCanOpenDoor < 0) {
            this.navTickLeftTillCanOpenDoor = 0;
        }
    }

    private List<Dog> getNearbyGatePasser(AbstractDog dog) {
        Predicate<Dog> is_passer_and_not_dog = filter_dog -> filter_dog != dog && filter_dog.isDoingFine() && !filter_dog.method_5942().method_6357() && filter_dog.getDogLevel(DoggyTalents.GATE_PASSER) > 0;
        List passers = dog.method_37908().method_8390(Dog.class, dog.method_5829().method_1014(1.0), is_passer_and_not_dog);
        return passers;
    }

    private void checkPathForDoorAndTryOpen(AbstractDog dog) {
        if (this.openDoorCooldown > 0) {
            return;
        }
        if (this.navTickLeftTillCanOpenDoor > 0) {
            return;
        }
        class_1408 nav = dog.method_5942();
        if (nav.method_6357()) {
            return;
        }
        class_11 path = nav.method_6345();
        if (path == null || path.method_46()) {
            return;
        }
        class_2338 doorPos = null;
        class_2680 doorState = null;
        class_2248 doorBlock = null;
        class_9 prevNode = path.method_30850();
        if (prevNode != null) {
            class_2338 prevPos = prevNode.method_22879();
            class_2680 state = dog.method_37908().method_8320(prevPos);
            class_2248 block = state.method_26204();
            if (this.isValidDoorBlock(block) && !this.isDoorOpen(state, prevPos)) {
                doorState = state;
                doorPos = prevPos;
                doorBlock = block;
            }
        }
        class_9 nextNode = path.method_29301();
        if (doorState == null) {
            class_2338 nextPos = nextNode.method_22879();
            class_2680 state = dog.method_37908().method_8320(nextPos);
            class_2248 block = state.method_26204();
            if (this.isValidDoorBlock(block) && !this.isDoorOpen(state, nextPos)) {
                doorState = state;
                doorPos = nextPos;
                doorBlock = block;
            }
        }
        if (doorState == null || doorPos == null || doorBlock == null) {
            return;
        }
        this.currentOpenedDoor = Optional.of(doorPos);
        this.setOpenDoor(dog, doorState, doorPos, true);
        this.canApplyBeginNavCooldown = true;
        this.keepOpenDoorTick = 5;
    }

    private void invalidateAndMayCloseOpenedDoor(AbstractDog dog) {
        if (this.keepOpenDoorTick > 0) {
            return;
        }
        if (!this.currentOpenedDoor.isPresent()) {
            return;
        }
        class_2338 currentOpened = this.currentOpenedDoor.get();
        if (dog.method_5707(class_243.method_24955((class_2382)currentOpened)) > 16.0) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        class_2680 state = dog.method_37908().method_8320(currentOpened);
        class_2248 block = state.method_26204();
        if (!this.isValidDoorBlock(block)) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        if (!this.isDoorOpen(state, currentOpened)) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        if (this.isDogStillPassingThruDoor(dog, currentOpened)) {
            return;
        }
        if (this.mayDelegateClosingDoorToStillPassingDog(dog, currentOpened)) {
            return;
        }
        this.setOpenDoor(dog, state, currentOpened, false);
        this.openDoorCooldown = 5;
        this.currentOpenedDoor = Optional.empty();
    }

    private boolean isDogStillPassingThruDoor(AbstractDog dog, class_2338 doorPos) {
        class_1408 nav = dog.method_5942();
        if (nav.method_6357()) {
            return false;
        }
        class_11 path = nav.method_6345();
        if (path == null || path.method_46()) {
            return false;
        }
        class_9 nextNode = path.method_29301();
        if (nextNode.method_22879().equals((Object)doorPos)) {
            return true;
        }
        class_9 prevNextNode = path.method_30850();
        return prevNextNode != null && prevNextNode.method_22879().equals((Object)doorPos);
    }

    private boolean mayDelegateClosingDoorToStillPassingDog(AbstractDog delegator, class_2338 doorPos) {
        List<Dog> passers = this.getNearbyGatePasser(delegator);
        if (passers.isEmpty()) {
            return false;
        }
        Dog delegate = null;
        GatePasserTalent delegateInst = null;
        for (Dog dog : passers) {
            TalentInstance inst;
            Optional instOptional;
            if (!dog.isDoingFine() || !this.isDogStillPassingThruDoor(dog, doorPos) || !(instOptional = dog.getTalent(DoggyTalents.GATE_PASSER)).isPresent() || !((inst = (TalentInstance)instOptional.get()) instanceof GatePasserTalent)) continue;
            GatePasserTalent gate = (GatePasserTalent)inst;
            delegate = dog;
            delegateInst = gate;
            break;
        }
        if (delegate == null || delegateInst == null) {
            return false;
        }
        delegateInst.currentOpenedDoor = Optional.of(doorPos);
        this.currentOpenedDoor = Optional.empty();
        this.openDoorCooldown = 5;
        return true;
    }

    private boolean isValidDoorBlock(class_2248 block) {
        class_2323 door;
        return block instanceof class_2323 && (door = (class_2323)block).method_51169().comp_1471() || block instanceof class_2349;
    }

    private void setOpenDoor(AbstractDog dog, class_2680 state, class_2338 pos, boolean open) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2323) {
            class_2323 door = (class_2323)block;
            door.method_10033((class_1297)dog, dog.method_37908(), state, pos, open);
            return;
        }
        if (block instanceof class_2349) {
            class_2349 fenceGate = (class_2349)block;
            this.setOpenFenceGate(dog.method_37908(), state, pos, dog, fenceGate, open);
            return;
        }
    }

    private void setOpenFenceGate(class_1937 level, class_2680 state, class_2338 pos, AbstractDog dog, class_2349 fence, boolean open) {
        boolean open0 = (Boolean)state.method_11654((class_2769)class_2349.field_11026);
        boolean hasUpdate = false;
        if (!open && open0) {
            state = (class_2680)state.method_11657((class_2769)class_2349.field_11026, (Comparable)Boolean.valueOf(false));
            level.method_8652(pos, state, 10);
            hasUpdate = true;
        }
        if (open && !open0) {
            class_2350 direction = dog.method_5735();
            if (state.method_11654((class_2769)class_2349.field_11177) == direction.method_10153()) {
                state = (class_2680)state.method_11657((class_2769)class_2349.field_11177, (Comparable)direction);
            }
            state = (class_2680)state.method_11657((class_2769)class_2349.field_11026, (Comparable)Boolean.valueOf(true));
            level.method_8652(pos, state, 10);
            hasUpdate = true;
        }
        if (hasUpdate) {
            boolean still_open = (Boolean)state.method_11654((class_2769)class_2349.field_11026);
            level.method_45445((class_1297)dog, pos, still_open ? class_3417.field_14766 : class_3417.field_14861, class_3419.field_15245, 1.0f, dog.method_59922().method_43057() * 0.1f + 0.9f);
            level.method_33596((class_1297)dog, (class_6880)(still_open ? class_5712.field_28168 : class_5712.field_28169), pos);
        }
    }

    private boolean isDoorOpen(class_2680 state, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2323) {
            class_2323 door = (class_2323)block;
            return door.method_30841(state);
        }
        if (block instanceof class_2349) {
            class_2349 fenceGate = (class_2349)block;
            return (Boolean)state.method_11654((class_2769)class_2349.field_11026);
        }
        return false;
    }

    @Override
    public class_1269 canDogPassGate(AbstractDog dogIn) {
        if (this.allowPassingGate) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, class_2487 compound) {
        super.readFromNBT(dogIn, compound);
        this.allowPassingGate = compound.method_10577("DogGatePasser_allowPassingGate");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10556("DogGatePasser_allowPassingGate", this.allowPassingGate);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.GATE_PASSER_ENABLE.get()) {
            return this.allowPassingGate;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.GATE_PASSER_ENABLE.get()) {
            this.allowPassingGate = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.GATE_PASSER_ENABLE.get());
    }

    public boolean allowPassingGate() {
        return this.allowPassingGate;
    }

    public void setAllowPassingGate(boolean val) {
        this.allowPassingGate = val;
    }
}

