/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import com.google.common.collect.Maps;
import doggytalents.DoggyAdvancementTriggers;
import doggytalents.DoggyTalents;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAllyCheck;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogExplosionData;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class OokamiKazeTalent
extends TalentInstance {
    private int cooldown = 0;

    public OokamiKazeTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.method_37908().field_9236) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public boolean canExplode() {
        return this.cooldown <= 0;
    }

    public DogCatchGunpowderAndExplodeAction actionCreator(Dog dog, @Nullable DogGunpowderProjectile proj) {
        return new DogCatchGunpowderAndExplodeAction(dog, proj, this.getRadius(), this.getKnockbackModifier());
    }

    public int getRadius() {
        int level = this.level();
        if (level >= 5) {
            return 14;
        }
        if (level <= 1) {
            return 3;
        }
        if (level <= 2) {
            return 4;
        }
        if (level <= 3) {
            return 6;
        }
        if (level <= 4) {
            return 10;
        }
        return 0;
    }

    public float getKnockbackModifier() {
        int level = this.level();
        if (level >= 5) {
            return 2.5f;
        }
        if (level <= 2) {
            return 1.0f;
        }
        if (level <= 3) {
            return 1.4f;
        }
        if (level <= 4) {
            return 1.8f;
        }
        return 1.0f;
    }

    public static void explodeClient(Dog dog) {
        class_1937 level = dog.method_37908();
        class_243 dog_pos = dog.method_19538();
        if (level.field_9236) {
            level.method_8486(dog_pos.field_1352, dog_pos.field_1351, dog_pos.field_1350, (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.2f) * 0.7f, false);
        }
        level.method_8406((class_2394)class_2398.field_11236, dog_pos.field_1352, dog_pos.field_1351, dog_pos.field_1350, 1.0, 0.0, 0.0);
        level.method_8406((class_2394)class_2398.field_11221, dog_pos.field_1352, dog_pos.field_1351, dog_pos.field_1350, 1.0, 0.0, 0.0);
    }

    public static class DogCatchGunpowderAndExplodeAction
    extends TriggerableAction {
        private ActionPhase phase;
        private int stopTick;
        private final int radius;
        private final float knockbackModifier;
        private final DogGunpowderProjectile toCatch;
        private int tickTillJump;
        private int tickTillConsumeItem;
        private int tickTillHowl = 50;
        private int tickTillBoom = 55;

        public DogCatchGunpowderAndExplodeAction(Dog dog, @Nullable DogGunpowderProjectile toCatch, int radius, float knockbackModifier) {
            super(dog, false, false);
            this.phase = toCatch != null ? ActionPhase.CATCH : ActionPhase.EXPLODE;
            this.toCatch = toCatch;
            this.radius = radius;
            this.knockbackModifier = knockbackModifier;
        }

        @Override
        public void onStart() {
            if (this.phase == ActionPhase.CATCH) {
                this.beginCatchAnim();
            } else if (this.phase == ActionPhase.EXPLODE) {
                this.beginHowlAnim();
            } else {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.dog.setForcedActionAnim(true);
            this.dog.dogSoundManager.setAmbientLocked(true);
        }

        @Override
        public void tick() {
            if (this.phase == ActionPhase.CATCH) {
                this.updateToCatch();
            } else if (this.phase == ActionPhase.WAIT_TILL_LAND) {
                this.updateWaitTillLand();
            } else {
                this.updateHowlAndExplode();
            }
        }

        private void updateToCatch() {
            if (this.dog.getAnim() != DogAnimation.BACKFLIP) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.toCatch == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.field_6012 >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillJump == 0) {
                this.dog.method_5993().method_6233();
            }
            if (--this.tickTillConsumeItem <= 0 && this.tryConsumeItem()) {
                this.phase = ActionPhase.WAIT_TILL_LAND;
                return;
            }
        }

        public boolean tryConsumeItem() {
            if (this.toCatch == null) {
                return false;
            }
            if (!this.toCatch.method_5805()) {
                return false;
            }
            if (this.dog.method_5858((class_1297)this.toCatch) > 4.0) {
                return false;
            }
            this.toCatch.feedDog(this.dog);
            return true;
        }

        public void updateWaitTillLand() {
            if (this.dog.getAnim() == DogAnimation.NONE) {
                this.phase = ActionPhase.EXPLODE;
                this.beginHowlAnim();
                return;
            }
            if (this.dog.getAnim() != DogAnimation.BACKFLIP) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }

        private void updateHowlAndExplode() {
            if (this.dog.getAnim() != DogAnimation.HOWL) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.field_6012 >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            --this.tickTillHowl;
            if (this.tickTillHowl == 0) {
                this.dog.dogSoundManager.playInterruptible(class_3417.field_15117, 1.0f, this.dog.method_6017());
            } else if (this.tickTillHowl == 30) {
                this.dog.method_5783(class_3417.field_14575, 0.3f, this.dog.method_6017());
            }
            --this.tickTillBoom;
            if (this.tickTillBoom == 0) {
                DogExplosion explode = new DogExplosion(this.dog, this.radius, this.knockbackModifier);
                explode.explode();
                this.setTalentCooldown();
                this.triggerAdvancement();
            }
        }

        @Override
        public void onStop() {
            this.dog.setForcedActionAnim(false);
            this.dog.dogSoundManager.setAmbientLocked(false);
            this.dog.dogSoundManager.interuptPlaying();
            if (this.phase == ActionPhase.EXPLODE) {
                if (this.dog.getAnim() == DogAnimation.HOWL) {
                    this.dog.setAnim(DogAnimation.NONE);
                }
                return;
            }
            if (this.dog.getAnim() == DogAnimation.BACKFLIP) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }

        private void beginCatchAnim() {
            this.stopTick = this.dog.field_6012 + DogAnimation.BACKFLIP.getLengthTicks();
            this.dog.setAnim(DogAnimation.BACKFLIP);
            this.tickTillJump = 3;
            this.tickTillConsumeItem = 5;
        }

        private void beginHowlAnim() {
            this.stopTick = this.dog.field_6012 + DogAnimation.HOWL.getLengthTicks();
            this.dog.setAnim(DogAnimation.HOWL);
            this.tickTillBoom = 63;
        }

        private void setTalentCooldown() {
            OokamiKazeTalent talent = this.dog.getTalent(DoggyTalents.OOKAMIKAZE).map(inst -> inst.cast(OokamiKazeTalent.class)).orElse(null);
            if (talent == null) {
                return;
            }
            talent.cooldown = 200;
        }

        private void triggerAdvancement() {
            class_1309 owner = this.dog.method_35057();
            if (!(owner instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)owner;
            DoggyAdvancementTriggers.OOKAMIKAZE_TRIGGER.trigger(this.dog, player);
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }

        private static enum ActionPhase {
            CATCH,
            WAIT_TILL_LAND,
            EXPLODE;

        }
    }

    public static class DogExplosion {
        private final Dog dog;
        private final int radius;
        private float knockbackModifier = 1.0f;
        private final Map<class_3222, class_243> toSendKnockback = Maps.newHashMap();

        public DogExplosion(Dog dog, int radius, float knockbackModifier) {
            this.dog = dog;
            this.radius = radius;
            this.knockbackModifier = knockbackModifier;
        }

        public void explode() {
            if (this.dog.method_37908().field_9236) {
                return;
            }
            this.dog.method_37908().method_43275((class_1297)this.dog, (class_6880)class_5712.field_28178, this.dog.method_19538());
            this.hurtEntities();
            this.broadcastExploisionToClient();
            this.toSendKnockback.clear();
        }

        private void broadcastExploisionToClient() {
            class_1937 level = this.dog.method_37908();
            MinecraftServer server = level.method_8503();
            if (server == null) {
                return;
            }
            class_3324 playerList = server.method_3760();
            if (playerList == null) {
                return;
            }
            int notify_radius = 64;
            for (class_3222 player : playerList.method_14571()) {
                double dist_sqr;
                if (player.method_37908() != level || (dist_sqr = player.method_5858((class_1297)this.dog)) > 4096.0) continue;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogExplosionData(this.dog.method_5628(), this.toSendKnockback.get(player)));
            }
        }

        private void hurtEntities() {
            class_1309 owner = this.dog.method_35057();
            if (owner == null) {
                return;
            }
            class_243 dog_pos = this.dog.method_19538();
            float ext_radius = 2 * this.radius;
            class_238 impact_bb = new class_238(dog_pos.method_1023((double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f)), dog_pos.method_1031((double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f)));
            List entities = this.dog.method_37908().method_8335((class_1297)this.dog, impact_bb);
            if (entities.isEmpty()) {
                return;
            }
            for (class_1297 e : entities) {
                class_1309 living;
                if (e == this.dog) continue;
                if (e instanceof class_1309 && DogAllyCheck.isAlliedToDog(this.dog, (class_1297)(living = (class_1309)e), owner)) {
                    this.lightlyKnockback(owner, e, ext_radius);
                    continue;
                }
                this.hurtAndKnockback(owner, e, ext_radius);
            }
        }

        private double calculateImpactValue(class_243 dog_pos, class_1297 e, int hurt_radius) {
            double far_percent = Math.sqrt(e.method_5707(dog_pos)) / (double)hurt_radius;
            if (far_percent > 1.0) {
                return -1.0;
            }
            double close_percent = 1.0 - far_percent;
            float seen_percent = class_1927.method_17752((class_243)dog_pos, (class_1297)e);
            double impact_value = (double)seen_percent * close_percent;
            return impact_value;
        }

        private void lightlyKnockback(class_1309 owner, class_1297 e, float hurt_radius) {
            class_243 dog_pos = this.dog.method_19538();
            double impact_value = this.calculateImpactValue(dog_pos, e, this.radius);
            if (impact_value <= 0.0) {
                return;
            }
            impact_value = class_3532.method_15350((double)impact_value, (double)0.0, (double)1.0);
            double max_pushback = 0.8;
            this.knockbackEntity(dog_pos, e, 0.8 * impact_value);
        }

        private void knockbackEntity(class_243 dog_pos, class_1297 e, double knockback_value) {
            class_3222 player;
            class_1309 living;
            if (e instanceof class_1309 && (knockback_value *= 1.0 - (living = (class_1309)e).method_45325(class_5134.field_51580)) < 0.0) {
                knockback_value = 0.0;
            }
            class_243 e_pos = e instanceof class_1541 ? e.method_19538() : e.method_33571();
            class_243 knock_vec = e_pos.method_1020(dog_pos).method_1029().method_1021(knockback_value);
            class_243 knock_movement = e.method_18798().method_1019(knock_vec);
            e.method_18799(knock_movement);
            if (e instanceof class_3222 && this.canKnockbackPlayer(player = (class_3222)e)) {
                this.toSendKnockback.put(player, knock_vec);
            }
        }

        private boolean canKnockbackPlayer(class_3222 player) {
            if (player.method_7325()) {
                return false;
            }
            if (!player.method_7337()) {
                return true;
            }
            return !player.method_31549().field_7479;
        }

        private void hurtAndKnockback(class_1309 owner, class_1297 e, float hurt_radius) {
            class_243 dog_pos = this.dog.method_19538();
            double impact_value = this.calculateImpactValue(dog_pos, e, this.radius);
            if (impact_value <= 0.0) {
                return;
            }
            double t = impact_value * impact_value + impact_value;
            int base_damage = 7;
            double hurt_amount = 1.0 + t * 7.0 * (double)this.radius;
            e.method_5643(e.method_48923().method_48819((class_1297)this.dog, (class_1297)owner), (float)hurt_amount);
            this.knockbackEntity(dog_pos, e, (double)this.knockbackModifier * impact_value);
        }
    }
}

