/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class RescueDogTalent
extends TalentInstance {
    private boolean renderBox = true;
    private final int SEARCH_RADIUS = 12;
    private int tickTillSearch = 0;
    private int healCooldown = 0;

    public RescueDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.method_37908().field_9236) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (this.healCooldown > 0) {
            --this.healCooldown;
            return;
        }
        if (dog.readyForNonTrivialAction() && !dog.getMode().shouldAttack() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            class_1309 target = this.findHealTarget(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerRescueAction(dog, target);
            }
        }
    }

    private void triggerRescueAction(Dog dog, @Nonnull class_1309 target) {
        dog.triggerAction(new RescueAction(dog, this, target));
    }

    public int healCost(AbstractDog dog, class_1309 target) {
        int cost = this.level() >= 5 ? 10 : 20;
        return cost;
    }

    public float healAmount(AbstractDog dog, class_1309 target) {
        float bonus = 0.0f;
        float chance = dog.method_59922().method_43057();
        if (this.level() >= 3) {
            if ((double)chance > 0.8) {
                bonus = 3.0f;
            } else if ((double)chance > 0.55) {
                bonus = 2.0f;
            } else if ((double)chance > 0.25) {
                bonus = 1.0f;
            }
        }
        return (float)class_3532.method_15357((double)((double)this.level() * 1.5)) + bonus * 2.0f;
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    private void heal(AbstractDog dog, class_1309 e) {
        if (this.healCooldown > 0) {
            return;
        }
        dog.setDogHunger(dog.getDogHunger() - (float)this.healCost(dog, e));
        if (this.level() >= 5) {
            this.forceHealTarget(dog, e, this.healAmount(dog, e));
        } else {
            e.method_6025(this.healAmount(dog, e));
        }
        if (dog.method_37908() instanceof class_3218) {
            ((class_3218)dog.method_37908()).method_14199((class_2394)class_2398.field_11201, e.method_23317(), e.method_23318(), e.method_23321(), this.level * 8, (double)e.method_17681(), (double)0.8f, (double)e.method_17681(), 0.1);
        }
        this.healCooldown = dog.method_59922().method_43048(3) * 20;
    }

    private void forceHealTarget(AbstractDog dog, class_1309 e, float add) {
        if (add <= 0.0f) {
            return;
        }
        float h = e.method_6032();
        if (h > 0.0f) {
            e.method_6033(h + add);
        }
    }

    private boolean isTargetLowHealth(AbstractDog dog, class_1309 e) {
        return (double)e.method_6032() <= 8.0;
    }

    private boolean canAffordToHealTarget(AbstractDog dog, class_1309 e) {
        return dog.getDogHunger() - 10.0f >= (float)this.healCost(dog, e);
    }

    private boolean canHealTarget(AbstractDog dog, class_1309 e) {
        return dog.method_5858((class_1297)e) <= 5.0 && dog.method_5985().method_6369((class_1297)e);
    }

    private class_1309 findHealTarget(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<class_1309> healTargets = new ArrayList<class_1309>();
        Predicate<class_1309> lowHealthAndInWitness = e -> this.isTargetLowHealth(dog, (class_1309)e) && dog.method_5985().method_6369((class_1297)e);
        class_1309 owner = dog.method_35057();
        if (owner == null) {
            return null;
        }
        if (lowHealthAndInWitness.test(owner)) {
            healTargets.add(owner);
        }
        if (!(dogs = dog.method_37908().method_8390(AbstractDog.class, dog.method_5829().method_1009(12.0, 4.0, 12.0), d -> d.method_35057() == owner && lowHealthAndInWitness.test((class_1309)d))).isEmpty()) {
            healTargets.addAll(dogs);
        }
        if (!(wolves = dog.method_37908().method_8390(class_1493.class, dog.method_5829().method_1009(12.0, 4.0, 12.0), w -> w.method_35057() == owner && lowHealthAndInWitness.test((class_1309)w))).isEmpty()) {
            healTargets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.method_37908().method_8390(class_1657.class, dog.method_5829().method_1009(12.0, 4.0, 12.0), p -> p.method_5722((class_1297)owner) && lowHealthAndInWitness.test((class_1309)p))).isEmpty()) {
            healTargets.addAll(teamPlayers);
        }
        return this.selectHealTarget(dog, healTargets);
    }

    private class_1309 selectHealTarget(AbstractDog dog, ArrayList<class_1309> healTargets) {
        if (healTargets.isEmpty()) {
            return null;
        }
        class_1309 target = healTargets.get(0);
        double mindistanceSqr = target.method_5858((class_1297)dog);
        class_1309 owner = dog.method_35057();
        for (class_1309 i : healTargets) {
            if (owner == i) {
                return i;
            }
            double d = i.method_5858((class_1297)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    private boolean stillValidTarget(Dog dog, class_1309 target) {
        Dog d;
        if (!target.method_5805()) {
            return false;
        }
        if (!this.isTargetLowHealth(dog, target)) {
            return false;
        }
        if (!this.canAffordToHealTarget(dog, target)) {
            return false;
        }
        if (dog.method_5858((class_1297)target) > 400.0) {
            return false;
        }
        return !(target instanceof Dog) || !(d = (Dog)target).isDefeated();
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, class_2487 compound) {
        super.readFromNBT(dogIn, compound);
        this.renderBox = compound.method_10577("renderBox");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10556("renderBox", this.renderBox);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.RESCUE_DOG_RENDER.get()) {
            return this.renderBox;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.RESCUE_DOG_RENDER.get()) {
            this.renderBox = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.RESCUE_DOG_RENDER.get());
    }

    public boolean renderBox() {
        return this.renderBox;
    }

    public void setRenderBox(boolean render) {
        this.renderBox = render;
    }

    public static class RescueAction
    extends TriggerableAction {
        private RescueDogTalent talentInst;
        @Nonnull
        private class_1309 target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public RescueAction(Dog dog, RescueDogTalent talentInst, @Nonnull class_1309 target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public void tick() {
            if (this.dog.getMode().shouldAttack()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.method_5858((class_1297)this.target) > 4.0) {
                this.dog.method_5988().method_6226((class_1297)this.target, 10.0f, (float)this.dog.method_5978());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.method_60953() && !this.dog.method_5765()) {
                        this.dog.method_5942().method_6335((class_1297)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else if (this.talentInst.canHealTarget(this.dog, this.target)) {
                this.talentInst.heal(this.dog, this.target);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }
    }
}

