/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTags;
import doggytalents.TalentsOptions;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.Screens;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.DoggyToolsRangedAttack;
import doggytalents.common.talent.doggy_tools.ShootHandler;
import doggytalents.common.talent.doggy_tools.ToolActionEntries;
import doggytalents.common.talent.doggy_tools.tool_actions.ToolAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class DoggyToolsTalent
extends TalentInstance {
    private DoggyToolsItemHandler tools = new DoggyToolsItemHandler();
    private Map<class_1792, ToolAction> TOOL_ACTION_MAP;
    private boolean alwaysPickSlot0;

    public DoggyToolsTalent(Talent talentIn, int level) {
        super(talentIn, level);
    }

    public static int getSize(int level) {
        return class_3532.method_15340((int)level, (int)0, (int)5);
    }

    @Override
    public void init(AbstractDog dog) {
        this.TOOL_ACTION_MAP = ToolActionEntries.getToolActionMapFor((Dog)dog, this);
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    @Override
    public void remove(AbstractDog dog) {
        if (dog.method_37908().field_9236) {
            return;
        }
        dog.method_5673(class_1304.field_6173, class_1799.field_8037);
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            this.dropAllToolbar(dog);
        }
    }

    private void dropAllToolbar(AbstractDog dog) {
        for (int i = 0; i < this.tools.getSlots(); ++i) {
            class_1264.method_5449((class_1937)dog.method_37908(), (double)dog.method_23317(), (double)dog.method_23318(), (double)dog.method_23321(), (class_1799)this.tools.getStackInSlot(i));
            this.tools.setStackInSlot(i, class_1799.field_8037);
        }
    }

    @Override
    public void tick(AbstractDog d) {
        if (d.method_37908().field_9236) {
            return;
        }
        this.validateAndSync(d);
        if (!(d instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)d;
        this.updateMainHandItem(dog);
    }

    private void updateMainHandItem(Dog dog) {
        class_1309 owner;
        class_1799 mainHandItem;
        class_1799 firstTool;
        if (this.alwaysPickSlot0 && !(firstTool = this.tools.getStackInSlot(0)).method_7960()) {
            if (dog.method_6047() != firstTool && !this.isItemBlacklisted(firstTool)) {
                dog.method_6122(class_1268.field_5808, firstTool);
            }
            return;
        }
        if (dog.method_24345() || !dog.isDoingFine()) {
            mainHandItem = dog.method_6047();
            if (mainHandItem != null && !mainHandItem.method_7960()) {
                dog.method_5673(class_1304.field_6173, class_1799.field_8037);
            }
            return;
        }
        mainHandItem = dog.method_6047();
        if (dog.isBusy() || dog.method_5968() != null) {
            return;
        }
        if (mainHandItem != null && !mainHandItem.method_7960()) {
            dog.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        if ((owner = dog.method_35057()) == null || dog.method_5858((class_1297)owner) > (double)this.getMaxOwnerDistSqr()) {
            return;
        }
        this.pickActionTool(dog);
    }

    private void validateAndSync(AbstractDog d) {
        class_1799 stack = d.method_6047();
        if (!this.tools.hasStackRef(stack)) {
            d.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
    }

    private void pickTargetTool(Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(this.level()); ++i) {
            class_1799 stack = this.tools.getStackInSlot(i);
            if (stack.method_7960() || this.isItemBlacklisted(stack)) continue;
            class_1792 item = stack.method_7909();
            if (item instanceof class_1829) {
                dog.method_5673(class_1304.field_6173, stack);
                break;
            }
            if (item instanceof class_1743) {
                dog.method_5673(class_1304.field_6173, stack);
                break;
            }
            if (stack.method_31574(class_1802.field_8547)) {
                dog.method_5673(class_1304.field_6173, stack);
                break;
            }
            ShootHandler shoot_handler = DoggyToolsRangedAttack.getShootHandler(stack, dog);
            if (shoot_handler == ShootHandler.NONE) continue;
            dog.method_5673(class_1304.field_6173, stack);
            break;
        }
    }

    private void pickActionTool(Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(this.level()); ++i) {
            class_1792 item;
            ToolAction action;
            class_1799 stack = this.tools.getStackInSlot(i);
            if (stack.method_7960() || this.isItemBlacklisted(stack) || (action = this.TOOL_ACTION_MAP.get(item = stack.method_7909())) == null || !action.shouldUse()) continue;
            dog.method_5673(class_1304.field_6173, stack);
            dog.triggerAction(action);
            break;
        }
    }

    public DoggyToolsItemHandler getTools() {
        return this.tools;
    }

    @Override
    public class_1269 processInteract(AbstractDog d, class_1937 levek, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!(stack.method_7909() instanceof class_1810)) {
            return class_1269.field_5811;
        }
        if (!(d instanceof Dog)) {
            return class_1269.field_5811;
        }
        Dog dog = (Dog)d;
        if (!dog.method_37908().field_9236 && player instanceof class_3222) {
            class_3222 sP = (class_3222)player;
            Screens.openDoggyToolsScreen(sP, dog);
        }
        return class_1269.field_5812;
    }

    @Override
    public void onDogSetTarget(AbstractDog dogIn, @Nullable class_1309 newTarget, @Nullable class_1309 oldTarget) {
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (dog.method_37908().field_9236) {
            return;
        }
        if (this.alwaysPickSlot0) {
            return;
        }
        if (newTarget == null) {
            class_1799 mainHandItem = dog.method_6047();
            if (mainHandItem != null && !mainHandItem.method_7960()) {
                dog.method_5673(class_1304.field_6173, class_1799.field_8037);
            }
        } else {
            this.pickTargetTool(dog);
        }
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanUseTools();
    }

    @Override
    public Optional<IDogRangedAttackManager> getRangedAttack() {
        return Optional.of(new DoggyToolsRangedAttack());
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        class_2487 tag = new class_2487();
        tag.method_10566("tool_inv", (class_2520)this.tools.serializeNBT((class_7225.class_7874)dogIn.method_56673()));
        tag.method_10556("pickFirstTool", this.alwaysPickSlot0);
        compound.method_10566("doggy_tools", (class_2520)tag);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, class_2487 compound) {
        super.readFromNBT(dogIn, compound);
        class_2487 tag = compound.method_10562("doggy_tools");
        if (tag == null) {
            return;
        }
        this.alwaysPickSlot0 = tag.method_10577("pickFirstTool");
        class_2487 inv_tag = tag.method_10562("tool_inv");
        if (inv_tag != null) {
            this.tools.deserializeNBT((class_7225.class_7874)dogIn.method_56673(), inv_tag);
        }
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, class_1297 target) {
        class_1799 stack = dogIn.method_6047();
        class_1792 item = stack.method_7909();
        if (!(target instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)target;
        if (this.isItemBlacklisted(stack)) {
            return;
        }
        item.method_7873(stack, living, (class_1309)dogIn);
        item.method_59978(stack, living, (class_1309)dogIn);
    }

    public int getMaxOwnerDistSqr() {
        return 64;
    }

    private boolean isItemBlacklisted(class_1799 stack) {
        return stack.method_31573(DoggyTags.DOGGY_TOOLS_BLACKLIST);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.DOGGY_TOOLS_EXC.get()) {
            return this.alwaysPickSlot0;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.DOGGY_TOOLS_EXC.get()) {
            this.alwaysPickSlot0 = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.DOGGY_TOOLS_EXC.get());
    }

    public boolean pickFirstTool() {
        return this.alwaysPickSlot0;
    }

    public void setPickFirstTool(boolean val) {
        this.alwaysPickSlot0 = val;
    }
}

