/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.fabric_helper.util.FabricUtil;
import doggytalents.common.util.CachedSearchUtil.CachedSearchPool;
import doggytalents.common.util.DogUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_7;

public class CachedSearchUtil {
    public static void resetPool(class_1937 level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    pool.setPoolValue(level, i, j, k, (byte)0);
                }
            }
        }
    }

    public static void populatePoolRaw(Dog dog, class_2338 targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        class_2338 b0 = targetPos;
        class_2338 bMin = b0.method_10069(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        InferTypeContext infer_ctx = InferTypeContext.forTeleport(dog.method_35057());
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    class_7 type = WalkNodeEvaluatorDelegate.getTypeDelegate((class_1922)dog.method_37908(), bMin.method_10069(i, j, k));
                    byte val = CachedSearchUtil.inferType(dog, type, infer_ctx);
                    pool.setPoolValue(dog.method_37908(), i, j, k, val);
                }
            }
        }
    }

    public static void populatePoolRaw(class_1937 level, List<Dog> dogs, class_2338 targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        class_2338 b0 = targetPos;
        class_2338 bMin = b0.method_10069(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    class_7 type = WalkNodeEvaluatorDelegate.getTypeDelegate((class_1922)level, bMin.method_10069(i, j, k));
                    byte val = CachedSearchUtil.inferType(dogs, type);
                    pool.setPoolValue(level, i, j, k, val);
                }
            }
        }
    }

    public static void populateCollideOwner(class_1309 owner, int radiusXZ, int radiusY, CachedSearchPool pool) {
        double DISTANCE_AWAY = 1.5;
        float a1 = owner.method_5791();
        float dx1 = -class_3532.method_15374((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = class_3532.method_15362((float)(a1 * ((float)Math.PI / 180)));
        class_243 ownerLookUnitVector = new class_243((double)dx1, 0.0, (double)dz1);
        class_243 ownerPosRelative2d = new class_243((double)radiusXZ, 0.0, (double)radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int k = 0; k <= maxXZ; ++k) {
                double x = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(new class_243((double)i, 0.0, (double)k), ownerPosRelative2d, ownerLookUnitVector);
                if (x < 0.0 || x > 1.5) continue;
                for (int j = 0; j <= maxY; ++j) {
                    pool.setPoolValue(owner.method_37908(), i, j, k, (byte)5);
                }
            }
        }
        int cXZ = radiusXZ;
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                for (int j = 0; j <= maxY; ++j) {
                    pool.setPoolValue(owner.method_37908(), cXZ + i, j, cXZ + k, (byte)5);
                }
            }
        }
    }

    public static void populateBlockCollision(Dog dog, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int bbWExt = class_3532.method_15384((double)((double)(dog.method_17681() - 1.0f) * 0.5));
        int bbHExt = class_3532.method_15384((double)((double)(dog.method_17682() - 1.0f) * 0.5));
        if (bbWExt <= 0 && bbHExt <= 0) {
            return;
        }
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(dog.method_37908(), i, j, k) != 2) continue;
                    for (int i1 = i - bbWExt; i1 <= i + bbWExt; ++i1) {
                        for (int j1 = j - bbHExt; j1 <= j; ++j1) {
                            for (int k1 = k - bbWExt; k1 <= k + bbWExt; ++k1) {
                                if (pool.getPoolValue(dog.method_37908(), i1, j1, k1) == 2 || pool.getPoolValue(dog.method_37908(), i1, j1, k1) == 6) continue;
                                pool.setPoolValue(dog.method_37908(), i1, j1, k1, (byte)5);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateBlockCollision(class_1937 level, List<Dog> dogs, int radiusXZ, int radiusY, CachedSearchPool pool) {
        Dog dog = DogUtil.findBiggestDog(dogs);
        int bbWExt = class_3532.method_15384((double)((double)(dog.method_17681() - 1.0f) * 0.5));
        int bbHExt = class_3532.method_15384((double)((double)(dog.method_17682() - 1.0f) * 0.5));
        if (bbWExt <= 0 && bbHExt <= 0) {
            return;
        }
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(level, i, j, k) != 2) continue;
                    for (int i1 = i - bbWExt; i1 <= i + bbWExt; ++i1) {
                        for (int j1 = j - bbHExt; j1 <= j; ++j1) {
                            for (int k1 = k - bbWExt; k1 <= k + bbWExt; ++k1) {
                                if (pool.getPoolValue(level, i1, j1, k1) == 2 || pool.getPoolValue(level, i1, j1, k1) == 6) continue;
                                pool.setPoolValue(level, i1, j1, k1, (byte)5);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateDangerPos(class_1937 level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(level, i, j, k) != -1) continue;
                    for (int i1 = i - 1; i1 <= i + 1; ++i1) {
                        for (int j1 = j - 1; j1 <= j + 1; ++j1) {
                            for (int k1 = k - 1; k1 <= k + 1; ++k1) {
                                if (pool.getPoolValue(level, i1, j1, k1) != 1) continue;
                                pool.setPoolValue(level, i1, j1, k1, (byte)3);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateWalkablePos(class_1937 level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    byte val = pool.getPoolValue(level, i, j, k);
                    byte val_below = pool.getPoolValue(level, i, j - 1, k);
                    if (val != 1 || val_below != 2) continue;
                    pool.setPoolValue(level, i, j, k, (byte)4);
                }
            }
        }
    }

    public static int countWalkablePos(class_1937 level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        int count = 0;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    byte val = pool.getPoolValue(level, i, j, k);
                    if (val != 4) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static void populatePool(Dog dog, class_2338 targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        CachedSearchUtil.resetPool(dog.method_37908(), radiusXZ, radiusY, pool);
        CachedSearchUtil.populatePoolRaw(dog, targetPos, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateBlockCollision(dog, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateDangerPos(dog.method_37908(), radiusXZ, radiusY, pool);
        CachedSearchUtil.populateWalkablePos(dog.method_37908(), radiusXZ, radiusY, pool);
    }

    public static void populatePool(class_1937 level, List<Dog> dogs, class_2338 targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        CachedSearchUtil.resetPool(level, radiusXZ, radiusY, pool);
        CachedSearchUtil.populatePoolRaw(level, dogs, targetPos, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateBlockCollision(level, dogs, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateDangerPos(level, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateWalkablePos(level, radiusXZ, radiusY, pool);
    }

    public static List<class_2338> collectSafePos(class_1937 level, class_2338 targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        ArrayList<class_2338> safePosList = new ArrayList<class_2338>();
        class_2338 b0 = targetPos;
        class_2338 bMin = b0.method_10069(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2 - 1;
        int maxY = radiusY * 2 - 1;
        for (int i = 1; i <= maxXZ; ++i) {
            for (int j = 1; j <= maxY; ++j) {
                for (int k = 1; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(level, i, j, k) != 4) continue;
                    class_2338 pos = bMin.method_10069(i, j, k);
                    safePosList.add(pos);
                }
            }
        }
        return safePosList;
    }

    public static class_2338 getRandomSafePosUsingPool(Dog dog, class_2338 targetPos, int realRadiusXZ, int realRadiusY) {
        List<class_2338> safePosList = CachedSearchUtil.getAllSafePosUsingPool(dog, targetPos, realRadiusXZ, realRadiusY);
        if (safePosList.isEmpty()) {
            return null;
        }
        int index = dog.method_59922().method_43048(safePosList.size());
        return safePosList.get(index);
    }

    public static class_2338 getRandomSafePosUsingPoolExcludeInfrontOfOwner(Dog dog, class_1309 owner, class_2338 targetPos, int realRadiusXZ, int realRadiusY) {
        List<class_2338> safePosList = CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(dog, owner, targetPos, realRadiusXZ, realRadiusY);
        if (safePosList.isEmpty()) {
            return null;
        }
        int index = dog.method_59922().method_43048(safePosList.size());
        return safePosList.get(index);
    }

    public static List<class_2338> getAllSafePosUsingPool(Dog dog, class_2338 targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(dog, targetPos, poolXZ, poolY, pool);
        List<class_2338> safePosList = CachedSearchUtil.collectSafePos(dog.method_37908(), targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static List<class_2338> getAllSafePosUsingPoolExcludeInfrontOfOwner(Dog dog, class_1309 owner, class_2338 targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(dog, targetPos, poolXZ, poolY, pool);
        CachedSearchUtil.populateCollideOwner(owner, poolXZ, poolY, pool);
        List<class_2338> safePosList = CachedSearchUtil.collectSafePos(dog.method_37908(), targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static List<class_2338> getAllSafePosUsingPool(class_1937 level, List<Dog> dogs, class_2338 targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(level, dogs, targetPos, poolXZ, poolY, pool);
        List<class_2338> safePosList = CachedSearchUtil.collectSafePos(level, targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static List<class_2338> getAllSafePosUsingPoolExcludeInfrontOfOwner(class_1937 level, List<Dog> dogs, class_1309 owner, class_2338 targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(level, dogs, targetPos, poolXZ, poolY, pool);
        CachedSearchUtil.populateCollideOwner(owner, poolXZ, poolY, pool);
        List<class_2338> safePosList = CachedSearchUtil.collectSafePos(level, targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static String dumpPool(class_1937 level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        StringBuilder builder = new StringBuilder();
        for (int i = maxY; i >= 0; --i) {
            builder.append("Layer " + i + ": X -> \n");
            for (int j = 0; j <= maxXZ; ++j) {
                builder.append("-" + j + "-  ");
                for (int k = 0; k <= maxXZ; ++k) {
                    builder.append(pool.getPoolValue(level, k, i, j) + ", ");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public static byte inferType(Dog dog, class_7 type, InferTypeContext context) {
        if ((type = dog.inferType(type, context)) == class_7.field_12) {
            return 4;
        }
        if (type == class_7.field_7) {
            return 1;
        }
        if (DogUtil.isDangerPathType(type)) {
            return -1;
        }
        if (type == class_7.field_22) {
            return 2;
        }
        return 3;
    }

    public static byte inferType(List<Dog> dogs, class_7 type) {
        boolean all_dog_OK = true;
        for (Dog dog : dogs) {
            boolean is_ok = false;
            class_7 infer_type = dog.inferType(type, InferTypeContext.forTeleport());
            if (infer_type == class_7.field_12) {
                is_ok = true;
            }
            if (is_ok) continue;
            all_dog_OK = false;
            break;
        }
        if (all_dog_OK) {
            return 4;
        }
        if (type == class_7.field_7) {
            return 1;
        }
        if (FabricUtil.getDanger(type) != null) {
            return -1;
        }
        if (type == class_7.field_22) {
            return 2;
        }
        return 3;
    }

    private static class WalkNodeEvaluatorDelegate
    extends class_14 {
        private WalkNodeEvaluatorDelegate() {
        }

        public static class_7 getTypeDelegate(class_1922 getter, class_2338 pos) {
            return class_14.method_58((class_1922)getter, (class_2338)pos);
        }
    }
}

