/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.common.entity.Dog;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class DogGreedyFireSafeSearchPath
extends class_11 {
    private ArrayList<class_9> nodes;
    private Dog dog;
    public boolean finished;
    private int maxLength;
    private class_9 startNode;
    private int walkableCount = 0;

    private DogGreedyFireSafeSearchPath(Dog dog, ArrayList<class_9> nodes, int maxLength) {
        super(nodes, dog.method_24515(), false);
        this.nodes = nodes;
        this.dog = dog;
        this.maxLength = maxLength;
    }

    public static DogGreedyFireSafeSearchPath create(Dog dog, int maxLength) {
        Optional<class_9> start_node = DogGreedyFireSafeSearchPath.getStartNode(dog);
        if (!start_node.isPresent()) {
            return null;
        }
        ArrayList<class_9> initNodes = new ArrayList<class_9>(maxLength);
        initNodes.add(start_node.get());
        DogGreedyFireSafeSearchPath ret = new DogGreedyFireSafeSearchPath(dog, initNodes, maxLength);
        ret.startNode = start_node.get();
        Optional<class_9> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(ret);
        if (!node_optional.isPresent()) {
            return null;
        }
        initNodes.clear();
        initNodes.add(node_optional.get());
        return ret;
    }

    private static Optional<class_9> getStartNode(Dog dog) {
        class_2338 dog_b0 = dog.method_24515();
        if (DogGreedyFireSafeSearchPath.isValidStart(dog, dog_b0)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(dog_b0);
        }
        class_238 dog_bb = dog.method_5829();
        int min_x = class_3532.method_15357((double)dog_bb.field_1323);
        int min_z = class_3532.method_15357((double)dog_bb.field_1321);
        int max_x = class_3532.method_15357((double)dog_bb.field_1320);
        int max_z = class_3532.method_15357((double)dog_bb.field_1324);
        for (int i = min_x; i <= max_x; ++i) {
            for (int j = min_z; j <= max_z; ++j) {
                class_2338 check_b0 = new class_2338(i, dog_b0.method_10264(), j);
                if (!DogGreedyFireSafeSearchPath.isValidStart(dog, check_b0)) continue;
                return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(check_b0);
            }
        }
        return Optional.empty();
    }

    private static boolean isValidStart(Dog dog, class_2338 pos) {
        class_2338 pos_below = pos.method_10074();
        class_2680 state_under = dog.method_37908().method_8320(pos_below);
        return state_under.method_26234((class_1922)dog.method_37908(), pos_below);
    }

    private static Optional<class_9> blockPosToNodeOptional(class_2338 pos) {
        return Optional.of(new class_9(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public void method_44() {
        super.method_44();
        if (this.finished) {
            return;
        }
        boolean append_result = this.tryAppendPath();
        if (!append_result) {
            this.finished = true;
        }
    }

    public int getWalkableCount() {
        return this.walkableCount;
    }

    public boolean method_46() {
        if (this.finished) {
            return true;
        }
        return this.method_39() >= this.nodes.size();
    }

    public boolean tryAppendPath() {
        if (this.method_39() >= this.maxLength) {
            return false;
        }
        Optional<class_9> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(this);
        if (!node_optional.isPresent()) {
            return false;
        }
        class_9 node = node_optional.get();
        if (node.field_41 != class_7.field_12 && this.walkableCount > 0) {
            return false;
        }
        this.nodes.add(node);
        if (node.field_41 == class_7.field_12) {
            ++this.walkableCount;
        }
        return true;
    }

    private boolean containNode(class_2338 node0) {
        for (class_9 node : this.nodes) {
            if (!node.equals((Object)new class_9(node0.method_10263(), node0.method_10264(), node0.method_10260()))) continue;
            return true;
        }
        return false;
    }

    private static Optional<class_9> scanSurroundingForNextPos(DogGreedyFireSafeSearchPath path) {
        float malus;
        boolean is_last_resort;
        int j;
        int i;
        if (path.nodes.isEmpty()) {
            return Optional.empty();
        }
        class_2338 b0 = path.nodes.get(path.nodes.size() - 1).method_22879();
        float malus_min = Float.MAX_VALUE;
        class_9 node_chosen = null;
        boolean[] BLOCKED_0_Z = new boolean[2];
        boolean[] BLOCKED_X_0 = new boolean[2];
        class_7 pathtype_above = class_14.method_57625((class_1308)path.dog, (class_2338)b0.method_10084());
        class_9 last_resort = null;
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean clear_walkable;
                boolean is_blocked;
                class_9 node;
                if (i == 0 && j == 0 || i * j != 0 || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.method_10069(i, 0, j))) == null) continue;
                boolean bl = is_blocked = node.field_41 == class_7.field_22 || node.field_39 > b0.method_10264() && pathtype_above == class_7.field_22;
                if (is_blocked) {
                    if (i != 0) {
                        BLOCKED_X_0[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    BLOCKED_0_Z[j > 0 ? 1 : 0] = true;
                    continue;
                }
                boolean bl2 = clear_walkable = node.field_41 == class_7.field_12 && pathtype_above == class_7.field_7;
                if (clear_walkable) {
                    return Optional.of(node);
                }
                boolean bl3 = is_last_resort = node.field_39 > b0.method_10264() && pathtype_above != class_7.field_22;
                if (is_last_resort) {
                    last_resort = node;
                    if (i != 0) {
                        BLOCKED_X_0[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    BLOCKED_0_Z[j > 0 ? 1 : 0] = true;
                    continue;
                }
                malus = path.dog.method_5944(node.field_41);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean is_clearly_walkable;
                class_9 node;
                boolean diagonal_blocked;
                if (i == 0 && j == 0 || i * j == 0) continue;
                boolean bl = BLOCKED_0_Z[j > 0 ? 1 : 0] && BLOCKED_X_0[i > 0 ? 1 : 0] ? true : (diagonal_blocked = false);
                if (diagonal_blocked || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.method_10069(i, 0, j))) == null || node.field_41 == class_7.field_22) continue;
                boolean bl4 = is_clearly_walkable = node.field_41 == class_7.field_12 && pathtype_above == class_7.field_7;
                if (is_clearly_walkable) {
                    return Optional.of(node);
                }
                boolean bl5 = is_last_resort = node.field_39 > b0.method_10264() && pathtype_above != class_7.field_22;
                if (is_last_resort) {
                    last_resort = node;
                    continue;
                }
                malus = path.dog.method_5944(node.field_41);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        if (node_chosen != null) {
            return Optional.of(node_chosen);
        }
        if (last_resort != null) {
            return Optional.of(last_resort);
        }
        return Optional.empty();
    }

    private static class_9 checkPos(DogGreedyFireSafeSearchPath path, class_2338 pos) {
        class_2338.class_2339 b1 = pos.method_25503();
        class_7 b1_type = class_14.method_57625((class_1308)path.dog, (class_2338)b1.method_25503());
        int offsetY = 0;
        if (b1_type == class_7.field_22) {
            offsetY = 1;
        } else if (b1_type == class_7.field_7) {
            offsetY = -1;
        }
        if (offsetY != 0) {
            b1.method_10100(0, offsetY, 0);
            b1_type = class_14.method_57625((class_1308)path.dog, (class_2338)b1.method_25503());
        }
        if (b1_type == class_7.field_22) {
            class_9 ret_node = new class_9(b1.method_10263(), b1.method_10264(), b1.method_10260());
            ret_node.field_41 = b1_type;
            return ret_node;
        }
        if (path.containNode((class_2338)b1)) {
            return null;
        }
        if (path.startNode.method_22879().equals((Object)b1)) {
            return null;
        }
        if (b1_type == class_7.field_12) {
            class_9 ret_node = new class_9(b1.method_10263(), b1.method_10264(), b1.method_10260());
            ret_node.field_41 = b1_type;
            return ret_node;
        }
        if (b1_type == class_7.field_7) {
            return null;
        }
        float malus = path.dog.method_5944(b1_type);
        if (malus < 0.0f) {
            return null;
        }
        class_9 ret_node = new class_9(b1.method_10263(), b1.method_10264(), b1.method_10260());
        ret_node.field_41 = b1_type;
        return ret_node;
    }
}

