/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.variant;

import doggytalents.common.util.Util;
import java.util.Optional;
import net.minecraft.class_2960;

public class DogVariant {
    public static final DogVariant PALE = new DogVariant(DogVariant.propsVanilla("pale").icon(Util.getResource("textures/entity/dog/classical_icon/pale.png")).guiColor(-2435112));
    public static final DogVariant MISSING = new DogVariant(DogVariant.props("missing").icon(Util.getResource("textures/entity/dog/classical_icon/pale.png")).guiColor(-43691));
    private final class_2960 id;
    private final class_2960 texture;
    private final String translation;
    private final boolean isVanila;
    private Optional<class_2960> icon;
    private int guiColor;
    private Optional<class_2960> glowingOverlay;
    private Optional<class_2960> customInjuredTexture;
    private final boolean burnsPetter;
    private final boolean preventWetShade;

    public DogVariant(Props props) {
        this.id = props.name;
        this.texture = DogVariant.createTextureLoc(props);
        this.translation = DogVariant.createTranslationKey(props);
        this.isVanila = props.namespaceType == NamespaceType.VANILLA;
        this.icon = props.icon;
        this.guiColor = props.guiColor;
        this.glowingOverlay = props.glowingOverlay;
        this.customInjuredTexture = props.customInjuredTexture;
        this.burnsPetter = props.burnsPetter;
        this.preventWetShade = props.preventWetShade;
    }

    private static class_2960 createTextureLoc(Props props) {
        if (props.namespaceType == NamespaceType.DTN) {
            return Util.getResource("textures/entity/dog/classical/compl/wolf_" + props.name.method_12832() + ".png");
        }
        if (props.namespaceType == NamespaceType.VANILLA) {
            return Util.getResource("textures/entity/dog/classical/wolf_" + props.name.method_12832() + ".png");
        }
        if (props.customTexture.isPresent()) {
            return Util.modifyPath(props.customTexture.get(), x -> x + ".png");
        }
        return Util.getResource(props.name.method_12836(), "textures/entity/dog/custom_variants/wolf_" + props.name.method_12832() + ".png");
    }

    private static String createTranslationKey(Props props) {
        if (props.namespaceType == NamespaceType.DTN) {
            return "dog.classical.variant.compl." + props.name.method_12832();
        }
        if (props.namespaceType == NamespaceType.VANILLA) {
            return "dog.classical.variant." + props.name.method_12832();
        }
        if (props.customTranslation.isPresent()) {
            return props.customTranslation.get();
        }
        return "dog.classical.variant.custom." + props.name.method_12836() + "." + props.name.method_12832();
    }

    public class_2960 id() {
        return this.id;
    }

    public class_2960 texture() {
        return this.texture;
    }

    public Optional<class_2960> icon() {
        return this.icon;
    }

    public int guiColor() {
        return this.guiColor;
    }

    public String translation() {
        return this.translation;
    }

    public Optional<class_2960> glowingOverlay() {
        return this.glowingOverlay;
    }

    public Optional<class_2960> customInjuredTexture() {
        return this.customInjuredTexture;
    }

    public boolean burnsPetter() {
        return this.burnsPetter;
    }

    public boolean preventWetShade() {
        return this.preventWetShade;
    }

    public static Props propsVanilla(String name) {
        return new Props(Util.getVanillaResource(name), NamespaceType.VANILLA);
    }

    public static Props props(String name) {
        return new Props(Util.getResource(name), NamespaceType.DTN);
    }

    public static Props props(class_2960 name) {
        if (name.method_12836().equals("doggytalents")) {
            return DogVariant.props(name.method_12832());
        }
        if (name.method_12836().equals("minecraft")) {
            return DogVariant.propsVanilla(name.method_12832());
        }
        return new Props(name, NamespaceType.OTHER);
    }

    public static class Props {
        private final NamespaceType namespaceType;
        private final class_2960 name;
        private Optional<class_2960> icon = Optional.empty();
        private int guiColor = -2435112;
        private Optional<class_2960> customTexture = Optional.empty();
        private Optional<String> customTranslation = Optional.empty();
        private Optional<class_2960> glowingOverlay = Optional.empty();
        private Optional<class_2960> customInjuredTexture = Optional.empty();
        private boolean burnsPetter = false;
        private boolean preventWetShade = false;

        private Props(class_2960 name, NamespaceType namespaceType) {
            this.name = name;
            this.namespaceType = namespaceType;
        }

        public Props icon(class_2960 icon) {
            this.customTexture = Optional.of(icon);
            return this;
        }

        public Props guiColor(int color) {
            this.guiColor = color;
            return this;
        }

        public Props customTexture(class_2960 texture) {
            this.customTexture = Optional.of(texture);
            return this;
        }

        public Props customTranslation(String string) {
            this.customTranslation = Optional.of(string);
            return this;
        }

        public Props glowingOverlay(class_2960 overlay) {
            if (overlay == null) {
                return this;
            }
            this.glowingOverlay = Optional.of(overlay);
            return this;
        }

        public Props customInjuredTexture(class_2960 texture) {
            if (texture == null) {
                return this;
            }
            this.customInjuredTexture = Optional.of(texture);
            return this;
        }

        public Props burnsPetter() {
            this.burnsPetter = true;
            return this;
        }

        public Props preventWetShade() {
            this.preventWetShade = true;
            return this;
        }
    }

    public static enum NamespaceType {
        VANILLA,
        DTN,
        OTHER;

    }
}

