/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.gui.screens;

import com.bokmcdok.butterflies.client.texture.ButterflyTextures;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyZhuangziScreen
extends Screen {
    private List<FormattedCharSequence> cache = Collections.emptyList();

    public ButterflyZhuangziScreen() {
        super(GameNarrator.NO_TITLE);
    }

    protected void init() {
        super.init();
        this.createMenuControls();
    }

    protected void createMenuControls() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, 196, 200, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int x, int y, float unknown) {
        super.render(guiGraphics, x, y, unknown);
        int i = (this.width - 192) / 2;
        guiGraphics.blit(RenderType::guiTextured, ButterflyTextures.BOOK, i, 2, 0.0f, 0.0f, 192, 192, 256, 256);
        if (this.cache.isEmpty()) {
            MutableComponent formattedText = Component.translatable((String)"gui.butterflies.zhuangzi");
            this.cache = this.font.split((FormattedText)formattedText, 114);
        }
        int cachedPageSize = Math.min(14, this.cache.size());
        for (int line = 0; line < cachedPageSize; ++line) {
            FormattedCharSequence formattedCharSequence = this.cache.get(line);
            guiGraphics.drawString(this.font, formattedCharSequence, i + 36, 32 + line * 9, 0, false);
        }
    }
}

